/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.worker;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.help.NewVersionDialog;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionWorker
extends SwingWorker<List<Version>, Void> {
    private static final Log LOGGER = LogFactory.getLog(VersionWorker.class);
    private final JabRefFrame mainFrame;
    private final boolean manualExecution;
    private final Version installedVersion;
    private final Version toBeIgnored;

    public VersionWorker(JabRefFrame mainFrame, boolean manualExecution, Version installedVersion, Version toBeIgnored) {
        this.mainFrame = Objects.requireNonNull(mainFrame);
        this.manualExecution = manualExecution;
        this.installedVersion = Objects.requireNonNull(installedVersion);
        this.toBeIgnored = Objects.requireNonNull(toBeIgnored);
    }

    @Override
    protected List<Version> doInBackground() throws Exception {
        try {
            return Version.getAllAvailableVersions();
        }
        catch (IOException ioException) {
            LOGGER.warn("Could not connect to the updateserver.", ioException);
            return Collections.emptyList();
        }
    }

    @Override
    public void done() {
        if (this.isCancelled()) {
            return;
        }
        try {
            List availableVersions = (List)this.get();
            if (availableVersions.isEmpty()) {
                this.showConnectionError();
            } else {
                this.showUpdateInfo(availableVersions);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error while checking for updates", e);
        }
    }

    private void showConnectionError() {
        String couldNotConnect = Localization.lang("Could not connect to the update server.", new String[0]);
        String tryLater = Localization.lang("Please try again later and/or check your network connection.", new String[0]);
        if (this.manualExecution) {
            JOptionPane.showMessageDialog(this.mainFrame, couldNotConnect + "\n" + tryLater, couldNotConnect, 0);
        }
        this.mainFrame.output(couldNotConnect + " " + tryLater);
    }

    private void showUpdateInfo(List<Version> availableVersions) {
        Optional<Version> newerVersion = this.installedVersion.shouldBeUpdatedTo(availableVersions);
        if (!newerVersion.isPresent() || newerVersion.get().equals(this.toBeIgnored) && !this.manualExecution) {
            String upToDate = Localization.lang("JabRef is up-to-date.", new String[0]);
            if (this.manualExecution) {
                JOptionPane.showMessageDialog(this.mainFrame, upToDate, upToDate, 1);
            }
            this.mainFrame.output(upToDate);
        } else {
            new NewVersionDialog(this.mainFrame, this.installedVersion, newerVersion.get());
        }
    }
}

