/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.util.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    private final boolean clockwise;
    private Rectangle verticalViewR = new Rectangle();
    private Rectangle verticalIconR = new Rectangle();
    private Rectangle verticalTextR = new Rectangle();

    public VerticalLabelUI(boolean clockwise) {
        this.clockwise = clockwise;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String result = text;
        this.verticalViewR = VerticalLabelUI.transposeRectangle(viewR, this.verticalViewR);
        this.verticalIconR = VerticalLabelUI.transposeRectangle(iconR, this.verticalIconR);
        this.verticalTextR = VerticalLabelUI.transposeRectangle(textR, this.verticalTextR);
        result = super.layoutCL(label, fontMetrics, result, icon, this.verticalViewR, this.verticalIconR, this.verticalTextR);
        VerticalLabelUI.copyRectangle(this.verticalViewR, viewR);
        VerticalLabelUI.copyRectangle(this.verticalIconR, iconR);
        VerticalLabelUI.copyRectangle(this.verticalTextR, textR);
        return result;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.clockwise) {
            g2.rotate(1.5707963267948966, (double)c.getSize().width / 2.0, (double)c.getSize().width / 2.0);
        } else {
            g2.rotate(-1.5707963267948966, (double)c.getSize().height / 2.0, (double)c.getSize().height / 2.0);
        }
        super.paint(g2, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return VerticalLabelUI.transposeDimension(super.getPreferredSize(c));
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return VerticalLabelUI.transposeDimension(super.getMaximumSize(c));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return VerticalLabelUI.transposeDimension(super.getMinimumSize(c));
    }

    private static Dimension transposeDimension(Dimension from) {
        return new Dimension(from.height, from.width + 2);
    }

    private static Rectangle transposeRectangle(Rectangle from, Rectangle to) {
        Rectangle destination = to;
        if (destination == null) {
            destination = new Rectangle();
        }
        destination.x = from.y;
        destination.y = from.x;
        destination.width = from.height;
        destination.height = from.width;
        return destination;
    }

    private static void copyRectangle(Rectangle from, Rectangle to) {
        if (to == null) {
            return;
        }
        to.x = from.x;
        to.y = from.y;
        to.width = from.width;
        to.height = from.height;
    }
}

