/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.util.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JTextFieldWithPlaceholder
extends JTextField
implements KeyListener {
    private final String textWhenNotFocused;

    public JTextFieldWithPlaceholder(String content, String placeholder) {
        this(placeholder);
        this.setText(content);
    }

    public JTextFieldWithPlaceholder(String placeholder) {
        this.setEditable(true);
        this.setText("");
        this.textWhenNotFocused = placeholder;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getText().isEmpty()) {
            int height = this.getHeight();
            Font prev = graphics.getFont();
            Color prevColor = graphics.getColor();
            graphics.setColor(UIManager.getColor("textInactiveText"));
            int textHeight = graphics.getFontMetrics().getHeight();
            int textBottom = (height - textHeight) / 2 + textHeight - 4;
            int x = this.getInsets().left;
            Graphics2D g2d = (Graphics2D)graphics;
            RenderingHints hints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.textWhenNotFocused, x, textBottom);
            g2d.setRenderingHints(hints);
            graphics.setFont(prev);
            graphics.setColor(prevColor);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.getText().isEmpty()) {
            this.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.getText().isEmpty()) {
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.getText().isEmpty()) {
            this.repaint();
        }
    }
}

