/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import net.sf.jabref.Globals;

public class WindowLocation {
    private final String posXKey;
    private final String posYKey;
    private final String sizeXKey;
    private final String sizeYKey;
    private final Window window;

    public WindowLocation(Window window, String posXKey, String posYKey, String sizeXKey, String sizeYKey) {
        this.window = window;
        this.posXKey = posXKey;
        this.posYKey = posYKey;
        this.sizeXKey = sizeXKey;
        this.sizeYKey = sizeYKey;
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WindowLocation.this.storeCurrentWindowLocation();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                WindowLocation.this.storeCurrentWindowLocation();
            }
        });
    }

    public void displayWindowAtStoredLocation() {
        WindowPosition storedPosition = this.getStoredLocation();
        if (!this.isDisplayable(storedPosition)) {
            storedPosition = this.adaptPosition(storedPosition);
        }
        this.setWindowLocation(storedPosition);
    }

    public void storeCurrentWindowLocation() {
        Frame frame;
        if (this.window instanceof Frame && (frame = (Frame)this.window).getExtendedState() == 6) {
            return;
        }
        Point location = this.window.getLocation();
        Dimension dimensions = this.window.getSize();
        Globals.prefs.putInt(this.posXKey, location.x);
        Globals.prefs.putInt(this.posYKey, location.y);
        Globals.prefs.putInt(this.sizeXKey, dimensions.width);
        Globals.prefs.putInt(this.sizeYKey, dimensions.height);
    }

    private WindowPosition getStoredLocation() {
        int sizeX = Globals.prefs.getInt(this.sizeXKey);
        int sizeY = Globals.prefs.getInt(this.sizeYKey);
        int posX = Globals.prefs.getInt(this.posXKey);
        int posY = Globals.prefs.getInt(this.posYKey);
        return new WindowPosition(posX, posY, sizeX, sizeY);
    }

    private void setWindowLocation(WindowPosition storedPosition) {
        this.window.setLocation(storedPosition.posX, storedPosition.posY);
        this.window.setSize(storedPosition.sizeX, storedPosition.sizeY);
    }

    private boolean isDisplayable(WindowPosition position) {
        JFrame frame = new JFrame();
        frame.setBounds(position.posX, position.posY, position.sizeX, position.sizeY);
        return this.getVirtualBounds().contains(frame.getBounds());
    }

    private Rectangle getVirtualBounds() {
        GraphicsDevice[] devices;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            bounds.add(device.getDefaultConfiguration().getBounds());
        }
        return bounds;
    }

    private WindowPosition adaptPosition(WindowPosition position) {
        if (this.isDisplayable(position)) {
            return position;
        }
        GraphicsDevice mainScreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int mainScreenHeight = mainScreen.getDisplayMode().getHeight();
        int mainScreenWidth = mainScreen.getDisplayMode().getWidth();
        int newPosX = position.posX;
        int newPosY = position.posY;
        int newSizeX = position.sizeX;
        int newSizeY = position.sizeY;
        if (position.posX + position.sizeX > mainScreenWidth) {
            if (position.sizeX <= mainScreenWidth) {
                newPosX = mainScreenWidth - position.sizeX;
            } else {
                newPosX = Globals.prefs.getIntDefault(this.posXKey);
                newSizeX = Globals.prefs.getIntDefault(this.sizeXKey);
            }
        }
        if (position.posY + position.sizeY > mainScreenHeight) {
            if (position.sizeY <= mainScreenHeight) {
                newPosY = mainScreenHeight - position.sizeY;
            } else {
                newPosY = Globals.prefs.getIntDefault(this.posYKey);
                newSizeY = Globals.prefs.getIntDefault(this.sizeYKey);
            }
        }
        return new WindowPosition(newPosX, newPosY, newSizeX, newSizeY);
    }

    static class WindowPosition {
        public final int posX;
        public final int posY;
        public final int sizeX;
        public final int sizeY;

        public WindowPosition(int posX, int posY, int sizeX, int sizeY) {
            this.posX = posX;
            this.posY = posY;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }
    }
}

