/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.undo;

import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibtexString;
import net.sf.jabref.model.strings.StringUtil;

public class UndoableStringChange
extends AbstractUndoableJabRefEdit {
    private final BibtexString string;
    private final String oldValue;
    private final String newValue;
    private final boolean nameChange;
    private final BasePanel panel;

    public UndoableStringChange(BasePanel panel, BibtexString string, boolean nameChange, String oldValue, String newValue) {
        this.string = string;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.nameChange = nameChange;
        this.panel = panel;
    }

    @Override
    public String getPresentationName() {
        return this.nameChange ? Localization.lang("change string name %0 to %1", StringUtil.boldHTML(this.oldValue), StringUtil.boldHTML(this.newValue)) : Localization.lang("change string content %0 to %1", StringUtil.boldHTML(this.oldValue), StringUtil.boldHTML(this.newValue));
    }

    @Override
    public void undo() {
        super.undo();
        this.panel.assureStringDialogNotEditing();
        if (this.nameChange) {
            this.string.setName(this.oldValue);
        } else {
            this.string.setContent(this.oldValue);
        }
        this.panel.updateStringDialog();
    }

    @Override
    public void redo() {
        super.redo();
        this.panel.assureStringDialogNotEditing();
        if (this.nameChange) {
            this.string.setName(this.newValue);
        } else {
            this.string.setContent(this.newValue);
        }
        this.panel.updateStringDialog();
    }
}

