/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.undo;

import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.EntryEventSource;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UndoableRemoveEntry
extends AbstractUndoableJabRefEdit {
    private final BibDatabase base;
    private final BibEntry entry;
    private final BasePanel panel;
    private static final Log LOGGER = LogFactory.getLog(UndoableRemoveEntry.class);

    public UndoableRemoveEntry(BibDatabase base, BibEntry entry, BasePanel panel) {
        this.base = base;
        this.entry = entry;
        this.panel = panel;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("remove entry %0", StringUtil.boldHTML(this.entry.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))));
    }

    @Override
    public void undo() {
        super.undo();
        this.base.insertEntry(this.entry, EntryEventSource.UNDO);
    }

    @Override
    public void redo() {
        super.redo();
        try {
            this.base.removeEntry(this.entry);
            this.panel.ensureNotShowingBottomPanel(this.entry);
        }
        catch (Throwable ex) {
            LOGGER.warn("Problem to redo `remove entry`", ex);
        }
    }
}

