/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.undo;

import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;

public class UndoablePreambleChange
extends AbstractUndoableJabRefEdit {
    private final BibDatabase base;
    private final String oldValue;
    private final String newValue;
    private final BasePanel panel;

    public UndoablePreambleChange(BibDatabase base, BasePanel panel, String oldValue, String newValue) {
        this.base = base;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.panel = panel;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change preamble", new String[0]);
    }

    @Override
    public void undo() {
        super.undo();
        this.base.setPreamble(this.oldValue);
        this.panel.updatePreamble();
    }

    @Override
    public void redo() {
        super.redo();
        this.base.setPreamble(this.newValue);
        this.panel.updatePreamble();
    }
}

