/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.undo;

import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.strings.StringUtil;

public class UndoableKeyChange
extends AbstractUndoableJabRefEdit {
    private final BibEntry entry;
    private final String oldValue;
    private final String newValue;

    public UndoableKeyChange(BibEntry entry, String oldValue, String newValue) {
        this.entry = entry;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change key from %0 to %1", StringUtil.boldHTML(this.oldValue, Localization.lang("undefined", new String[0])), StringUtil.boldHTML(this.newValue, Localization.lang("undefined", new String[0])));
    }

    @Override
    public void undo() {
        super.undo();
        this.entry.setCiteKey(this.oldValue);
    }

    @Override
    public void redo() {
        super.redo();
        this.entry.setCiteKey(this.newValue);
    }
}

