/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.undo;

import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UndoableInsertEntry
extends AbstractUndoableJabRefEdit {
    private final BibDatabase base;
    private final BibEntry entry;
    private final BasePanel panel;
    private static final Log LOGGER = LogFactory.getLog(UndoableInsertEntry.class);

    public UndoableInsertEntry(BibDatabase base, BibEntry entry, BasePanel panel) {
        this.base = base;
        this.entry = entry;
        this.panel = panel;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("insert entry %0", StringUtil.boldHTML(this.entry.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))));
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.base.removeEntry(this.entry);
            this.panel.ensureNotShowingBottomPanel(this.entry);
        }
        catch (Throwable ex) {
            LOGGER.warn("Problem to undo `insert entry`", ex);
        }
    }

    @Override
    public void redo() {
        super.redo();
        this.base.insertEntry(this.entry);
    }
}

