/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.undo;

import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.strings.StringUtil;

public class UndoableChangeType
extends AbstractUndoableJabRefEdit {
    private final String oldType;
    private final String newType;
    private final BibEntry entry;

    public UndoableChangeType(BibEntry entry, String oldType, String newType) {
        this.oldType = oldType;
        this.newType = newType;
        this.entry = entry;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change type of entry %0 from %1 to %2", StringUtil.boldHTML(this.entry.getCiteKeyOptional().orElse(Localization.lang("undefined", new String[0]))), StringUtil.boldHTML(this.oldType, Localization.lang("undefined", new String[0])), StringUtil.boldHTML(this.newType));
    }

    @Override
    public void undo() {
        super.undo();
        this.entry.setType(this.oldType);
    }

    @Override
    public void redo() {
        super.redo();
        this.entry.setType(this.newType);
    }
}

