/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.specialfields;

import com.google.common.eventbus.Subscribe;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.logic.specialfields.SpecialFieldsUtils;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.FieldChangedEvent;
import net.sf.jabref.model.entry.specialfields.SpecialField;

public class SpecialFieldUpdateListener {
    private static SpecialFieldUpdateListener INSTANCE;

    @Subscribe
    public void listen(FieldChangedEvent fieldChangedEvent) {
        BibEntry entry = fieldChangedEvent.getBibEntry();
        String fieldName = fieldChangedEvent.getFieldName();
        SwingUtilities.invokeLater(() -> {
            if ("keywords".equals(fieldName)) {
                SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, Globals.prefs.getKeywordDelimiter());
                SwingUtilities.invokeLater(() -> JabRefGUI.getMainFrame().getCurrentBasePanel().updateEntryEditorIfShowing());
            } else if (SpecialField.isSpecialField(fieldName)) {
                SpecialFieldsUtils.syncKeywordsFromSpecialFields(entry, Globals.prefs.isKeywordSyncEnabled(), Globals.prefs.getKeywordDelimiter());
                SwingUtilities.invokeLater(() -> JabRefGUI.getMainFrame().getCurrentBasePanel().updateEntryEditorIfShowing());
            }
        });
    }

    public static SpecialFieldUpdateListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpecialFieldUpdateListener();
        }
        return INSTANCE;
    }
}

