/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.specialfields;

import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.specialfields.SpecialFieldsUtils;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.database.event.EntryAddedEvent;
import net.sf.jabref.model.entry.BibEntry;

public class SpecialFieldDatabaseChangeListener {
    private static SpecialFieldDatabaseChangeListener INSTANCE;

    public static SpecialFieldDatabaseChangeListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpecialFieldDatabaseChangeListener();
        }
        return INSTANCE;
    }

    @Subscribe
    public void listen(EntryAddedEvent event) {
        if (Globals.prefs.isKeywordSyncEnabled()) {
            BibEntry entry = event.getBibEntry();
            NamedCompound nc = new NamedCompound(Localization.lang("Synchronized special fields based on keywords", new String[0]));
            List<FieldChange> changes = SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, Globals.prefs.getKeywordDelimiter());
            for (FieldChange change : changes) {
                nc.addEdit(new UndoableFieldChange(change));
            }
        }
    }
}

