/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.specialfields;

import java.util.List;
import java.util.Objects;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.BaseAction;
import net.sf.jabref.gui.specialfields.SpecialFieldViewModel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.specialfields.SpecialFieldsUtils;
import net.sf.jabref.model.FieldChange;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.specialfields.SpecialField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpecialFieldAction
implements BaseAction {
    private final JabRefFrame frame;
    private final SpecialField specialField;
    private final String value;
    private final boolean nullFieldIfValueIsTheSame;
    private final String undoText;
    private static final Log LOGGER = LogFactory.getLog(SpecialFieldAction.class);

    public SpecialFieldAction(JabRefFrame frame, SpecialField specialField, String value, boolean nullFieldIfValueIsTheSame, String undoText) {
        this.frame = frame;
        this.specialField = specialField;
        this.value = value;
        this.nullFieldIfValueIsTheSame = nullFieldIfValueIsTheSame;
        this.undoText = undoText;
    }

    @Override
    public void action() {
        try {
            List<BibEntry> bes = this.frame.getCurrentBasePanel().getSelectedEntries();
            if (bes == null || bes.isEmpty()) {
                return;
            }
            NamedCompound ce = new NamedCompound(this.undoText);
            for (BibEntry be : bes) {
                List<FieldChange> changes = SpecialFieldsUtils.updateField(this.specialField, this.value, be, this.nullFieldIfValueIsTheSame, Globals.prefs.isKeywordSyncEnabled(), Globals.prefs.getKeywordDelimiter());
                for (FieldChange change : changes) {
                    ce.addEdit(new UndoableFieldChange(change));
                }
            }
            ce.end();
            if (ce.hasEdits()) {
                this.frame.getCurrentBasePanel().getUndoManager().addEdit(ce);
                this.frame.getCurrentBasePanel().markBaseChanged();
                this.frame.getCurrentBasePanel().updateEntryEditorIfShowing();
                String outText = this.nullFieldIfValueIsTheSame || this.value == null ? this.getTextDone(this.specialField, Integer.toString(bes.size())) : this.getTextDone(this.specialField, this.value, Integer.toString(bes.size()));
                this.frame.output(outText);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Problem setting special fields", ex);
        }
    }

    private String getTextDone(SpecialField field, String ... params) {
        Objects.requireNonNull(params);
        SpecialFieldViewModel viewModel = new SpecialFieldViewModel(field);
        if (field.isSingleValueField() && params.length == 1 && params[0] != null) {
            return Localization.lang("Toggled '%0' for %1 entries", viewModel.getLocalization(), params[0]);
        }
        if (!field.isSingleValueField() && params.length == 2 && params[0] != null && params[1] != null) {
            String[] allParams = new String[]{viewModel.getLocalization(), params[0], params[1]};
            return Localization.lang("Set '%0' to '%1' for %2 entries", allParams);
        }
        if (!field.isSingleValueField() && params.length == 1 && params[0] != null) {
            return Localization.lang("Cleared '%0' for %1 entries", viewModel.getLocalization(), params[0]);
        }
        LOGGER.info("Creation of special field status change message failed: illegal argument combination.");
        return "";
    }
}

