/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.shared;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.shared.ConnectToSharedDatabaseDialog;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;

public class MigrationHelpDialog
extends JDialog {
    public MigrationHelpDialog(final ConnectToSharedDatabaseDialog openSharedDatabaseDialog) {
        super((Dialog)openSharedDatabaseDialog, Localization.lang("Migration help information", new String[0]));
        this.setModal(true);
        String migrationMessage = Localization.lang("Entered database has obsolete structure and is no longer supported.", new String[0]);
        JLabel migrationLabel = new JLabel(migrationMessage);
        migrationLabel.setAlignmentX(0.0f);
        String helpMessage = Localization.lang("Click here to learn about the migration of pre-3.6 databases.", new String[0]);
        JLabel helpLabel = new HelpAction(HelpFile.SQL_DATABASE_MIGRATION).getHelpLabel(helpMessage);
        helpLabel.setAlignmentX(0.0f);
        String informationMessage = Localization.lang("However, a new database was created alongside the pre-3.6 one.", new String[0]);
        JLabel informationLabel = new JLabel(informationMessage);
        informationLabel.setAlignmentX(0.0f);
        AbstractAction openAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                openSharedDatabaseDialog.openSharedDatabase();
            }
        };
        JButton okButton = new JButton(Localization.lang("OK", new String[0]));
        okButton.addActionListener(openAction);
        okButton.setAlignmentX(0.5f);
        okButton.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "Enter_pressed");
        okButton.getActionMap().put("Enter_pressed", openAction);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)okButton, "Center");
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(9, 9, 9, 9));
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(migrationLabel);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        contentPanel.add(helpLabel);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        contentPanel.add(informationLabel);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        contentPanel.add(buttonPanel);
        this.add(contentPanel);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(openSharedDatabaseDialog);
    }
}

