/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.shared;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.mergeentries.MergeEntries;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.shared.DBMSSynchronizer;

public class MergeSharedEntryDialog {
    private final JabRefFrame jabRefFrame;
    private final DBMSSynchronizer dbmsSynchronizer;
    private final BibEntry localBibEntry;
    private final BibEntry sharedBibEntry;
    private final JDialog mergeDialog;
    private final MergeEntries mergeEntries;

    public MergeSharedEntryDialog(JabRefFrame jabRefFrame, DBMSSynchronizer dbmsSynchronizer, BibEntry localBibEntry, BibEntry sharedBibEntry, BibDatabaseMode bibDatabaseMode) {
        this.jabRefFrame = jabRefFrame;
        this.dbmsSynchronizer = dbmsSynchronizer;
        this.localBibEntry = localBibEntry;
        this.sharedBibEntry = sharedBibEntry;
        this.mergeDialog = new JDialog(jabRefFrame, Localization.lang("Update refused", new String[0]), true);
        this.mergeEntries = new MergeEntries(sharedBibEntry, localBibEntry, Localization.lang("Shared entry", new String[0]), Localization.lang("Local entry", new String[0]), bibDatabaseMode);
    }

    public void showMergeDialog() {
        this.mergeDialog.setMinimumSize(new Dimension(600, 600));
        StringBuilder message = new StringBuilder();
        message.append("<html>");
        message.append("<b>");
        message.append(Localization.lang("Update could not be performed due to existing change conflicts.", new String[0]));
        message.append("</b>");
        message.append("<br/><br/>");
        message.append(Localization.lang("You are not working on the newest version of BibEntry.", new String[0]));
        message.append("<br/><br/>");
        message.append(Localization.lang("Shared version: %0", String.valueOf(this.sharedBibEntry.getSharedBibEntryData().getVersion())));
        message.append("<br/>");
        message.append(Localization.lang("Local version: %0", String.valueOf(this.localBibEntry.getSharedBibEntryData().getVersion())));
        message.append("<br/><br/>");
        message.append(Localization.lang("Please merge the shared entry with yours and press \"Merge entries\" to resolve this problem.", new String[0]));
        message.append("<br/>");
        JLabel mergeInnformation = new JLabel(message.toString());
        mergeInnformation.setBorder(new EmptyBorder(9, 9, 9, 9));
        this.mergeDialog.add((Component)mergeInnformation, "North");
        this.mergeDialog.add((Component)this.mergeEntries.getMergeEntryPanel(), "Center");
        JButton mergeButton = new JButton(Localization.lang("Merge entries", new String[0]));
        mergeButton.addActionListener(e -> this.mergeEntries());
        JButton cancelButton = new JButton(Localization.lang("Cancel", new String[0]));
        cancelButton.addActionListener(e -> this.showConfirmationDialog());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)mergeButton, "West");
        buttonPanel.add((Component)cancelButton, "East");
        this.mergeDialog.add((Component)buttonPanel, "South");
        this.mergeDialog.setDefaultCloseOperation(0);
        this.mergeDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MergeSharedEntryDialog.this.showConfirmationDialog();
            }
        });
        this.mergeDialog.setLocationRelativeTo(this.jabRefFrame);
        this.mergeDialog.pack();
        this.mergeDialog.setVisible(true);
    }

    private void showConfirmationDialog() {
        int answer = JOptionPane.showConfirmDialog(this.mergeDialog, Localization.lang("Canceling this operation will leave your changes unsynchronized. Cancel anyway?", new String[0]), Localization.lang("Warning", new String[0]), 0);
        if (answer == 0) {
            this.mergeDialog.dispose();
        }
    }

    private void mergeEntries() {
        BibEntry mergedBibEntry = this.mergeEntries.getMergeEntry();
        mergedBibEntry.getSharedBibEntryData().setSharedID(this.sharedBibEntry.getSharedBibEntryData().getSharedID());
        mergedBibEntry.getSharedBibEntryData().setVersion(this.sharedBibEntry.getSharedBibEntryData().getVersion());
        this.mergeDialog.dispose();
        this.dbmsSynchronizer.synchronizeSharedEntry(mergedBibEntry);
        this.dbmsSynchronizer.synchronizeLocalDatabase();
    }
}

