/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.shared;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.jabref.JabRefException;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.exporter.SaveDatabaseAction;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.shared.MigrationHelpDialog;
import net.sf.jabref.gui.shared.SharedDatabaseUIManager;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.DatabaseLocation;
import net.sf.jabref.shared.DBMSConnection;
import net.sf.jabref.shared.DBMSConnectionProperties;
import net.sf.jabref.shared.DBMSType;
import net.sf.jabref.shared.exception.DatabaseNotSupportedException;
import net.sf.jabref.shared.exception.InvalidDBMSConnectionPropertiesException;
import net.sf.jabref.shared.prefs.SharedDatabasePreferences;
import net.sf.jabref.shared.security.Password;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectToSharedDatabaseDialog
extends JDialog {
    private static final Log LOGGER = LogFactory.getLog(ConnectToSharedDatabaseDialog.class);
    private final JabRefFrame frame;
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private final GridBagConstraints gridBagConstraints = new GridBagConstraints();
    private final JPanel connectionPanel = new JPanel();
    private final JPanel filePanel = new JPanel();
    private final JPanel buttonPanel = new JPanel();
    private final JLabel databaseTypeLabel = new JLabel(Localization.lang("Database type", new String[0]) + ":");
    private final JLabel hostPortLabel = new JLabel(Localization.lang("Host", new String[0]) + "/" + Localization.lang("Port", new String[0]) + ":");
    private final JLabel databaseLabel = new JLabel(Localization.lang("Database", new String[0]) + ":");
    private final JLabel userLabel = new JLabel(Localization.lang("User", new String[0]) + ":");
    private final JLabel passwordLabel = new JLabel(Localization.lang("Password", new String[0]) + ":");
    private final JTextField hostField = new JTextField(12);
    private final JTextField portField = new JTextField(4);
    private final JTextField userField = new JTextField(14);
    private final JTextField databaseField = new JTextField(14);
    private final JTextField fileLocationField = new JTextField(20);
    private final JPasswordField passwordField = new JPasswordField(14);
    private final JComboBox<DBMSType> dbmsTypeDropDown = new JComboBox();
    private final JButton connectButton = new JButton(Localization.lang("Connect", new String[0]));
    private final JButton cancelButton = new JButton(Localization.lang("Cancel", new String[0]));
    private final JButton browseButton = new JButton(Localization.lang("Browse", new String[0]));
    private final JButton helpButton = new HelpAction(HelpFile.SQL_DATABASE).getHelpButton();
    private final JCheckBox rememberPassword = new JCheckBox(Localization.lang("Remember password?", new String[0]));
    private final JCheckBox autosaveFile = new JCheckBox(Localization.lang("Automatically save the database to", new String[0]));
    private final SharedDatabasePreferences prefs = new SharedDatabasePreferences();
    private DBMSConnectionProperties connectionProperties;

    public ConnectToSharedDatabaseDialog(JabRefFrame frame) {
        super((Frame)frame, Localization.lang("Connect to shared database", new String[0]));
        this.frame = frame;
        this.initLayout();
        this.updateEnableState();
        this.applyPreferences();
        this.setupActions();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void openSharedDatabase() {
        int answer;
        Path localFilePath;
        if (this.isSharedDatabaseAlreadyPresent()) {
            JOptionPane.showMessageDialog(this, Localization.lang("You are already connected to a database using entered connection details.", new String[0]), Localization.lang("Warning", new String[0]), 2);
            return;
        }
        if (this.autosaveFile.isSelected() && Files.exists(localFilePath = Paths.get(this.fileLocationField.getText(), new String[0]), new LinkOption[0]) && !Files.isDirectory(localFilePath, new LinkOption[0]) && (answer = JOptionPane.showConfirmDialog(this, Localization.lang("'%0' exists. Overwrite file?", localFilePath.getFileName().toString()), Localization.lang("Existing file", new String[0]), 0)) == 1) {
            this.fileLocationField.requestFocus();
            return;
        }
        this.setLoadingConnectButtonText(true);
        try {
            BasePanel panel = new SharedDatabaseUIManager(this.frame).openNewSharedDatabaseTab(this.connectionProperties);
            this.setPreferences();
            this.dispose();
            try {
                new SaveDatabaseAction(panel, Paths.get(this.fileLocationField.getText(), new String[0])).runCommand();
            }
            catch (Throwable e) {
                LOGGER.error("Error while saving the database", e);
            }
            return;
        }
        catch (SQLException | InvalidDBMSConnectionPropertiesException exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), Localization.lang("Connection error", new String[0]), 0);
        }
        catch (DatabaseNotSupportedException exception) {
            new MigrationHelpDialog(this).setVisible(true);
        }
        this.setLoadingConnectButtonText(false);
    }

    private void setupActions() {
        AbstractAction openAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ConnectToSharedDatabaseDialog.this.checkFields();
                    ConnectToSharedDatabaseDialog.this.connectionProperties = new DBMSConnectionProperties();
                    ConnectToSharedDatabaseDialog.this.connectionProperties.setType((DBMSType)((Object)ConnectToSharedDatabaseDialog.this.dbmsTypeDropDown.getSelectedItem()));
                    ConnectToSharedDatabaseDialog.this.connectionProperties.setHost(ConnectToSharedDatabaseDialog.this.hostField.getText());
                    ConnectToSharedDatabaseDialog.this.connectionProperties.setPort(Integer.parseInt(ConnectToSharedDatabaseDialog.this.portField.getText()));
                    ConnectToSharedDatabaseDialog.this.connectionProperties.setDatabase(ConnectToSharedDatabaseDialog.this.databaseField.getText());
                    ConnectToSharedDatabaseDialog.this.connectionProperties.setUser(ConnectToSharedDatabaseDialog.this.userField.getText());
                    ConnectToSharedDatabaseDialog.this.connectionProperties.setPassword(new String(ConnectToSharedDatabaseDialog.this.passwordField.getPassword()));
                    ConnectToSharedDatabaseDialog.this.openSharedDatabase();
                }
                catch (JabRefException exception) {
                    JOptionPane.showMessageDialog(ConnectToSharedDatabaseDialog.this, exception.getMessage(), Localization.lang("Warning", new String[0]), 2);
                }
            }
        };
        this.connectButton.addActionListener(openAction);
        this.cancelButton.addActionListener(e -> this.dispose());
        AbstractAction dbmsTypeDropDownAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectToSharedDatabaseDialog.this.portField.setText(Integer.toString(((DBMSType)((Object)ConnectToSharedDatabaseDialog.this.dbmsTypeDropDown.getSelectedItem())).getDefaultPort()));
            }
        };
        this.dbmsTypeDropDown.addActionListener(dbmsTypeDropDownAction);
        this.connectButton.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "Enter_pressed");
        this.connectButton.getActionMap().put("Enter_pressed", openAction);
        this.browseButton.addActionListener(e -> this.showFileChooser());
        this.autosaveFile.addActionListener(e -> this.updateEnableState());
    }

    private void applyPreferences() {
        Optional<DBMSType> dbmsType;
        Optional<String> sharedDatabaseType = this.prefs.getType();
        Optional<String> sharedDatabaseHost = this.prefs.getHost();
        Optional<String> sharedDatabasePort = this.prefs.getPort();
        Optional<String> sharedDatabaseName = this.prefs.getName();
        Optional<String> sharedDatabaseUser = this.prefs.getUser();
        Optional<String> sharedDatabasePassword = this.prefs.getPassword();
        boolean sharedDatabaseRememberPassword = this.prefs.getRememberPassword();
        if (sharedDatabaseType.isPresent() && (dbmsType = DBMSType.fromString(sharedDatabaseType.get())).isPresent()) {
            this.dbmsTypeDropDown.setSelectedItem((Object)dbmsType.get());
        }
        if (sharedDatabaseHost.isPresent()) {
            this.hostField.setText(sharedDatabaseHost.get());
        }
        if (sharedDatabasePort.isPresent()) {
            this.portField.setText(sharedDatabasePort.get());
        } else {
            this.portField.setText(Integer.toString(((DBMSType)((Object)this.dbmsTypeDropDown.getSelectedItem())).getDefaultPort()));
        }
        if (sharedDatabaseName.isPresent()) {
            this.databaseField.setText(sharedDatabaseName.get());
        }
        if (sharedDatabaseUser.isPresent()) {
            this.userField.setText(sharedDatabaseUser.get());
        }
        if (sharedDatabasePassword.isPresent() && sharedDatabaseUser.isPresent()) {
            try {
                this.passwordField.setText(new Password(sharedDatabasePassword.get().toCharArray(), sharedDatabaseUser.get()).decrypt());
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                LOGGER.error("Could not read the password due to decryption problems.", e);
            }
        }
        this.rememberPassword.setSelected(sharedDatabaseRememberPassword);
    }

    private void initLayout() {
        this.setResizable(false);
        Insets defautInsets = new Insets(4, 15, 4, 4);
        this.connectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("Connection", new String[0])));
        this.connectionPanel.setLayout(this.gridBagLayout);
        Set<DBMSType> availableDBMSTypes = DBMSConnection.getAvailableDBMSTypes();
        DefaultComboBoxModel<DBMSType> comboBoxModel = new DefaultComboBoxModel<DBMSType>(availableDBMSTypes.toArray(new DBMSType[availableDBMSTypes.size()]));
        this.dbmsTypeDropDown.setModel(comboBoxModel);
        this.gridBagConstraints.insets = defautInsets;
        this.gridBagConstraints.fill = 1;
        this.gridBagLayout.setConstraints(this.connectionPanel, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.connectionPanel.add((Component)this.databaseTypeLabel, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 1;
        this.connectionPanel.add((Component)this.hostPortLabel, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 2;
        this.connectionPanel.add((Component)this.databaseLabel, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 3;
        this.connectionPanel.add((Component)this.userLabel, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 4;
        this.connectionPanel.add((Component)this.passwordLabel, this.gridBagConstraints);
        this.gridBagConstraints.gridwidth = 2;
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.connectionPanel.add(this.dbmsTypeDropDown, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.insets = new Insets(4, 15, 4, 0);
        this.connectionPanel.add((Component)this.hostField, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.gridwidth = 2;
        this.gridBagConstraints.insets = defautInsets;
        this.connectionPanel.add((Component)this.databaseField, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 3;
        this.connectionPanel.add((Component)this.userField, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 4;
        this.connectionPanel.add((Component)this.passwordField, this.gridBagConstraints);
        this.gridBagConstraints.gridy = 5;
        this.connectionPanel.add((Component)this.rememberPassword, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 2;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.connectionPanel.add((Component)this.portField, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 6;
        this.gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        JPanel helpPanel = new JPanel(new FlowLayout(0));
        helpPanel.add(this.helpButton);
        this.getContentPane().setLayout(this.gridBagLayout);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.gridwidth = 1;
        this.gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.gridBagLayout.setConstraints(this.connectionPanel, this.gridBagConstraints);
        this.getContentPane().add(this.connectionPanel);
        this.filePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localization.lang("File", new String[0])));
        this.filePanel.setLayout(this.gridBagLayout);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.gridwidth = 2;
        this.filePanel.add((Component)this.autosaveFile, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 1;
        this.filePanel.add((Component)this.fileLocationField, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 2;
        this.filePanel.add((Component)this.browseButton, this.gridBagConstraints);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.gridBagLayout.setConstraints(this.filePanel, this.gridBagConstraints);
        this.getContentPane().add(this.filePanel);
        this.buttonPanel.setLayout(new FlowLayout(1));
        this.buttonPanel.add(this.connectButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(helpPanel);
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.gridBagLayout.setConstraints(this.buttonPanel, this.gridBagConstraints);
        this.getContentPane().add(this.buttonPanel);
        this.setModal(true);
    }

    private void setPreferences() {
        this.prefs.setType(this.dbmsTypeDropDown.getSelectedItem().toString());
        this.prefs.setHost(this.hostField.getText());
        this.prefs.setPort(this.portField.getText());
        this.prefs.setName(this.databaseField.getText());
        this.prefs.setUser(this.userField.getText());
        if (this.rememberPassword.isSelected()) {
            try {
                this.prefs.setPassword(new Password(this.passwordField.getPassword(), this.userField.getText()).encrypt());
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                LOGGER.error("Could not store the password due to encryption problems.", e);
            }
        } else {
            this.prefs.clearPassword();
        }
        this.prefs.setRememberPassword(this.rememberPassword.isSelected());
    }

    private boolean isEmptyField(JTextField field) {
        return field.getText().trim().length() == 0;
    }

    private void checkFields() throws JabRefException {
        if (this.isEmptyField(this.hostField)) {
            this.hostField.requestFocus();
            throw new JabRefException(Localization.lang("Required field \"%0\" is empty.", Localization.lang("Host", new String[0])));
        }
        if (this.isEmptyField(this.portField)) {
            this.portField.requestFocus();
            throw new JabRefException(Localization.lang("Required field \"%0\" is empty.", Localization.lang("Port", new String[0])));
        }
        if (this.isEmptyField(this.databaseField)) {
            this.databaseField.requestFocus();
            throw new JabRefException(Localization.lang("Required field \"%0\" is empty.", Localization.lang("Database", new String[0])));
        }
        if (this.isEmptyField(this.userField)) {
            this.userField.requestFocus();
            throw new JabRefException(Localization.lang("Required field \"%0\" is empty.", Localization.lang("User", new String[0])));
        }
        if (this.autosaveFile.isSelected() && this.isEmptyField(this.fileLocationField)) {
            this.fileLocationField.requestFocus();
            throw new JabRefException(Localization.lang("Please enter a valid file path.", new String[0]));
        }
    }

    private void setLoadingConnectButtonText(boolean isLoading) {
        this.connectButton.setEnabled(!isLoading);
        if (isLoading) {
            this.connectButton.setText(Localization.lang("Connecting...", new String[0]));
        } else {
            this.connectButton.setText(Localization.lang("Connect", new String[0]));
        }
    }

    private boolean isSharedDatabaseAlreadyPresent() {
        List<BasePanel> panels = JabRefGUI.getMainFrame().getBasePanelList();
        return panels.parallelStream().anyMatch(panel -> {
            BibDatabaseContext context = panel.getBibDatabaseContext();
            return context.getLocation() == DatabaseLocation.SHARED && this.connectionProperties.equals(context.getDBMSSynchronizer().getDBProcessor().getDBMSConnectionProperties());
        });
    }

    private void showFileChooser() {
        FileDialog dialog = new FileDialog(this);
        dialog.withExtension(FileExtensions.BIBTEX_DB);
        dialog.setDefaultExtension(FileExtensions.BIBTEX_DB);
        Optional<Path> path = dialog.showDialogAndGetSelectedFile();
        path.ifPresent(p -> this.fileLocationField.setText(p.toString()));
    }

    private void updateEnableState() {
        this.fileLocationField.setEnabled(this.autosaveFile.isSelected());
        this.browseButton.setEnabled(this.autosaveFile.isSelected());
    }
}

