/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.search;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.OSXCompatibleToolbar;
import net.sf.jabref.gui.autocompleter.AutoCompleteSupport;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.maintable.MainTable;
import net.sf.jabref.gui.maintable.MainTableDataModel;
import net.sf.jabref.gui.search.GlobalSearchWorker;
import net.sf.jabref.gui.search.JTextFieldChangeListenerUtil;
import net.sf.jabref.gui.search.SearchDisplayMode;
import net.sf.jabref.gui.search.SearchResultFrame;
import net.sf.jabref.gui.search.SearchWorker;
import net.sf.jabref.gui.util.component.JTextFieldWithPlaceholder;
import net.sf.jabref.logic.autocompleter.AutoCompleter;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.search.SearchQuery;
import net.sf.jabref.logic.search.SearchQueryHighlightObservable;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.preferences.SearchPreferences;

public class GlobalSearchBar
extends JPanel {
    private static final Color NEUTRAL_COLOR = Color.WHITE;
    private static final Color NO_RESULTS_COLOR = new Color(232, 202, 202);
    private static final Color RESULTS_FOUND_COLOR = new Color(217, 232, 202);
    private static final Color ADVANCED_SEARCH_COLOR = new Color(102, 255, 255);
    private final JabRefFrame frame;
    private final JLabel searchIcon = new JLabel(IconTheme.JabRefIcon.SEARCH.getSmallIcon());
    private final JTextFieldWithPlaceholder searchField = new JTextFieldWithPlaceholder(Localization.lang("Search", new String[0]) + "...");
    private JButton openCurrentResultsInDialog = new JButton(IconTheme.JabRefIcon.OPEN_IN_NEW_WINDOW.getSmallIcon());
    private final JToggleButton caseSensitive;
    private final JToggleButton regularExp;
    private final JButton searchModeButton = new JButton();
    private final JLabel currentResults = new JLabel("");
    private AutoCompleteSupport<String> autoCompleteSupport = new AutoCompleteSupport(this.searchField);
    private final SearchQueryHighlightObservable searchQueryHighlightObservable = new SearchQueryHighlightObservable();
    private SearchWorker searchWorker;
    private GlobalSearchWorker globalSearchWorker;
    private SearchResultFrame searchResultFrame;
    private SearchDisplayMode searchDisplayMode;
    private boolean dontSelectSearchBar;

    public GlobalSearchBar(final JabRefFrame frame) {
        this.frame = Objects.requireNonNull(frame);
        final SearchPreferences searchPreferences = new SearchPreferences(Globals.prefs);
        this.searchDisplayMode = searchPreferences.getSearchMode();
        this.currentResults.setPreferredSize(new Dimension(150, 5));
        this.currentResults.setFont(this.currentResults.getFont().deriveFont(1));
        this.searchField.setColumns(30);
        final JToggleButton globalSearch = new JToggleButton(IconTheme.JabRefIcon.GLOBAL_SEARCH.getSmallIcon(), searchPreferences.isGlobalSearch());
        globalSearch.setToolTipText(Localization.lang("Search in all open databases", new String[0]));
        final AbstractAction globalSearchStandardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchPreferences.setGlobalSearch(globalSearch.isSelected());
                GlobalSearchBar.this.updateOpenCurrentResultsTooltip(globalSearch.isSelected());
            }
        };
        AbstractAction globalSearchShortCutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                globalSearch.setSelected(true);
                globalSearchStandardAction.actionPerformed(new ActionEvent(this, 0, "fire standard action"));
                GlobalSearchBar.this.focus();
            }
        };
        String searchGlobalByKey = "searchGlobalByKey";
        globalSearch.getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.GLOBAL_SEARCH), searchGlobalByKey);
        globalSearch.getActionMap().put(searchGlobalByKey, globalSearchShortCutAction);
        globalSearch.addActionListener(globalSearchStandardAction);
        this.openCurrentResultsInDialog.setDisabledIcon(IconTheme.JabRefIcon.OPEN_IN_NEW_WINDOW.getSmallIcon().createDisabledIcon());
        this.openCurrentResultsInDialog.addActionListener(event -> {
            if (globalSearch.isSelected()) {
                this.performGlobalSearch();
            } else {
                this.openLocalFindingsInExternalPanel();
            }
        });
        this.openCurrentResultsInDialog.setEnabled(false);
        this.updateOpenCurrentResultsTooltip(globalSearch.isSelected());
        this.regularExp = new JToggleButton(IconTheme.JabRefIcon.REG_EX.getSmallIcon(), searchPreferences.isRegularExpression());
        this.regularExp.setToolTipText(Localization.lang("regular expression", new String[0]));
        this.regularExp.addActionListener(event -> {
            searchPreferences.setRegularExpression(this.regularExp.isSelected());
            this.performSearch();
        });
        this.caseSensitive = new JToggleButton(IconTheme.JabRefIcon.CASE_SENSITIVE.getSmallIcon(), searchPreferences.isCaseSensitive());
        this.caseSensitive.setToolTipText(Localization.lang("Case sensitive", new String[0]));
        this.caseSensitive.addActionListener(event -> {
            searchPreferences.setCaseSensitive(this.caseSensitive.isSelected());
            this.performSearch();
        });
        this.updateSearchModeButtonText();
        this.searchModeButton.addActionListener(event -> this.toggleSearchModeAndSearch());
        JButton clearSearchButton = new JButton(IconTheme.JabRefIcon.CLOSE.getSmallIcon());
        clearSearchButton.setToolTipText(Localization.lang("Clear", new String[0]));
        clearSearchButton.addActionListener(event -> this.endSearch());
        this.searchField.addFocusListener(Globals.getFocusListener());
        this.searchField.addActionListener(event -> this.performSearch());
        JTextFieldChangeListenerUtil.addChangeListener(this.searchField, e -> this.performSearch());
        String endSearch = "endSearch";
        this.searchField.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.CLEAR_SEARCH), endSearch);
        this.searchField.getActionMap().put(endSearch, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (GlobalSearchBar.this.autoCompleteSupport.isVisible()) {
                    GlobalSearchBar.this.autoCompleteSupport.setVisible(false);
                } else {
                    GlobalSearchBar.this.endSearch();
                }
            }
        });
        this.autoCompleteSupport.install();
        String acceptSearch = "acceptSearch";
        this.searchField.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.ACCEPT), acceptSearch);
        this.searchField.getActionMap().put(acceptSearch, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalSearchBar.this.autoCompleteSupport.setVisible(false);
                BasePanel currentBasePanel = frame.getCurrentBasePanel();
                Globals.getFocusListener().setFocused(currentBasePanel.getMainTable());
                currentBasePanel.getMainTable().requestFocus();
            }
        });
        this.setLayout(new FlowLayout(2));
        OSXCompatibleToolbar toolBar = new OSXCompatibleToolbar();
        toolBar.setFloatable(false);
        if (OS.OS_X) {
            this.searchField.putClientProperty("JTextField.variant", "search");
            ((Container)toolBar).add(this.searchField);
        } else {
            ((Container)toolBar).add(this.searchIcon);
            ((Container)toolBar).add(this.searchField);
            ((Container)toolBar).add(clearSearchButton);
        }
        toolBar.addSeparator();
        ((Container)toolBar).add(this.openCurrentResultsInDialog);
        toolBar.addSeparator();
        ((Container)toolBar).add(globalSearch);
        ((Container)toolBar).add(this.regularExp);
        ((Container)toolBar).add(this.caseSensitive);
        ((Container)toolBar).add(this.searchModeButton);
        toolBar.addSeparator();
        toolBar.add(new HelpAction(HelpFile.SEARCH));
        toolBar.addSeparator();
        ((Container)toolBar).add(this.currentResults);
        this.add(toolBar);
    }

    public void performGlobalSearch() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel == null || this.validateSearchResultFrame(true)) {
            return;
        }
        if (this.globalSearchWorker != null) {
            this.globalSearchWorker.cancel(true);
        }
        if (this.searchField.getText().isEmpty()) {
            this.focus();
            return;
        }
        this.globalSearchWorker = new GlobalSearchWorker(currentBasePanel.frame(), this.getSearchQuery());
        this.globalSearchWorker.execute();
    }

    private void openLocalFindingsInExternalPanel() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel == null || this.validateSearchResultFrame(false)) {
            return;
        }
        if (this.searchField.getText().isEmpty()) {
            this.focus();
            return;
        }
        SearchResultFrame searchDialog = new SearchResultFrame(currentBasePanel.frame(), Localization.lang("Search results in database %0 for %1", currentBasePanel.getBibDatabaseContext().getDatabaseFile().map(File::getName).orElse(GUIGlobals.UNTITLED_TITLE), this.getSearchQuery().localize()), this.getSearchQuery(), false);
        List<BibEntry> entries = currentBasePanel.getDatabase().getEntries().stream().filter(BibEntry::isSearchHit).collect(Collectors.toList());
        searchDialog.addEntries(entries, currentBasePanel);
        searchDialog.selectFirstEntry();
        searchDialog.setVisible(true);
    }

    private boolean validateSearchResultFrame(boolean globalSearch) {
        if (this.searchResultFrame != null) {
            if (this.searchResultFrame.isGlobalSearch() == globalSearch && this.isStillValidQuery(this.searchResultFrame.getSearchQuery())) {
                this.searchResultFrame.focus();
                return true;
            }
            this.searchResultFrame.dispose();
            return false;
        }
        return false;
    }

    private void toggleSearchModeAndSearch() {
        int nextSearchMode = (this.searchDisplayMode.ordinal() + 1) % SearchDisplayMode.values().length;
        this.searchDisplayMode = SearchDisplayMode.values()[nextSearchMode];
        new SearchPreferences(Globals.prefs).setSearchMode(this.searchDisplayMode);
        this.updateSearchModeButtonText();
        this.performSearch();
    }

    private void updateSearchModeButtonText() {
        this.searchModeButton.setText(this.searchDisplayMode.getDisplayName());
        this.searchModeButton.setToolTipText(this.searchDisplayMode.getToolTipText());
    }

    public void endSearch() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel != null) {
            this.clearSearch(currentBasePanel);
            MainTable mainTable = this.frame.getCurrentBasePanel().getMainTable();
            Globals.getFocusListener().setFocused(mainTable);
            mainTable.requestFocus();
            SwingUtilities.invokeLater(() -> mainTable.ensureVisible(mainTable.getSelectedRow()));
        }
    }

    public void focus() {
        if (!this.searchField.hasFocus()) {
            this.searchField.requestFocus();
            this.searchField.selectAll();
        }
    }

    private void clearSearch(BasePanel currentBasePanel) {
        this.currentResults.setText("");
        this.searchField.setText("");
        this.searchField.setBackground(NEUTRAL_COLOR);
        this.searchIcon.setIcon(IconTheme.JabRefIcon.SEARCH.getSmallIcon());
        this.searchQueryHighlightObservable.reset();
        this.openCurrentResultsInDialog.setEnabled(false);
        if (currentBasePanel != null) {
            currentBasePanel.getMainTable().getTableModel().updateSearchState(MainTableDataModel.DisplayOption.DISABLED);
        }
        if (this.dontSelectSearchBar) {
            this.dontSelectSearchBar = false;
            return;
        }
        this.focus();
    }

    public void performSearch() {
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        if (currentBasePanel == null) {
            return;
        }
        if (this.searchWorker != null) {
            this.searchWorker.cancel(true);
        }
        if (this.searchField.getText().isEmpty()) {
            this.clearSearch(currentBasePanel);
            return;
        }
        SearchQuery searchQuery = this.getSearchQuery();
        if (!searchQuery.isValid()) {
            this.informUserAboutInvalidSearchQuery();
            return;
        }
        this.searchWorker = new SearchWorker(currentBasePanel, searchQuery, this.searchDisplayMode);
        this.searchWorker.execute();
    }

    private void informUserAboutInvalidSearchQuery() {
        this.searchField.setBackground(NO_RESULTS_COLOR);
        this.searchQueryHighlightObservable.reset();
        BasePanel currentBasePanel = this.frame.getCurrentBasePanel();
        currentBasePanel.getMainTable().getTableModel().updateSearchState(MainTableDataModel.DisplayOption.DISABLED);
        this.searchIcon.setIcon(IconTheme.JabRefIcon.SEARCH.getSmallIcon().createWithNewColor(NO_RESULTS_COLOR));
        String illegalSearch = Localization.lang("Search failed: illegal search expression", new String[0]);
        this.searchIcon.setToolTipText(illegalSearch);
        this.currentResults.setText(illegalSearch);
        this.openCurrentResultsInDialog.setEnabled(false);
    }

    public void setAutoCompleter(AutoCompleter<String> searchCompleter) {
        this.autoCompleteSupport.setAutoCompleter(searchCompleter);
    }

    public SearchQueryHighlightObservable getSearchQueryHighlightObservable() {
        return this.searchQueryHighlightObservable;
    }

    public boolean isStillValidQuery(SearchQuery query) {
        return query.getQuery().equals(this.searchField.getText()) && query.isRegularExpression() == this.regularExp.isSelected() && query.isCaseSensitive() == this.caseSensitive.isSelected();
    }

    private SearchQuery getSearchQuery() {
        SearchQuery searchQuery = new SearchQuery(this.searchField.getText(), this.caseSensitive.isSelected(), this.regularExp.isSelected());
        this.frame.getCurrentBasePanel().setCurrentSearchQuery(searchQuery);
        return searchQuery;
    }

    public void updateResults(int matched, String description, boolean grammarBasedSearch) {
        if (matched == 0) {
            this.currentResults.setText(Localization.lang("No results found.", new String[0]));
            this.searchField.setBackground(NO_RESULTS_COLOR);
        } else {
            this.currentResults.setText(Localization.lang("Found %0 results.", String.valueOf(matched)));
            this.searchField.setBackground(RESULTS_FOUND_COLOR);
        }
        this.searchField.setToolTipText("<html>" + description + "</html>");
        if (grammarBasedSearch) {
            this.searchIcon.setIcon(IconTheme.JabRefIcon.SEARCH.getSmallIcon().createWithNewColor(ADVANCED_SEARCH_COLOR));
            this.searchIcon.setToolTipText(Localization.lang("Advanced search active.", new String[0]));
        } else {
            this.searchIcon.setIcon(IconTheme.JabRefIcon.SEARCH.getSmallIcon());
            this.searchIcon.setToolTipText(Localization.lang("Normal search active.", new String[0]));
        }
        this.openCurrentResultsInDialog.setEnabled(true);
    }

    public void setSearchResultFrame(SearchResultFrame searchResultFrame) {
        this.searchResultFrame = searchResultFrame;
    }

    public void setSearchTerm(String searchTerm, boolean dontSelectSearchBar) {
        if (searchTerm.equals(this.searchField.getText())) {
            return;
        }
        this.setDontSelectSearchBar(dontSelectSearchBar);
        this.searchField.setText(searchTerm);
        this.autoCompleteSupport.setVisible(false);
    }

    public void setDontSelectSearchBar(boolean dontSelectSearchBar) {
        this.dontSelectSearchBar = dontSelectSearchBar;
    }

    private void updateOpenCurrentResultsTooltip(boolean globalSearchEnabled) {
        if (globalSearchEnabled) {
            this.openCurrentResultsInDialog.setToolTipText(Localization.lang("Show global search results in a window", new String[0]));
        } else {
            this.openCurrentResultsInDialog.setToolTipText(Localization.lang("Show search results in a window", new String[0]));
        }
    }
}

