/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.push;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.push.AbstractPushToApplication;
import net.sf.jabref.gui.push.PushToApplication;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.metadata.MetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PushToLyx
extends AbstractPushToApplication
implements PushToApplication {
    private static final Log LOGGER = LogFactory.getLog(PushToLyx.class);

    @Override
    public String getApplicationName() {
        return "LyX/Kile";
    }

    @Override
    public Icon getIcon() {
        return IconTheme.getImage("lyx");
    }

    @Override
    protected void initParameters() {
        this.commandPathPreferenceKey = "lyxpipe";
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            panel.output(Localization.lang("Error", new String[0]) + ": " + Localization.lang("verify that LyX is running and that the lyxpipe is valid", new String[0]) + ". [" + this.commandPath + "]");
        } else if (this.couldNotCall) {
            panel.output(Localization.lang("Error", new String[0]) + ": " + Localization.lang("unable to write to", new String[0]) + " " + this.commandPath + ".in");
        } else {
            super.operationCompleted(panel);
        }
    }

    @Override
    protected void initSettingsPanel() {
        super.initSettingsPanel();
        this.settings = new JPanel();
        this.settings.add(new JLabel(Localization.lang("Path to LyX pipe", new String[0]) + ":"));
        this.settings.add(this.path);
    }

    @Override
    public void pushEntries(BibDatabase database, List<BibEntry> entries, String keyString, MetaData metaData) {
        File lp;
        this.couldNotConnect = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.initParameters();
        this.commandPath = Globals.prefs.get(this.commandPathPreferenceKey);
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        if (!this.commandPath.endsWith(".in")) {
            this.commandPath = this.commandPath + ".in";
        }
        if (!((lp = new File(this.commandPath)).exists() && lp.canWrite() || (lp = new File(this.commandPath + ".in")).exists() && lp.canWrite())) {
            this.couldNotConnect = true;
            return;
        }
        File lyxpipe = lp;
        JabRefExecutorService.INSTANCE.executeAndWait(() -> {
            try (FileWriter fw = new FileWriter(lyxpipe);
                 BufferedWriter lyxOut = new BufferedWriter(fw);){
                String citeStr = "LYXCMD:sampleclient:citation-insert:" + keyString;
                lyxOut.write(citeStr + "\n");
                lyxOut.close();
                fw.close();
            }
            catch (IOException excep) {
                this.couldNotCall = true;
                LOGGER.warn("Problem pushing to LyX/Kile.", excep);
            }
        });
    }
}

