/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.push;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.push.AbstractPushToApplication;
import net.sf.jabref.gui.push.PushToApplication;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.metadata.MetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PushToEmacs
extends AbstractPushToApplication
implements PushToApplication {
    private static final Log LOGGER = LogFactory.getLog(PushToEmacs.class);
    private final JTextField additionalParams = new JTextField(30);
    private final JCheckBox useEmacs23 = new JCheckBox();

    @Override
    public String getApplicationName() {
        return "Emacs";
    }

    @Override
    public Icon getIcon() {
        return IconTheme.getImage("emacs");
    }

    @Override
    public JPanel getSettingsPanel() {
        this.additionalParams.setText(Globals.prefs.get("emacsParameters"));
        this.useEmacs23.setSelected(Globals.prefs.getBoolean("emacsUseV23InsertString"));
        return super.getSettingsPanel();
    }

    @Override
    public void storeSettings() {
        super.storeSettings();
        Globals.prefs.put("emacsParameters", this.additionalParams.getText());
        Globals.prefs.putBoolean("emacsUseV23InsertString", this.useEmacs23.isSelected());
    }

    @Override
    protected void initSettingsPanel() {
        super.initSettingsPanel();
        this.builder.appendRows("2dlu, p, 2dlu, p", new Object[0]);
        this.builder.add(Localization.lang("Additional parameters", new String[0]) + ":", new Object[0]).xy(1, 3);
        this.builder.add(this.additionalParams).xy(3, 3);
        this.builder.add(Localization.lang("Use EMACS 23 insertion string", new String[0]) + ":", new Object[0]).xy(1, 5);
        this.builder.add(this.useEmacs23).xy(3, 5);
        this.settings = this.builder.build();
    }

    @Override
    public void pushEntries(BibDatabase database, List<BibEntry> entries, String keys, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.initParameters();
        this.commandPath = Globals.prefs.get(this.commandPathPreferenceKey);
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        this.commandPath = Globals.prefs.get(this.commandPathPreferenceKey);
        String[] addParams = Globals.prefs.get("emacsParameters").split(" ");
        try {
            String suffix;
            String prefix;
            String[] com = new String[addParams.length + 2];
            com[0] = this.commandPath;
            System.arraycopy(addParams, 0, com, 1, addParams.length);
            if (Globals.prefs.getBoolean("emacsUseV23InsertString")) {
                prefix = "(with-current-buffer (window-buffer) (insert ";
                suffix = "))";
            } else {
                prefix = "(insert ";
                suffix = ")";
            }
            com[com.length - 1] = OS.WINDOWS ? prefix.concat("\\\"\\" + this.getCiteCommand().replaceAll("\\\\", "\\\\\\\\") + "{" + keys + "}\\\"").concat(suffix) : prefix.concat("\"" + this.getCiteCommand().replaceAll("\\\\", "\\\\\\\\") + "{" + keys + "}\"").concat(suffix);
            Process p = Runtime.getRuntime().exec(com);
            JabRefExecutorService.INSTANCE.executeAndWait(() -> {
                try (InputStream out = p.getErrorStream();){
                    StringBuilder sb = new StringBuilder();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not read from stderr.", e);
                    }
                    if (!sb.toString().trim().isEmpty()) {
                        LOGGER.warn("Push to Emacs error: " + sb);
                        this.couldNotConnect = true;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("File problem.", e);
                }
            });
        }
        catch (IOException excep) {
            this.couldNotCall = true;
            LOGGER.warn("Problem pushing to Emacs.", excep);
        }
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(panel.frame(), "<HTML>" + Localization.lang("Could not connect to a running gnuserv process. Make sure that Emacs or XEmacs is running,<BR>and that the server has been started (by running the command 'server-start'/'gnuserv-start').", new String[0]) + "</HTML>", Localization.lang("Error", new String[0]), 0);
        } else if (this.couldNotCall) {
            JOptionPane.showMessageDialog(panel.frame(), Localization.lang("Could not run the gnuclient/emacsclient program. Make sure you have the emacsclient/gnuclient program installed and available in the PATH.", new String[0]), Localization.lang("Error", new String[0]), 0);
        } else {
            super.operationCompleted(panel);
        }
    }

    @Override
    protected void initParameters() {
        this.commandPathPreferenceKey = "emacsPath";
    }

    @Override
    protected String getCommandName() {
        return "gnuclient " + Localization.lang("or", new String[0]) + " emacsclient";
    }
}

