/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.protectedterms;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.externalfiletype.UnknownExternalFileType;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.protectedterms.NewProtectedTermsFileDialog;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.gui.util.WindowLocation;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.protectedterms.ProtectedTermsList;
import net.sf.jabref.logic.protectedterms.ProtectedTermsLoader;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProtectedTermsDialog {
    private static final Log LOGGER = LogFactory.getLog(ProtectedTermsDialog.class);
    private final JabRefFrame frame;
    private JDialog diag;
    private JTable table;
    private DefaultTableModel tableModel;
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem edit = new JMenuItem(Localization.lang("Edit", new String[0]));
    private final JMenuItem show = new JMenuItem(Localization.lang("View", new String[0]));
    private final JMenuItem remove = new JMenuItem(Localization.lang("Remove", new String[0]));
    private final JMenuItem reload = new JMenuItem(Localization.lang("Reload", new String[0]));
    private final JMenuItem enabled = new JCheckBoxMenuItem(Localization.lang("Enabled", new String[0]));
    private final JButton loadButton = new JButton(IconTheme.JabRefIcon.OPEN.getIcon());
    private final JButton removeButton = new JButton(IconTheme.JabRefIcon.DELETE_ENTRY.getIcon());
    private final JButton newButton = new JButton(IconTheme.JabRefIcon.NEW.getIcon());
    private ActionListener removeAction;
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
    private boolean okPressed;
    private final ProtectedTermsLoader loader;

    public ProtectedTermsDialog(JabRefFrame frame, ProtectedTermsLoader loader) {
        this.frame = Objects.requireNonNull(frame);
        this.loader = Objects.requireNonNull(loader);
        this.init();
    }

    private void init() {
        this.setupPopupMenu();
        this.loadButton.addActionListener(actionEvent -> {
            AddFileDialog addDialog = new AddFileDialog();
            addDialog.setVisible(true);
            addDialog.getFileName().ifPresent(fileName -> this.loader.addProtectedTermsListFromFile((String)fileName, true));
            this.tableModel.fireTableDataChanged();
        });
        this.loadButton.setToolTipText(Localization.lang("Add protected terms file", new String[0]));
        this.removeButton.addActionListener(this.removeAction);
        this.removeButton.setToolTipText(Localization.lang("Remove protected terms file", new String[0]));
        this.newButton.addActionListener(actionEvent -> {
            NewProtectedTermsFileDialog newDialog = new NewProtectedTermsFileDialog(this.diag, this.loader);
            newDialog.setVisible(true);
            this.tableModel.fireTableDataChanged();
        });
        this.newButton.setToolTipText(Localization.lang("New protected terms file", new String[0]));
        this.setupTable();
        this.diag = new JDialog(this.frame, Localization.lang("Manage protected terms files", new String[0]), true);
        FormBuilder builder = FormBuilder.create();
        builder.layout(new FormLayout("fill:pref:grow, 4dlu, left:pref, 4dlu, left:pref, 4dlu, left:pref", "100dlu:grow, 4dlu, pref"));
        builder.add(new JScrollPane(this.table)).xyw(1, 1, 7);
        builder.add(this.newButton).xy(3, 3);
        builder.add(this.loadButton).xy(5, 3);
        builder.add(this.removeButton).xy(7, 3);
        builder.padding("5dlu, 5dlu, 5dlu, 5dlu", new Object[0]);
        this.diag.add((Component)builder.getPanel(), "Center");
        AbstractAction okListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProtectedTermsDialog.this.storePreferences();
                ProtectedTermsDialog.this.diag.dispose();
            }
        };
        this.ok.addActionListener(okListener);
        AbstractAction cancelListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProtectedTermsDialog.this.loader.update(Globals.prefs.getProtectedTermsPreferences());
                ProtectedTermsDialog.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelListener);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.add((Component)bb.getPanel(), "South");
        ActionMap am = bb.getPanel().getActionMap();
        InputMap im = bb.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelListener);
        im.put(KeyStroke.getKeyStroke("ENTER"), "enterOk");
        am.put("enterOk", okListener);
        this.diag.pack();
        WindowLocation pw = new WindowLocation(this.diag, "termsPosX", "termsPosY", "termsSizeX", "termsSizeY");
        pw.displayWindowAtStoredLocation();
    }

    private void setupTable() {
        this.tableModel = new TermTableModel();
        this.table = new JTable(this.tableModel);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setMinWidth(cm.getColumn(0).getPreferredWidth() * 11 / 10);
        cm.getColumn(0).setMaxWidth(cm.getColumn(0).getPreferredWidth() * 11 / 10);
        cm.getColumn(1).setPreferredWidth(100);
        cm.getColumn(2).setPreferredWidth(100);
        GUIUtil.correctRowHeight(this.table);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ProtectedTermsDialog.this.tablePopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ProtectedTermsDialog.this.tablePopup(mouseEvent);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ProtectedTermsDialog.this.getSelectedTermsList().ifPresent(list -> list.setEnabled(!list.isEnabled()));
                    ProtectedTermsDialog.this.tableModel.fireTableDataChanged();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new EntrySelectionListener());
    }

    private void setupPopupMenu() {
        this.popup.add(this.edit);
        this.popup.add(this.show);
        this.popup.add(this.remove);
        this.popup.add(this.reload);
        this.popup.addSeparator();
        this.popup.add(this.enabled);
        this.edit.addActionListener(actionEvent -> this.getSelectedTermsList().ifPresent(term -> {
            Optional<ExternalFileType> type = ExternalFileTypes.getInstance().getExternalFileTypeByExt("terms");
            String fileName = term.getLocation();
            try {
                if (type.isPresent()) {
                    JabRefDesktop.openExternalFileAnyFormat(new BibDatabaseContext(), fileName, type);
                } else {
                    Optional<ExternalFileType> txtType = ExternalFileTypes.getInstance().getExternalFileTypeByExt("txt");
                    if (txtType.isPresent()) {
                        JabRefDesktop.openExternalFileAnyFormat(new BibDatabaseContext(), fileName, txtType);
                    } else {
                        JabRefDesktop.openExternalFileUnknown(this.frame, new BibEntry(), new BibDatabaseContext(), fileName, new UnknownExternalFileType("terms"));
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("Problem open protected terms file editor", e);
            }
        }));
        this.show.addActionListener(actionEvent -> this.getSelectedTermsList().ifPresent(this::displayTerms));
        this.removeAction = actionEvent -> this.getSelectedTermsList().ifPresent(list -> {
            if (!list.isInternalList() && JOptionPane.showConfirmDialog(this.diag, Localization.lang("Are you sure you want to remove the protected terms file?", new String[0]), Localization.lang("Remove protected terms file", new String[0]), 0) == 0) {
                if (!this.loader.removeProtectedTermsList((ProtectedTermsList)list)) {
                    LOGGER.info("Problem removing protected terms file");
                }
                this.tableModel.fireTableDataChanged();
            }
        });
        this.remove.addActionListener(this.removeAction);
        this.reload.addActionListener(actionEvent -> this.getSelectedTermsList().ifPresent(this.loader::reloadProtectedTermsList));
        this.enabled.addActionListener(actionEvent -> this.getSelectedTermsList().ifPresent(list -> list.setEnabled(this.enabled.isSelected())));
    }

    public void setVisible(boolean visible) {
        this.okPressed = false;
        this.diag.setVisible(visible);
    }

    private Optional<ProtectedTermsList> getSelectedTermsList() {
        if (this.table.getSelectedRow() != -1) {
            return Optional.of(this.loader.getProtectedTermsLists().get(this.table.getSelectedRow()));
        }
        return Optional.empty();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void tablePopup(MouseEvent e) {
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private void displayTerms(ProtectedTermsList list) {
        JDialog dd = new JDialog(this.diag, list.getDescription() + " - " + list.getLocation(), true);
        JTextArea ta = new JTextArea(list.getTermListing());
        ta.setEditable(false);
        JScrollPane sp = new JScrollPane(ta);
        sp.setPreferredSize(new Dimension(700, 500));
        dd.getContentPane().add((Component)sp, "Center");
        JButton okButton = new JButton(Localization.lang("OK", new String[0]));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)okButton);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        dd.getContentPane().add((Component)bb.getPanel(), "South");
        okButton.addActionListener(actionEvent -> dd.dispose());
        dd.pack();
        dd.setLocationRelativeTo(this.diag);
        dd.setVisible(true);
    }

    private void storePreferences() {
        Globals.prefs.setProtectedTermsPreferences(this.loader);
    }

    private class AddFileDialog
    extends JDialog {
        private final JTextField newFile;
        private boolean addOKPressed;

        public AddFileDialog() {
            super(ProtectedTermsDialog.this.diag, Localization.lang("Add protected terms file", new String[0]), true);
            this.newFile = new JTextField();
            JButton browse = new JButton(Localization.lang("Browse", new String[0]));
            FileDialog dialog = new FileDialog(ProtectedTermsDialog.this.frame).withExtension(FileExtensions.TERMS);
            dialog.setDefaultExtension(FileExtensions.TERMS);
            browse.addActionListener(e -> {
                Optional<Path> file = dialog.showDialogAndGetSelectedFile();
                file.ifPresent(f -> this.newFile.setText(f.toAbsolutePath().toString()));
            });
            FormBuilder builder = FormBuilder.create();
            builder.layout(new FormLayout("left:pref, 4dlu, fill:100dlu:grow, 4dlu, pref", "p"));
            builder.add(Localization.lang("File", new String[0]), new Object[0]).xy(1, 1);
            builder.add(this.newFile).xy(3, 1);
            builder.add(browse).xy(5, 1);
            builder.padding("10dlu, 10dlu, 10dlu, 10dlu", new Object[0]);
            this.getContentPane().add((Component)builder.build(), "Center");
            ButtonBarBuilder bb = new ButtonBarBuilder();
            JButton addOKButton = new JButton(Localization.lang("OK", new String[0]));
            JButton addCancelButton = new JButton(Localization.lang("Cancel", new String[0]));
            bb.addGlue();
            bb.addButton((JComponent)addOKButton);
            bb.addButton((JComponent)addCancelButton);
            bb.addGlue();
            bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)bb.getPanel(), "South");
            addOKButton.addActionListener(e -> {
                this.addOKPressed = true;
                this.dispose();
            });
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddFileDialog.this.addOKPressed = false;
                    AddFileDialog.this.dispose();
                }
            };
            addCancelButton.addActionListener(cancelAction);
            bb.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
            bb.getPanel().getActionMap().put("close", cancelAction);
            this.pack();
            this.setLocationRelativeTo(ProtectedTermsDialog.this.diag);
        }

        public Optional<String> getFileName() {
            if (this.addOKPressed && this.newFile.getText() != null && !this.newFile.getText().isEmpty()) {
                return Optional.of(this.newFile.getText());
            }
            return Optional.empty();
        }
    }

    private class EntrySelectionListener
    implements ListSelectionListener {
        private EntrySelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listEvent) {
            ProtectedTermsDialog.this.getSelectedTermsList().ifPresent(list -> {
                if (list.isInternalList()) {
                    ProtectedTermsDialog.this.remove.setEnabled(false);
                    ProtectedTermsDialog.this.edit.setEnabled(false);
                    ProtectedTermsDialog.this.reload.setEnabled(false);
                    ProtectedTermsDialog.this.removeButton.setEnabled(false);
                } else {
                    ProtectedTermsDialog.this.remove.setEnabled(true);
                    ProtectedTermsDialog.this.edit.setEnabled(true);
                    ProtectedTermsDialog.this.reload.setEnabled(true);
                    ProtectedTermsDialog.this.removeButton.setEnabled(true);
                }
                ProtectedTermsDialog.this.enabled.setSelected(list.isEnabled());
            });
        }
    }

    class TermTableModel
    extends DefaultTableModel {
        TermTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ProtectedTermsDialog.this.loader.getProtectedTermsLists().size();
        }

        @Override
        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return Localization.lang("Enabled", new String[0]);
                }
                case 1: {
                    return Localization.lang("Description", new String[0]);
                }
                case 2: {
                    return Localization.lang("File", new String[0]);
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return ProtectedTermsDialog.this.loader.getProtectedTermsLists().get(row).isEnabled();
                }
                case 1: {
                    return ProtectedTermsDialog.this.loader.getProtectedTermsLists().get(row).getDescription();
                }
                case 2: {
                    ProtectedTermsList list = ProtectedTermsDialog.this.loader.getProtectedTermsLists().get(row);
                    return list.isInternalList() ? Localization.lang("Internal list", new String[0]) + " - " + list.getLocation() : list.getLocation();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object cell, int row, int column) {
            if (column == 0) {
                ProtectedTermsList list;
                list.setEnabled(!(list = ProtectedTermsDialog.this.loader.getProtectedTermsLists().get(row)).isEnabled());
                this.fireTableCellUpdated(row, column);
            }
        }
    }
}

