/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.OSXCompatibleToolbar;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferences;

class XmpPrefsTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences prefs;
    private boolean tableChanged;
    private int rowCount;
    private final JTable table;
    private final JCheckBox privacyFilterCheckBox = new JCheckBox(Localization.lang("Do not write the following fields to XMP Metadata:", new String[0]));
    private final List<Object> tableRows = new ArrayList<Object>(10);

    public XmpPrefsTab(JabRefPreferences prefs) {
        this.prefs = Objects.requireNonNull(prefs);
        this.setLayout(new BorderLayout());
        AbstractTableModel tableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return XmpPrefsTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row >= XmpPrefsTab.this.tableRows.size()) {
                    return "";
                }
                Object rowContent = XmpPrefsTab.this.tableRows.get(row);
                if (rowContent == null) {
                    return "";
                }
                return rowContent;
            }

            @Override
            public String getColumnName(int col) {
                return Localization.lang("Field to filter", new String[0]);
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                XmpPrefsTab.this.tableChanged = true;
                if (XmpPrefsTab.this.tableRows.size() <= row) {
                    ((ArrayList)XmpPrefsTab.this.tableRows).ensureCapacity(row + 1);
                }
                XmpPrefsTab.this.tableRows.set(row, value);
            }
        };
        this.table = new JTable(tableModel);
        GUIUtil.correctRowHeight(this.table);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(140);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 200));
        scrollPane.setMinimumSize(new Dimension(250, 300));
        tablePanel.add((Component)scrollPane, "Center");
        OSXCompatibleToolbar toolbar = new OSXCompatibleToolbar(1);
        toolbar.setFloatable(false);
        toolbar.setBorder(null);
        toolbar.add(new AddRowAction());
        toolbar.add(new DeleteRowAction());
        tablePanel.add((Component)toolbar, "East");
        builder.appendSeparator(Localization.lang("XMP export privacy settings", new String[0]));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.privacyFilterCheckBox);
        builder.nextLine();
        builder.append(pan);
        builder.append(tablePanel);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.tableRows.clear();
        List<String> names = JabRefPreferences.getInstance().getStringList("xmpPrivacyFilters");
        this.tableRows.addAll(names);
        this.rowCount = this.tableRows.size() + 5;
        this.privacyFilterCheckBox.setSelected(JabRefPreferences.getInstance().getBoolean("useXmpPrivacyFilter"));
    }

    @Override
    public void storeSettings() {
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            this.table.getCellEditor(row, col).stopCellEditing();
        }
        if (this.tableChanged || this.privacyFilterCheckBox.isSelected() && !this.prefs.hasKey("xmpPrivacyFilters")) {
            for (int i = this.tableRows.size() - 1; i >= 0; --i) {
                if (this.tableRows.get(i) != null && !this.tableRows.get(i).toString().isEmpty()) continue;
                this.tableRows.remove(i);
            }
            JabRefPreferences.getInstance().putStringList("xmpPrivacyFilters", this.tableRows.stream().map(Object::toString).collect(Collectors.toList()));
        }
        JabRefPreferences.getInstance().putBoolean("useXmpPrivacyFilter", this.privacyFilterCheckBox.isSelected());
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("XMP-metadata", new String[0]);
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", IconTheme.JabRefIcon.ADD_NOBOX.getIcon());
            this.putValue("ShortDescription", Localization.lang("Insert rows", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = XmpPrefsTab.this.table.getSelectedRows();
            if (rows.length == 0) {
                XmpPrefsTab.this.rowCount++;
                XmpPrefsTab.this.table.revalidate();
                XmpPrefsTab.this.table.repaint();
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] + i >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.add(rows[i] + i, "");
            }
            XmpPrefsTab.this.rowCount = XmpPrefsTab.this.rowCount + rows.length;
            if (rows.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", IconTheme.JabRefIcon.REMOVE_NOBOX.getIcon());
            this.putValue("ShortDescription", Localization.lang("Delete rows", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = XmpPrefsTab.this.table.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.remove(rows[i]);
            }
            XmpPrefsTab.this.rowCount = XmpPrefsTab.this.rowCount - rows.length;
            if (rows.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }
}

