/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.gui.WrapLayout;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferencesFilter;

class PreferencesFilterDialog
extends JDialog {
    private final JabRefPreferencesFilter preferencesFilter;
    private final JTable table;
    private final JCheckBox showOnlyDeviatingPreferenceOptions;
    private final JLabel count;

    public PreferencesFilterDialog(JabRefPreferencesFilter preferencesFilter, JFrame frame) {
        super((Frame)frame, true);
        this.preferencesFilter = Objects.requireNonNull(preferencesFilter);
        this.setTitle(Localization.lang("Preferences", new String[0]));
        this.setSize(new Dimension(800, 600));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new WrapLayout(0));
        this.showOnlyDeviatingPreferenceOptions = new JCheckBox(Localization.lang("Show only preferences deviating from their default value", new String[0]), false);
        this.showOnlyDeviatingPreferenceOptions.addChangeListener(x -> this.updateModel());
        northPanel.add(this.showOnlyDeviatingPreferenceOptions);
        this.count = new JLabel();
        northPanel.add(this.count);
        panel.add((Component)northPanel, "North");
        this.table = new JTable();
        this.table.setAutoCreateRowSorter(true);
        GUIUtil.correctRowHeight(this.table);
        this.updateModel();
        panel.add((Component)new JScrollPane(this.table), "Center");
        this.getContentPane().add(panel);
    }

    private void updateModel() {
        List<JabRefPreferencesFilter.PreferenceOption> preferenceOptions = this.showOnlyDeviatingPreferenceOptions.isSelected() ? this.preferencesFilter.getDeviatingPreferences() : this.preferencesFilter.getPreferenceOptions();
        this.table.setModel(new PreferencesTableModel(preferenceOptions));
        this.count.setText(String.format("(%d)", preferenceOptions.size()));
    }

    private static class PreferencesTableModel
    extends AbstractTableModel {
        private final List<JabRefPreferencesFilter.PreferenceOption> preferences;

        public PreferencesTableModel(List<JabRefPreferencesFilter.PreferenceOption> preferences) {
            this.preferences = Objects.requireNonNull(preferences);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Localization.lang("type", new String[0]);
            }
            if (column == 1) {
                return Localization.lang("key", new String[0]);
            }
            if (column == 2) {
                return Localization.lang("value", new String[0]);
            }
            if (column == 3) {
                return Localization.lang("default", new String[0]);
            }
            return "n/a";
        }

        @Override
        public int getRowCount() {
            return this.preferences.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex - 1 > this.preferences.size()) {
                return "n/a";
            }
            JabRefPreferencesFilter.PreferenceOption preferenceOption = this.preferences.get(rowIndex);
            if (columnIndex == 0) {
                return preferenceOption.getType();
            }
            if (columnIndex == 1) {
                return preferenceOption.getKey();
            }
            if (columnIndex == 2) {
                return preferenceOption.getValue();
            }
            if (columnIndex == 3) {
                return preferenceOption.getDefaultValue().orElse("NULL");
            }
            return "n/a";
        }
    }
}

