/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefException;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.keyboard.KeyBinder;
import net.sf.jabref.gui.maintable.MainTable;
import net.sf.jabref.gui.preftabs.AdvancedTab;
import net.sf.jabref.gui.preftabs.AppearancePrefsTab;
import net.sf.jabref.gui.preftabs.BibtexKeyPatternPrefTab;
import net.sf.jabref.gui.preftabs.EntryEditorPrefsTab;
import net.sf.jabref.gui.preftabs.ExternalTab;
import net.sf.jabref.gui.preftabs.FileSortTab;
import net.sf.jabref.gui.preftabs.FileTab;
import net.sf.jabref.gui.preftabs.GeneralTab;
import net.sf.jabref.gui.preftabs.GroupsPrefsTab;
import net.sf.jabref.gui.preftabs.ImportSettingsTab;
import net.sf.jabref.gui.preftabs.NameFormatterTab;
import net.sf.jabref.gui.preftabs.NetworkTab;
import net.sf.jabref.gui.preftabs.PreferencesFilterDialog;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.gui.preftabs.PreviewPrefsTab;
import net.sf.jabref.gui.preftabs.TableColumnsTab;
import net.sf.jabref.gui.preftabs.TablePrefsTab;
import net.sf.jabref.gui.preftabs.XmpPrefsTab;
import net.sf.jabref.logic.exporter.ExportFormat;
import net.sf.jabref.logic.exporter.ExportFormats;
import net.sf.jabref.logic.exporter.SavePreferences;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.preferences.JabRefPreferences;
import net.sf.jabref.preferences.JabRefPreferencesFilter;
import net.sf.jabref.shared.prefs.SharedDatabasePreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencesDialog
extends JDialog {
    private static final Log LOGGER = LogFactory.getLog(PreferencesDialog.class);
    private final JPanel main;
    private final JabRefFrame frame;
    private final JButton importPreferences = new JButton(Localization.lang("Import preferences", new String[0]));
    private final JButton exportPreferences = new JButton(Localization.lang("Export preferences", new String[0]));
    private final JButton showPreferences = new JButton(Localization.lang("Show preferences", new String[0]));
    private final JButton resetPreferences = new JButton(Localization.lang("Reset preferences", new String[0]));

    public PreferencesDialog(JabRefFrame parent) {
        super(parent, Localization.lang("JabRef preferences", new String[0]), false);
        JabRefPreferences prefs = JabRefPreferences.getInstance();
        this.frame = parent;
        this.main = new JPanel();
        JPanel mainPanel = new JPanel();
        JPanel lower = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)lower, "South");
        CardLayout cardLayout = new CardLayout();
        this.main.setLayout(cardLayout);
        ArrayList<JPanel> tabs = new ArrayList<JPanel>();
        tabs.add(new GeneralTab(prefs));
        tabs.add(new NetworkTab(prefs));
        tabs.add(new FileTab(this.frame, prefs));
        tabs.add(new FileSortTab(prefs));
        tabs.add(new EntryEditorPrefsTab(prefs));
        tabs.add(new GroupsPrefsTab(prefs));
        tabs.add(new AppearancePrefsTab(prefs));
        tabs.add(new ExternalTab(this.frame, this, prefs));
        tabs.add(new TablePrefsTab(prefs));
        tabs.add(new TableColumnsTab(prefs, parent));
        tabs.add(new BibtexKeyPatternPrefTab(prefs, parent.getCurrentBasePanel()));
        tabs.add(new PreviewPrefsTab());
        tabs.add(new NameFormatterTab(prefs));
        tabs.add(new ImportSettingsTab(prefs));
        tabs.add(new XmpPrefsTab(prefs));
        tabs.add(new AdvancedTab(prefs));
        tabs.forEach(tab -> this.main.add((Component)((Object)tab), tab.getTabName()));
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        String[] tabNames = (String[])tabs.stream().map(PrefsTab::getTabName).toArray(String[]::new);
        JList<String> chooser = new JList<String>(tabNames);
        chooser.setBorder(BorderFactory.createEtchedBorder());
        chooser.setPrototypeCellValue("This should be wide enough");
        chooser.setSelectedIndex(0);
        chooser.setSelectionMode(0);
        chooser.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            String o = (String)chooser.getSelectedValue();
            cardLayout.show(this.main, o);
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(4, 1));
        buttons.add((Component)this.importPreferences, 0);
        buttons.add((Component)this.exportPreferences, 1);
        buttons.add((Component)this.showPreferences, 2);
        buttons.add((Component)this.resetPreferences, 3);
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BorderLayout());
        westPanel.add(chooser, "Center");
        westPanel.add((Component)buttons, "South");
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.main, "Center");
        mainPanel.add((Component)westPanel, "West");
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        ok.addActionListener(new OkAction());
        CancelAction cancelAction = new CancelAction();
        cancel.addActionListener(cancelAction);
        lower.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(lower);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)ok);
        buttonBarBuilder.addButton((JComponent)cancel);
        buttonBarBuilder.addGlue();
        KeyBinder.bindCloseDialogKeyToCancelAction(this.getRootPane(), cancelAction);
        this.exportPreferences.setToolTipText(Localization.lang("Export preferences to file", new String[0]));
        this.exportPreferences.addActionListener(new ExportAction());
        this.importPreferences.setToolTipText(Localization.lang("Import preferences from file", new String[0]));
        this.importPreferences.addActionListener(e -> {
            FileDialog dialog = new FileDialog(this.frame, this.getPrefsExportPath()).withExtension(FileExtensions.XML);
            dialog.setDefaultExtension(FileExtensions.XML);
            Optional<Path> fileName = dialog.showDialogAndGetSelectedFile();
            if (fileName.isPresent()) {
                try {
                    prefs.importPreferences(fileName.get().toString());
                    this.updateAfterPreferenceChanges();
                    JOptionPane.showMessageDialog(this, Localization.lang("You must restart JabRef for this to come into effect.", new String[0]), Localization.lang("Import preferences", new String[0]), 2);
                    this.dispose();
                }
                catch (JabRefException ex) {
                    LOGGER.warn(ex.getMessage(), ex);
                    JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), Localization.lang("Import preferences", new String[0]), 0);
                }
            }
        });
        this.showPreferences.addActionListener(e -> new PreferencesFilterDialog(new JabRefPreferencesFilter(prefs), this.frame).setVisible(true));
        this.resetPreferences.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(this, Localization.lang("Are you sure you want to reset all settings to default values?", new String[0]), Localization.lang("Reset preferences", new String[0]), 2) == 0) {
                try {
                    prefs.clear();
                    new SharedDatabasePreferences().clear();
                    JOptionPane.showMessageDialog(this, Localization.lang("You must restart JabRef for this to come into effect.", new String[0]), Localization.lang("Reset preferences", new String[0]), 2);
                }
                catch (BackingStoreException ex) {
                    LOGGER.warn(ex.getMessage(), ex);
                    JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), Localization.lang("Reset preferences", new String[0]), 0);
                }
                this.updateAfterPreferenceChanges();
            }
        });
        this.setValues();
        this.pack();
    }

    private String getPrefsExportPath() {
        return Globals.prefs.get("prefsExportPath");
    }

    private void updateAfterPreferenceChanges() {
        this.setValues();
        Map<String, ExportFormat> customFormats = Globals.prefs.customExports.getCustomExportFormats(Globals.prefs, Globals.journalAbbreviationLoader);
        LayoutFormatterPreferences layoutPreferences = Globals.prefs.getLayoutFormatterPreferences(Globals.journalAbbreviationLoader);
        SavePreferences savePreferences = SavePreferences.loadForExportFromPreferences(Globals.prefs);
        ExportFormats.initAllExports(customFormats, layoutPreferences, savePreferences);
        Globals.prefs.updateEntryEditorTabList();
    }

    private void storeAllSettings() {
        Component[] preferenceTabs;
        for (Component tab : preferenceTabs = this.main.getComponents()) {
            if (((PrefsTab)((Object)tab)).validateSettings()) continue;
            return;
        }
        for (Component tab : preferenceTabs) {
            ((PrefsTab)((Object)tab)).storeSettings();
        }
        Globals.prefs.flush();
        this.setVisible(false);
        MainTable.updateRenderers();
        GUIGlobals.updateEntryEditorColors();
        this.frame.setupAllTables();
        this.frame.getGroupSelector().revalidateGroups();
        this.frame.output(Localization.lang("Preferences recorded.", new String[0]));
    }

    public void setValues() {
        int count = this.main.getComponentCount();
        Component[] comps = this.main.getComponents();
        for (int i = 0; i < count; ++i) {
            ((PrefsTab)((Object)comps[i])).setValues();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.setVisible(false);
        }
    }

    class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super("Export");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileDialog dialog = new FileDialog(PreferencesDialog.this.frame).withExtension(FileExtensions.XML);
            dialog.setDefaultExtension(FileExtensions.XML);
            Optional<Path> path = dialog.saveNewFile();
            path.ifPresent(exportFile -> {
                try {
                    PreferencesDialog.this.storeAllSettings();
                    Globals.prefs.exportPreferences(exportFile.toString());
                    Globals.prefs.put("prefsExportPath", exportFile.toString());
                }
                catch (JabRefException ex) {
                    LOGGER.warn(ex.getMessage(), ex);
                    JOptionPane.showMessageDialog(PreferencesDialog.this, ex.getLocalizedMessage(), Localization.lang("Export preferences", new String[0]), 2);
                }
            });
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.storeAllSettings();
        }
    }
}

