/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.net.ProxyPreferences;
import net.sf.jabref.logic.net.ProxyRegisterer;
import net.sf.jabref.preferences.JabRefPreferences;

public class NetworkTab
extends JPanel
implements PrefsTab {
    private final JCheckBox useProxyCheckBox;
    private final JTextField hostnameTextField;
    private final JTextField portTextField;
    private final JCheckBox useAuthenticationCheckBox;
    private final JTextField usernameTextField;
    private final JPasswordField passwordTextField;
    private final JabRefPreferences preferences;
    private ProxyPreferences oldProxyPreferences;

    public NetworkTab(JabRefPreferences preferences) {
        this.preferences = preferences;
        this.setLayout(new BorderLayout());
        this.useProxyCheckBox = new JCheckBox(Localization.lang("Use custom proxy configuration", new String[0]));
        this.hostnameTextField = new JTextField();
        this.hostnameTextField.setEnabled(false);
        this.portTextField = new JTextField();
        this.portTextField.setEnabled(false);
        this.useAuthenticationCheckBox = new JCheckBox(Localization.lang("Proxy requires authentication", new String[0]));
        this.useAuthenticationCheckBox.setEnabled(false);
        this.usernameTextField = new JTextField();
        this.usernameTextField.setEnabled(false);
        this.passwordTextField = new JPasswordField();
        this.passwordTextField.setEnabled(false);
        JLabel passwordWarningLabel = new JLabel(Localization.lang("Attention: Password is stored in plain text!", new String[0]));
        passwordWarningLabel.setEnabled(false);
        passwordWarningLabel.setForeground(Color.RED);
        Insets margin = new Insets(0, 12, 3, 0);
        this.useProxyCheckBox.setMargin(margin);
        this.portTextField.setMargin(margin);
        this.useAuthenticationCheckBox.setMargin(margin);
        this.useProxyCheckBox.addChangeListener(event -> {
            this.hostnameTextField.setEnabled(this.useProxyCheckBox.isSelected());
            this.portTextField.setEnabled(this.useProxyCheckBox.isSelected());
            this.useAuthenticationCheckBox.setEnabled(this.useProxyCheckBox.isSelected());
        });
        this.useAuthenticationCheckBox.addChangeListener(event -> {
            this.usernameTextField.setEnabled(this.useProxyCheckBox.isSelected() && this.useAuthenticationCheckBox.isSelected());
            this.passwordTextField.setEnabled(this.useProxyCheckBox.isSelected() && this.useAuthenticationCheckBox.isSelected());
            passwordWarningLabel.setEnabled(this.useProxyCheckBox.isSelected() && this.useAuthenticationCheckBox.isSelected());
        });
        FormLayout layout = new FormLayout("8dlu, left:pref, 4dlu, left:pref, 4dlu, fill:150dlu", "p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, p");
        FormBuilder builder = FormBuilder.create().layout(layout);
        builder.addSeparator(Localization.lang("Network", new String[0]), new Object[0]).xyw(1, 1, 6);
        builder.add(this.useProxyCheckBox).xyw(2, 3, 5);
        builder.add(Localization.lang("Hostname", new String[0]) + ':', new Object[0]).xy(2, 5);
        builder.add(this.hostnameTextField).xyw(4, 5, 3);
        builder.add(Localization.lang("Port", new String[0]) + ':', new Object[0]).xy(2, 7);
        builder.add(this.portTextField).xyw(4, 7, 3);
        builder.add(this.useAuthenticationCheckBox).xyw(4, 9, 3);
        builder.add(Localization.lang("Username", new String[0]) + ':', new Object[0]).xy(4, 11);
        builder.add(this.usernameTextField).xy(6, 11);
        builder.add(Localization.lang("Password", new String[0]) + ':', new Object[0]).xy(4, 13);
        builder.add(this.passwordTextField).xy(6, 13);
        builder.add(passwordWarningLabel).xy(6, 14);
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        ProxyPreferences proxyPreferences = this.preferences.getProxyPreferences();
        this.useProxyCheckBox.setSelected(proxyPreferences.isUseProxy());
        this.hostnameTextField.setText(proxyPreferences.getHostname());
        this.portTextField.setText(proxyPreferences.getPort());
        this.useAuthenticationCheckBox.setSelected(proxyPreferences.isUseAuthentication());
        this.usernameTextField.setText(proxyPreferences.getUsername());
        this.passwordTextField.setText(proxyPreferences.getPassword());
        this.oldProxyPreferences = proxyPreferences;
    }

    @Override
    public void storeSettings() {
        String password;
        String username;
        Boolean useAuthentication;
        String port;
        String hostname;
        Boolean useProxy = this.useProxyCheckBox.isSelected();
        ProxyPreferences proxyPreferences = new ProxyPreferences(useProxy, hostname = this.hostnameTextField.getText().trim(), port = this.portTextField.getText().trim(), useAuthentication = Boolean.valueOf(this.useAuthenticationCheckBox.isSelected()), username = this.usernameTextField.getText().trim(), password = new String(this.passwordTextField.getPassword()));
        if (!proxyPreferences.equals(this.oldProxyPreferences)) {
            ProxyRegisterer.register(proxyPreferences);
        }
        this.preferences.storeProxyPreferences(proxyPreferences);
    }

    @Override
    public boolean validateSettings() {
        boolean validSetting;
        boolean validAuthenticationSetting = false;
        if (this.useProxyCheckBox.isSelected()) {
            String host = this.hostnameTextField.getText();
            String port = this.portTextField.getText();
            if (host == null || host.trim().isEmpty() || port == null || port.trim().isEmpty()) {
                validSetting = false;
            } else {
                try {
                    Integer p = Integer.parseInt(port);
                    validSetting = p > 0;
                }
                catch (NumberFormatException e) {
                    validSetting = false;
                }
            }
            if (this.useAuthenticationCheckBox.isSelected()) {
                String userName = this.usernameTextField.getText();
                char[] password = this.passwordTextField.getPassword();
                if (userName == null || userName.trim().isEmpty() || password == null || password.length == 0) {
                    validAuthenticationSetting = false;
                    validSetting = false;
                } else {
                    validAuthenticationSetting = true;
                }
            }
        } else {
            validSetting = true;
        }
        if (!validSetting) {
            if (validAuthenticationSetting) {
                JOptionPane.showMessageDialog(null, Localization.lang("Please specify both hostname and port", new String[0]), Localization.lang("Invalid setting", new String[0]), 0);
            } else {
                JOptionPane.showMessageDialog(null, Localization.lang("Please specify both username and password", new String[0]), Localization.lang("Invalid setting", new String[0]), 0);
            }
        }
        return validSetting;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Network", new String[0]);
    }
}

