/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.OSXCompatibleToolbar;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferences;

public class NameFormatterTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences prefs;
    private boolean tableChanged;
    private final JTable table;
    private int rowCount = -1;
    private final List<TableRow> tableRows = new ArrayList<TableRow>(10);

    public NameFormatterTab(JabRefPreferences prefs) {
        this.prefs = Objects.requireNonNull(prefs);
        this.setLayout(new BorderLayout());
        AbstractTableModel tableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return NameFormatterTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row >= NameFormatterTab.this.tableRows.size()) {
                    return "";
                }
                TableRow tr = (TableRow)NameFormatterTab.this.tableRows.get(row);
                if (tr == null) {
                    return "";
                }
                if (column == 0) {
                    return tr.getName();
                }
                return tr.getFormat();
            }

            @Override
            public String getColumnName(int col) {
                return col == 0 ? Localization.lang("Formatter name", new String[0]) : Localization.lang("Format string", new String[0]);
            }

            public Class<String> getColumnClass(int column) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                NameFormatterTab.this.tableChanged = true;
                while (row >= NameFormatterTab.this.tableRows.size()) {
                    NameFormatterTab.this.tableRows.add(new TableRow());
                }
                TableRow rowContent = (TableRow)NameFormatterTab.this.tableRows.get(row);
                if (col == 0) {
                    rowContent.setName(value.toString());
                } else {
                    rowContent.setFormat(value.toString());
                }
            }
        };
        this.table = new JTable(tableModel);
        GUIUtil.correctRowHeight(this.table);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(140);
        columnModel.getColumn(1).setPreferredWidth(400);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        JPanel tabPanel = new JPanel();
        tabPanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 200));
        scrollPane.setMinimumSize(new Dimension(250, 300));
        scrollPane.setPreferredSize(new Dimension(600, 300));
        tabPanel.add((Component)scrollPane, "Center");
        OSXCompatibleToolbar toolBar = new OSXCompatibleToolbar(1);
        toolBar.setFloatable(false);
        toolBar.setBorder(null);
        toolBar.add(new AddRowAction());
        toolBar.add(new DeleteRowAction());
        ((Container)toolBar).add(new HelpAction(Localization.lang("Help on Name Formatting", new String[0]), HelpFile.CUSTOM_EXPORTS_NAME_FORMATTER).getHelpButton());
        tabPanel.add((Component)toolBar, "East");
        builder.appendSeparator(Localization.lang("Special name formatters", new String[0]));
        builder.nextLine();
        builder.append(pan);
        builder.append(tabPanel);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.tableRows.clear();
        List<String> names = this.prefs.getStringList("nameFormatterNames");
        List<String> formats = this.prefs.getStringList("nameFormatterFormats");
        for (int i = 0; i < names.size(); ++i) {
            if (i < formats.size()) {
                this.tableRows.add(new TableRow(names.get(i), formats.get(i)));
                continue;
            }
            this.tableRows.add(new TableRow(names.get(i)));
        }
        this.rowCount = this.tableRows.size() + 5;
    }

    @Override
    public void storeSettings() {
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            this.table.getCellEditor(row, col).stopCellEditing();
        }
        if (this.tableChanged) {
            int i = 0;
            while (i < this.tableRows.size()) {
                if (this.tableRows.get(i).getName().isEmpty()) {
                    this.tableRows.remove(i);
                    continue;
                }
                ++i;
            }
            ArrayList<String> names = new ArrayList<String>(this.tableRows.size());
            ArrayList<String> formats = new ArrayList<String>(this.tableRows.size());
            for (TableRow tr : this.tableRows) {
                names.add(tr.getName());
                formats.add(tr.getFormat());
            }
            this.prefs.putStringList("nameFormatterNames", names);
            this.prefs.putStringList("nameFormatterFormats", formats);
        }
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Name formatter", new String[0]);
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", IconTheme.JabRefIcon.ADD_NOBOX.getIcon());
            this.putValue("ShortDescription", Localization.lang("Insert rows", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = NameFormatterTab.this.table.getSelectedRows();
            if (rows.length == 0) {
                NameFormatterTab.this.rowCount++;
                NameFormatterTab.this.table.revalidate();
                NameFormatterTab.this.table.repaint();
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] + i - 1 >= NameFormatterTab.this.tableRows.size()) continue;
                NameFormatterTab.this.tableRows.add(Math.max(0, rows[i] + i - 1), new TableRow());
            }
            NameFormatterTab.this.rowCount = NameFormatterTab.this.rowCount + rows.length;
            if (rows.length > 1) {
                NameFormatterTab.this.table.clearSelection();
            }
            NameFormatterTab.this.table.revalidate();
            NameFormatterTab.this.table.repaint();
            NameFormatterTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", IconTheme.JabRefIcon.REMOVE_NOBOX.getIcon());
            this.putValue("ShortDescription", Localization.lang("Delete rows", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NameFormatterTab.this.tableChanged = true;
            int[] selectedRows = NameFormatterTab.this.table.getSelectedRows();
            int numberDeleted = 0;
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                if (selectedRows[i] >= NameFormatterTab.this.tableRows.size()) continue;
                NameFormatterTab.this.tableRows.remove(selectedRows[i]);
                ++numberDeleted;
            }
            NameFormatterTab.this.rowCount = NameFormatterTab.this.rowCount - numberDeleted;
            if (selectedRows.length > 1) {
                NameFormatterTab.this.table.clearSelection();
            }
            NameFormatterTab.this.table.revalidate();
            NameFormatterTab.this.table.repaint();
        }
    }

    static class TableRow {
        private String name;
        private String format;

        public TableRow() {
            this("");
        }

        public TableRow(String name) {
            this(name, "1@*@{ff }{vv }{ll}{, jj}@@*@1@{ff }{vv }{ll}{, jj}@*@, {ff }{vv }{ll}{, jj}");
        }

        public TableRow(String name, String format) {
            this.name = name;
            this.format = format;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }
}

