/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferences;

public class ImportSettingsTab
extends JPanel
implements PrefsTab {
    public static final int DEFAULT_STYLE = 2;
    private static final String[] DEFAULT_FILENAMEPATTERNS_DISPLAY = new String[]{"bibtexkey", "bibtexkey - title"};
    public static final String[] DEFAULT_FILENAMEPATTERNS = new String[]{"\\bibtexkey", "\\bibtexkey\\begin{title} - \\format[RemoveBrackets]{\\title}\\end{title}"};
    private final JabRefPreferences prefs;
    private final JRadioButton radioButtonXmp;
    private final JRadioButton radioButtonPDFcontent;
    private final JRadioButton radioButtonNoMeta;
    private final JRadioButton radioButtononlyAttachPDF;
    private final JCheckBox useDefaultPDFImportStyle;
    private final JTextField fileNamePattern;
    private final JButton selectFileNamePattern;

    public ImportSettingsTab(JabRefPreferences prefs) {
        this.prefs = Objects.requireNonNull(prefs);
        this.setLayout(new BorderLayout());
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:3dlu");
        this.radioButtonNoMeta = new JRadioButton(Localization.lang("Create_blank_entry_linking_the_PDF", new String[0]));
        this.radioButtonXmp = new JRadioButton(Localization.lang("Create_entry_based_on_XMP_data", new String[0]));
        this.radioButtonPDFcontent = new JRadioButton(Localization.lang("Create_entry_based_on_content", new String[0]));
        this.radioButtononlyAttachPDF = new JRadioButton(Localization.lang("Only_attach_PDF", new String[0]));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioButtonNoMeta);
        bg.add(this.radioButtonXmp);
        bg.add(this.radioButtonPDFcontent);
        bg.add(this.radioButtononlyAttachPDF);
        this.useDefaultPDFImportStyle = new JCheckBox(Localization.lang("Always use this PDF import style (and do not ask for each import)", new String[0]));
        this.fileNamePattern = new JTextField(50);
        this.selectFileNamePattern = new JButton(Localization.lang("Choose pattern", new String[0]));
        this.selectFileNamePattern.addActionListener(e -> this.openFilePatternMenu());
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        builder.appendSeparator(Localization.lang("Default import style for drag and drop of PDFs", new String[0]));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonNoMeta);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonXmp);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonPDFcontent);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtononlyAttachPDF);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.useDefaultPDFImportStyle);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Default PDF file link action", new String[0]));
        builder.nextLine();
        builder.append(pan);
        JPanel pan2 = new JPanel();
        JLabel lab = new JLabel(Localization.lang("Filename format pattern", new String[0]).concat(":"));
        pan2.add(lab);
        pan2.add(this.fileNamePattern);
        pan2.add(this.selectFileNamePattern);
        builder.append(pan2);
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.useDefaultPDFImportStyle.setSelected(this.prefs.getBoolean("importAlwaysUsePDFImportStyle"));
        int style = this.prefs.getInt("importDefaultPDFimportStyle");
        switch (style) {
            case 0: {
                this.radioButtonNoMeta.setSelected(true);
                break;
            }
            case 1: {
                this.radioButtonXmp.setSelected(true);
                break;
            }
            case 2: {
                this.radioButtonPDFcontent.setSelected(true);
                break;
            }
            case 4: {
                this.radioButtononlyAttachPDF.setSelected(true);
                break;
            }
            default: {
                this.radioButtonPDFcontent.setSelected(true);
            }
        }
        this.fileNamePattern.setText(this.prefs.get("importFileNamePattern"));
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("importAlwaysUsePDFImportStyle", this.useDefaultPDFImportStyle.isSelected());
        int style = 2;
        if (this.radioButtonNoMeta.isSelected()) {
            style = 0;
        } else if (this.radioButtonXmp.isSelected()) {
            style = 1;
        } else if (this.radioButtonPDFcontent.isSelected()) {
            style = 2;
        } else if (this.radioButtononlyAttachPDF.isSelected()) {
            style = 4;
        }
        this.prefs.putInt("importDefaultPDFimportStyle", style);
        this.prefs.put("importFileNamePattern", this.fileNamePattern.getText());
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Import", new String[0]);
    }

    private void openFilePatternMenu() {
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < DEFAULT_FILENAMEPATTERNS.length; ++i) {
            JMenuItem item = new JMenuItem(DEFAULT_FILENAMEPATTERNS_DISPLAY[i]);
            String toSet = DEFAULT_FILENAMEPATTERNS[i];
            item.addActionListener(e -> this.fileNamePattern.setText(toSet));
            popup.add(item);
        }
        popup.show(this.selectFileNamePattern, 0, this.selectFileNamePattern.getHeight());
    }
}

