/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferences;

class GroupsPrefsTab
extends JPanel
implements PrefsTab {
    private final JCheckBox showIcons = new JCheckBox(Localization.lang("Show icons for groups", new String[0]));
    private final JCheckBox showDynamic = new JCheckBox("<html>" + Localization.lang("Show dynamic groups in <i>italics</i>", new String[0]) + "</html>");
    private final JCheckBox expandTree = new JCheckBox(Localization.lang("Initially show groups tree expanded", new String[0]));
    private final JCheckBox autoAssignGroup = new JCheckBox(Localization.lang("Automatically assign new entry to selected groups", new String[0]));
    private final JTextField groupingField = new JTextField(20);
    private final JTextField keywordSeparator = new JTextField(2);
    private final JabRefPreferences prefs;

    public GroupsPrefsTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.keywordSeparator.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GroupsPrefsTab.this.keywordSeparator.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        FormLayout layout = new FormLayout("9dlu, pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Localization.lang("View", new String[0]));
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.showIcons);
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.showDynamic);
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.expandTree);
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        builder.append(this.autoAssignGroup);
        builder.nextLine();
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Dynamic groups", new String[0]));
        builder.nextLine();
        builder.nextLine();
        builder.nextColumn();
        FormLayout layout2 = new FormLayout("left:pref, 2dlu, left:pref", "p, 3dlu, p");
        DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
        builder2.append(new JLabel(Localization.lang("Default grouping field", new String[0]) + ":"));
        builder2.append(this.groupingField);
        builder2.nextLine();
        builder2.nextLine();
        builder2.append(new JLabel(Localization.lang("When adding/removing keywords, separate them by", new String[0]) + ":"));
        builder2.append(this.keywordSeparator);
        builder.append(builder2.getPanel());
        this.setLayout(new BorderLayout());
        JPanel panel = builder.getPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)panel, "Center");
    }

    @Override
    public void setValues() {
        this.showIcons.setSelected(this.prefs.getBoolean("groupShowIcons"));
        this.showDynamic.setSelected(this.prefs.getBoolean("groupShowDynamic"));
        this.expandTree.setSelected(this.prefs.getBoolean("groupExpandTree"));
        this.groupingField.setText(this.prefs.get("groupsDefaultField"));
        this.keywordSeparator.setText(this.prefs.get("groupKeywordSeparator"));
        this.autoAssignGroup.setSelected(this.prefs.getBoolean("autoAssignGroup"));
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("groupShowIcons", this.showIcons.isSelected());
        this.prefs.putBoolean("groupShowDynamic", this.showDynamic.isSelected());
        this.prefs.putBoolean("groupExpandTree", this.expandTree.isSelected());
        this.prefs.put("groupsDefaultField", this.groupingField.getText().trim());
        this.prefs.putBoolean("autoAssignGroup", this.autoAssignGroup.isSelected());
        this.prefs.put("groupKeywordSeparator", this.keywordSeparator.getText());
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Groups", new String[0]);
    }
}

