/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Encodings;
import net.sf.jabref.logic.l10n.Languages;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.InternalBibtexFields;
import net.sf.jabref.preferences.JabRefPreferences;

class GeneralTab
extends JPanel
implements PrefsTab {
    private final JCheckBox useOwner;
    private final JCheckBox overwriteOwner;
    private final JCheckBox enforceLegalKeys;
    private final JCheckBox confirmDelete;
    private final JCheckBox memoryStick;
    private final JCheckBox inspectionWarnDupli;
    private final JCheckBox useTimeStamp;
    private final JCheckBox updateTimeStamp;
    private final JCheckBox overwriteTimeStamp;
    private final JCheckBox markImportedEntries;
    private final JCheckBox unmarkAllEntriesBeforeImporting;
    private final JTextField defOwnerField;
    private final JTextField timeStampFormat;
    private final JTextField timeStampField;
    private final JabRefPreferences prefs;
    private final JComboBox<String> language = new JComboBox<String>(Languages.LANGUAGES.keySet().toArray(new String[Languages.LANGUAGES.keySet().size()]));
    private final JComboBox<Charset> encodings;
    private final JComboBox<BibDatabaseMode> biblatexMode;

    public GeneralTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.setLayout(new BorderLayout());
        this.biblatexMode = new JComboBox<BibDatabaseMode>(BibDatabaseMode.values());
        this.biblatexMode.setRenderer(new DefaultBibModeRenderer());
        this.memoryStick = new JCheckBox(Localization.lang("Load and Save preferences from/to jabref.xml on start-up (memory stick mode)", new String[0]));
        this.useOwner = new JCheckBox(Localization.lang("Mark new entries with owner name", new String[0]) + ':');
        this.updateTimeStamp = new JCheckBox(Localization.lang("Update timestamp on modification", new String[0]));
        this.useTimeStamp = new JCheckBox(Localization.lang("Mark new entries with addition date", new String[0]) + ". " + Localization.lang("Date format", new String[0]) + ':');
        this.useTimeStamp.addChangeListener(e -> this.updateTimeStamp.setEnabled(this.useTimeStamp.isSelected()));
        this.overwriteOwner = new JCheckBox(Localization.lang("Overwrite", new String[0]));
        this.overwriteTimeStamp = new JCheckBox(Localization.lang("Overwrite", new String[0]));
        this.overwriteOwner.setToolTipText(Localization.lang("If a pasted or imported entry already has the field set, overwrite.", new String[0]));
        this.overwriteTimeStamp.setToolTipText(Localization.lang("If a pasted or imported entry already has the field set, overwrite.", new String[0]));
        this.enforceLegalKeys = new JCheckBox(Localization.lang("Enforce legal characters in BibTeX keys", new String[0]));
        this.confirmDelete = new JCheckBox(Localization.lang("Show confirmation dialog when deleting entries", new String[0]));
        this.markImportedEntries = new JCheckBox(Localization.lang("Mark entries imported into an existing database", new String[0]));
        this.unmarkAllEntriesBeforeImporting = new JCheckBox(Localization.lang("Unmark all entries before importing new entries into an existing database", new String[0]));
        this.defOwnerField = new JTextField();
        this.timeStampFormat = new JTextField();
        this.timeStampField = new JTextField();
        this.inspectionWarnDupli = new JCheckBox(Localization.lang("Warn about unresolved duplicates when closing inspection window", new String[0]));
        this.encodings = new JComboBox();
        this.encodings.setModel(new DefaultComboBoxModel<Charset>(Encodings.ENCODINGS));
        FormLayout layout = new FormLayout("8dlu, 1dlu, left:pref:grow, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, left:pref, 1dlu, left:pref, 4dlu, left:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Localization.lang("General", new String[0]));
        builder.nextLine();
        builder.append((Component)this.inspectionWarnDupli, 13);
        builder.nextLine();
        builder.append((Component)this.confirmDelete, 13);
        builder.nextLine();
        builder.append((Component)this.enforceLegalKeys, 13);
        builder.nextLine();
        builder.append((Component)this.memoryStick, 13);
        builder.append((Component)this.useOwner, 3);
        builder.append(this.defOwnerField);
        builder.append(this.overwriteOwner);
        builder.append((Component)new JPanel(), 3);
        JButton help = new HelpAction(HelpFile.OWNER).getHelpButton();
        builder.append(help);
        builder.nextLine();
        builder.append((Component)this.useTimeStamp, 3);
        builder.append(this.timeStampFormat);
        builder.append(this.overwriteTimeStamp);
        builder.append(Localization.lang("Field name", new String[0]) + ':');
        builder.append(this.timeStampField);
        help = new HelpAction(HelpFile.TIMESTAMP).getHelpButton();
        builder.append(help);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.updateTimeStamp, 11);
        builder.nextLine();
        builder.append((Component)this.markImportedEntries, 13);
        builder.nextLine();
        builder.append((Component)this.unmarkAllEntriesBeforeImporting, 13);
        builder.nextLine();
        JLabel lab = new JLabel(Localization.lang("Language", new String[0]) + ':');
        builder.append((Component)lab, 3);
        builder.append(this.language);
        builder.nextLine();
        lab = new JLabel(Localization.lang("Default encoding", new String[0]) + ':');
        builder.append((Component)lab, 3);
        builder.append(this.encodings);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Default bibliography mode", new String[0]));
        builder.append(new JPanel());
        builder.append(this.biblatexMode);
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.useOwner.setSelected(this.prefs.getBoolean("useOwner"));
        this.overwriteOwner.setSelected(this.prefs.getBoolean("overwriteOwner"));
        this.useTimeStamp.setSelected(this.prefs.getBoolean("useTimeStamp"));
        this.overwriteTimeStamp.setSelected(this.prefs.getBoolean("overwriteTimeStamp"));
        this.updateTimeStamp.setSelected(this.prefs.getBoolean("updateTimestamp"));
        this.updateTimeStamp.setEnabled(this.useTimeStamp.isSelected());
        this.enforceLegalKeys.setSelected(this.prefs.getBoolean("enforceLegalBibtexKey"));
        this.memoryStick.setSelected(this.prefs.getBoolean("memoryStickMode"));
        this.confirmDelete.setSelected(this.prefs.getBoolean("confirmDelete"));
        this.defOwnerField.setText(this.prefs.get("defaultOwner"));
        this.timeStampFormat.setText(this.prefs.get("timeStampFormat"));
        this.timeStampField.setText(this.prefs.get("timeStampField"));
        this.inspectionWarnDupli.setSelected(this.prefs.getBoolean("warnAboutDuplicatesInInspection"));
        this.markImportedEntries.setSelected(this.prefs.getBoolean("markImportedEntries"));
        this.unmarkAllEntriesBeforeImporting.setSelected(this.prefs.getBoolean("unmarkAllEntriesBeforeImporting"));
        if (Globals.prefs.getBoolean("biblatexMode")) {
            this.biblatexMode.setSelectedItem((Object)BibDatabaseMode.BIBLATEX);
        } else {
            this.biblatexMode.setSelectedItem((Object)BibDatabaseMode.BIBTEX);
        }
        Charset enc = Globals.prefs.getDefaultEncoding();
        this.encodings.setSelectedItem(enc);
        String oldLan = this.prefs.get("language");
        int ilk = 0;
        for (String lan : Languages.LANGUAGES.values()) {
            if (lan.equals(oldLan)) {
                this.language.setSelectedIndex(ilk);
            }
            ++ilk;
        }
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("useOwner", this.useOwner.isSelected());
        this.prefs.putBoolean("overwriteOwner", this.overwriteOwner.isSelected());
        this.prefs.putBoolean("useTimeStamp", this.useTimeStamp.isSelected());
        this.prefs.putBoolean("overwriteTimeStamp", this.overwriteTimeStamp.isSelected());
        this.prefs.putBoolean("updateTimestamp", this.updateTimeStamp.isSelected());
        this.prefs.putBoolean("enforceLegalBibtexKey", this.enforceLegalKeys.isSelected());
        if (this.prefs.getBoolean("memoryStickMode") && !this.memoryStick.isSelected()) {
            JOptionPane.showMessageDialog(null, Localization.lang("To disable the memory stick mode rename or remove the jabref.xml file in the same folder as JabRef.", new String[0]), Localization.lang("Memory stick mode", new String[0]), 1);
        }
        this.prefs.putBoolean("memoryStickMode", this.memoryStick.isSelected());
        this.prefs.putBoolean("confirmDelete", this.confirmDelete.isSelected());
        this.prefs.putBoolean("warnAboutDuplicatesInInspection", this.inspectionWarnDupli.isSelected());
        String owner = this.defOwnerField.getText().trim();
        this.prefs.put("defaultOwner", owner);
        this.prefs.put("timeStampFormat", this.timeStampFormat.getText().trim());
        this.prefs.put("timeStampField", this.timeStampField.getText().trim());
        InternalBibtexFields.updateTimeStampField(Globals.prefs.get("timeStampField"));
        this.prefs.setDefaultEncoding((Charset)this.encodings.getSelectedItem());
        this.prefs.putBoolean("markImportedEntries", this.markImportedEntries.isSelected());
        this.prefs.putBoolean("unmarkAllEntriesBeforeImporting", this.unmarkAllEntriesBeforeImporting.isSelected());
        this.prefs.putBoolean("biblatexMode", this.biblatexMode.getSelectedItem() == BibDatabaseMode.BIBLATEX);
        if (!Languages.LANGUAGES.get(this.language.getSelectedItem()).equals(this.prefs.get("language"))) {
            this.prefs.put("language", Languages.LANGUAGES.get(this.language.getSelectedItem()));
            Localization.setLanguage(Languages.LANGUAGES.get(this.language.getSelectedItem()));
            Globals.prefs.setLanguageDependentDefaultValues();
            JOptionPane.showMessageDialog(null, Localization.lang("You have changed the language setting.", new String[0]).concat(" ").concat(Localization.lang("You must restart JabRef for this to come into effect.", new String[0])), Localization.lang("Changed language settings", new String[0]), 2);
        }
    }

    @Override
    public boolean validateSettings() {
        try {
            DateTimeFormatter.ofPattern(this.timeStampFormat.getText());
        }
        catch (IllegalArgumentException ex2) {
            JOptionPane.showMessageDialog(null, Localization.lang("The chosen date format for new entries is not valid", new String[0]), Localization.lang("Invalid date format", new String[0]), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("General", new String[0]);
    }

    public class DefaultBibModeRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(((BibDatabaseMode)((Object)value)).getFormattedName());
            return this;
        }
    }
}

