/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.logic.l10n.Localization;

public class FontSelectorDialog
extends JDialog {
    private static final String PLAIN = "plain";
    private static final String BOLD = "bold";
    private static final String BOLD_ITALIC = "bold-italic";
    private static final String ITALIC = "italic";
    private static final String[] styles = new String[]{"plain", "bold", "italic", "bold-italic"};
    private static final String[] sizes = new String[]{"9", "10", "12", "14", "16", "18", "24"};
    private boolean isOK;
    private final JTextField familyField = new JTextField();
    private final JList<String> familyList;
    private final JTextField sizeField = new JTextField();
    private final JList<String> sizeList = new JList<String>(sizes);
    private final JTextField styleField = new JTextField();
    private final JList<String> styleList = new JList<String>(styles);
    private final JLabel preview;
    private static final String[] HIDEFONTS = new String[]{".bold", ".italic"};

    public FontSelectorDialog(Component comp, Font font) {
        super(JOptionPane.getFrameForComponent(comp), Localization.lang("Font selection", new String[0]), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel listPanel = new JPanel(new GridLayout(1, 3, 6, 6));
        this.familyList = new JList<String>(FontSelectorDialog.getFontList());
        JPanel familyPanel = FontSelectorDialog.createTextFieldAndListPanel(Localization.lang("Font family", new String[0]), this.familyField, this.familyList);
        listPanel.add(familyPanel);
        JPanel sizePanel = FontSelectorDialog.createTextFieldAndListPanel(Localization.lang("Font size", new String[0]), this.sizeField, this.sizeList);
        listPanel.add(sizePanel);
        JPanel stylePanel = FontSelectorDialog.createTextFieldAndListPanel(Localization.lang("Font style", new String[0]), this.styleField, this.styleList);
        this.styleField.setEditable(false);
        listPanel.add(stylePanel);
        this.familyList.setSelectedValue(font.getFamily(), true);
        this.familyField.setText(font.getFamily());
        this.sizeList.setSelectedValue(String.valueOf(font.getSize()), true);
        this.sizeField.setText(String.valueOf(font.getSize()));
        this.styleList.setSelectedIndex(font.getStyle());
        this.styleField.setText(this.styleList.getSelectedValue());
        ListHandler listHandler = new ListHandler();
        this.familyList.addListSelectionListener(listHandler);
        this.sizeList.addListSelectionListener(listHandler);
        this.styleList.addListSelectionListener(listHandler);
        content.add("North", listPanel);
        this.preview = new JLabel(Localization.lang("Font preview", new String[0])){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(g2);
            }
        };
        this.preview.setBorder(new TitledBorder(Localization.lang("Font preview", new String[0])));
        this.updatePreview();
        Dimension prefSize = this.preview.getPreferredSize();
        prefSize.height = 50;
        this.preview.setPreferredSize(prefSize);
        content.add("Center", this.preview);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        ok.addActionListener(e -> {
            this.isOK = true;
            this.dispose();
        });
        this.getRootPane().setDefaultButton(ok);
        buttons.add(ok);
        buttons.add(Box.createHorizontalStrut(6));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.addActionListener(e -> this.dispose());
        buttons.add(cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(comp));
        this.setVisible(true);
    }

    public Optional<Font> getSelectedFont() {
        int size;
        if (!this.isOK) {
            return Optional.empty();
        }
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (NumberFormatException e) {
            size = 14;
        }
        return Optional.of(new Font(this.familyField.getText(), this.styleList.getSelectedIndex(), size));
    }

    private static String[] getFontList() {
        try {
            String[] nameArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            ArrayList<String> nameList = new ArrayList<String>(nameArray.length);
            for (String fontName : nameArray) {
                boolean hidden = false;
                for (String hiddenName : HIDEFONTS) {
                    if (!fontName.contains(hiddenName)) continue;
                    hidden = true;
                    break;
                }
                if (hidden) continue;
                nameList.add(fontName);
            }
            String[] resultArray = new String[nameList.size()];
            return nameList.toArray(resultArray);
        }
        catch (IllegalArgumentException | SecurityException ex) {
            return new String[0];
        }
    }

    private static JPanel createTextFieldAndListPanel(String labelString, JTextField textField, JList<String> list) {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.fill = 1;
        cons.weightx = 1.0;
        JLabel label = new JLabel(labelString);
        layout.setConstraints(label, cons);
        panel.add(label);
        cons.gridy = 1;
        Component vs = Box.createVerticalStrut(6);
        layout.setConstraints(vs, cons);
        panel.add(vs);
        cons.gridy = 2;
        layout.setConstraints(textField, cons);
        panel.add(textField);
        cons.gridy = 3;
        vs = Box.createVerticalStrut(6);
        layout.setConstraints(vs, cons);
        panel.add(vs);
        cons.gridy = 4;
        cons.gridheight = 0;
        cons.weighty = 1.0;
        JScrollPane scroller = new JScrollPane(list);
        layout.setConstraints(scroller, cons);
        panel.add(scroller);
        return panel;
    }

    private void updatePreview() {
        int size;
        String family = this.familyField.getText();
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (NumberFormatException e) {
            size = 14;
        }
        int style = this.styleList.getSelectedIndex();
        this.preview.setFont(new Font(family, style, size));
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            String style;
            Object source = evt.getSource();
            if (FontSelectorDialog.this.familyList.equals(source)) {
                String family = (String)FontSelectorDialog.this.familyList.getSelectedValue();
                if (family != null) {
                    FontSelectorDialog.this.familyField.setText(family);
                }
            } else if (FontSelectorDialog.this.sizeList.equals(source)) {
                String size = (String)FontSelectorDialog.this.sizeList.getSelectedValue();
                if (size != null) {
                    FontSelectorDialog.this.sizeField.setText(size);
                }
            } else if (FontSelectorDialog.this.styleList.equals(source) && (style = (String)FontSelectorDialog.this.styleList.getSelectedValue()) != null) {
                FontSelectorDialog.this.styleField.setText(style);
            }
            FontSelectorDialog.this.updatePreview();
        }
    }
}

