/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.preferences.JabRefPreferences;

class FileTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences prefs;
    private final JabRefFrame frame;
    private final JCheckBox backup;
    private final JCheckBox localAutoSave;
    private final JCheckBox openLast;
    private final JComboBox<String> newlineSeparator;
    private final JCheckBox reformatFileOnSaveAndExport;
    private final JRadioButton resolveStringsStandard;
    private final JRadioButton resolveStringsAll;
    private final JTextField nonWrappableFields;
    private final JTextField doNotResolveStringsFor;
    private final JTextField fileDir;
    private final JCheckBox bibLocAsPrimaryDir;
    private final JCheckBox runAutoFileSearch;
    private final JCheckBox allowFileAutoOpenBrowse;
    private final JRadioButton useRegExpComboBox;
    private final JRadioButton matchExactKeyOnly = new JRadioButton(Localization.lang("Autolink only files that match the BibTeX key", new String[0]));
    private final JRadioButton matchStartsWithKey = new JRadioButton(Localization.lang("Autolink files with names starting with the BibTeX key", new String[0]));
    private final JTextField regExpTextField;

    public FileTab(JabRefFrame frame, JabRefPreferences prefs) {
        this.prefs = prefs;
        this.frame = frame;
        this.fileDir = new JTextField(25);
        this.bibLocAsPrimaryDir = new JCheckBox(Localization.lang("Use the BIB file location as primary file directory", new String[0]));
        this.bibLocAsPrimaryDir.setToolTipText(Localization.lang("When downloading files, or moving linked files to the file directory, prefer the BIB file location rather than the file directory set above", new String[0]));
        this.runAutoFileSearch = new JCheckBox(Localization.lang("When opening file link, search for matching file if no link is defined", new String[0]));
        this.allowFileAutoOpenBrowse = new JCheckBox(Localization.lang("Automatically open browse dialog when creating new file link", new String[0]));
        this.regExpTextField = new JTextField(25);
        this.useRegExpComboBox = new JRadioButton(Localization.lang("Use regular expression search", new String[0]));
        ItemListener regExpListener = e -> this.regExpTextField.setEditable(this.useRegExpComboBox.isSelected());
        this.useRegExpComboBox.addItemListener(regExpListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.matchExactKeyOnly);
        buttonGroup.add(this.matchStartsWithKey);
        buttonGroup.add(this.useRegExpComboBox);
        this.openLast = new JCheckBox(Localization.lang("Open last edited databases at startup", new String[0]));
        this.backup = new JCheckBox(Localization.lang("Backup old file when saving", new String[0]));
        this.localAutoSave = new JCheckBox(Localization.lang("Autosave local databases", new String[0]));
        this.resolveStringsAll = new JRadioButton(Localization.lang("Resolve strings for all fields except", new String[0]) + ":");
        this.resolveStringsStandard = new JRadioButton(Localization.lang("Resolve strings for standard BibTeX fields only", new String[0]));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.resolveStringsAll);
        bg.add(this.resolveStringsStandard);
        this.newlineSeparator = new JComboBox<String>(new String[]{"CR", "CR/LF", "LF"});
        this.reformatFileOnSaveAndExport = new JCheckBox(Localization.lang("Always reformat BIB file on save and export", new String[0]));
        this.nonWrappableFields = new JTextField(25);
        this.doNotResolveStringsFor = new JTextField(30);
        FormLayout layout = new FormLayout("left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Localization.lang("General", new String[0]));
        builder.nextLine();
        builder.append((Component)this.openLast, 3);
        builder.nextLine();
        builder.append((Component)this.backup, 3);
        builder.nextLine();
        JLabel label = new JLabel(Localization.lang("Do not wrap the following fields when saving", new String[0]) + ":");
        builder.append(label);
        builder.append(this.nonWrappableFields);
        builder.nextLine();
        builder.append((Component)this.resolveStringsStandard, 3);
        builder.nextLine();
        builder.append(this.resolveStringsAll);
        builder.append(this.doNotResolveStringsFor);
        builder.nextLine();
        JLabel lab = new JLabel(Localization.lang("Newline separator", new String[0]) + ":");
        builder.append(lab);
        builder.append(this.newlineSeparator);
        builder.nextLine();
        builder.append((Component)this.reformatFileOnSaveAndExport, 3);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("External file links", new String[0]));
        builder.nextLine();
        lab = new JLabel(Localization.lang("Main file directory", new String[0]) + ':');
        builder.append(lab);
        builder.append(this.fileDir);
        JButton browse = new JButton(Localization.lang("Browse", new String[0]));
        browse.addActionListener(e -> new FileDialog(this.frame).showDialogAndGetSelectedDirectory().ifPresent(f -> this.fileDir.setText(f.toAbsolutePath().toString())));
        builder.append(browse);
        builder.nextLine();
        builder.append((Component)this.bibLocAsPrimaryDir, 3);
        builder.nextLine();
        builder.append((Component)this.matchStartsWithKey, 3);
        builder.nextLine();
        builder.append((Component)this.matchExactKeyOnly, 3);
        builder.nextLine();
        builder.append(this.useRegExpComboBox);
        builder.append(this.regExpTextField);
        builder.append(new HelpAction(Localization.lang("Help on regular expression search", new String[0]), HelpFile.REGEX_SEARCH).getHelpButton());
        builder.nextLine();
        builder.append((Component)this.runAutoFileSearch, 3);
        builder.nextLine();
        builder.append(this.allowFileAutoOpenBrowse);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Autosave", new String[0]));
        builder.append((Component)this.localAutoSave, 1);
        JButton help = new HelpAction(HelpFile.AUTOSAVE).getHelpButton();
        help.setPreferredSize(new Dimension(24, 24));
        JPanel hPan = new JPanel();
        hPan.setLayout(new BorderLayout());
        hPan.add((Component)help, "East");
        builder.append(hPan);
        builder.nextLine();
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.fileDir.setText(this.prefs.get("fileDirectory"));
        this.bibLocAsPrimaryDir.setSelected(this.prefs.getBoolean("bibLocAsPrimaryDir"));
        this.runAutoFileSearch.setSelected(this.prefs.getBoolean("runAutomaticFileSearch"));
        this.allowFileAutoOpenBrowse.setSelected(this.prefs.getBoolean("allowFileAutoOpenBrowse"));
        this.regExpTextField.setText(this.prefs.get("regExpSearchExpression"));
        if (this.prefs.getBoolean("useRegExpSearch")) {
            this.useRegExpComboBox.setSelected(true);
        } else if (this.prefs.getBoolean("autolinkExactKeyOnly")) {
            this.matchExactKeyOnly.setSelected(true);
        } else {
            this.matchStartsWithKey.setSelected(true);
        }
        this.openLast.setSelected(this.prefs.getBoolean("openLastEdited"));
        this.backup.setSelected(this.prefs.getBoolean("backup"));
        String newline = this.prefs.get("newline");
        if ("\r".equals(newline)) {
            this.newlineSeparator.setSelectedIndex(0);
        } else if ("\n".equals(newline)) {
            this.newlineSeparator.setSelectedIndex(2);
        } else {
            this.newlineSeparator.setSelectedIndex(1);
        }
        this.reformatFileOnSaveAndExport.setSelected(this.prefs.getBoolean("reformatFileOnSaveAndExport"));
        this.resolveStringsAll.setSelected(this.prefs.getBoolean("resolveStringsAllFields"));
        this.resolveStringsStandard.setSelected(!this.resolveStringsAll.isSelected());
        this.doNotResolveStringsFor.setText(this.prefs.get("doNotResolveStringsFor"));
        this.nonWrappableFields.setText(this.prefs.get("nonWrappableFields"));
        this.localAutoSave.setSelected(this.prefs.getBoolean("localAutoSave"));
    }

    @Override
    public void storeSettings() {
        String newline;
        this.prefs.put("fileDirectory", this.fileDir.getText());
        this.prefs.putBoolean("bibLocAsPrimaryDir", this.bibLocAsPrimaryDir.isSelected());
        this.prefs.putBoolean("runAutomaticFileSearch", this.runAutoFileSearch.isSelected());
        this.prefs.putBoolean("allowFileAutoOpenBrowse", this.allowFileAutoOpenBrowse.isSelected());
        this.prefs.putBoolean("useRegExpSearch", this.useRegExpComboBox.isSelected());
        this.prefs.putBoolean("autolinkExactKeyOnly", this.matchExactKeyOnly.isSelected());
        if (this.useRegExpComboBox.isSelected()) {
            this.prefs.put("regExpSearchExpression", this.regExpTextField.getText());
        }
        switch (this.newlineSeparator.getSelectedIndex()) {
            case 0: {
                newline = "\r";
                break;
            }
            case 2: {
                newline = "\n";
                break;
            }
            default: {
                newline = "\r\n";
            }
        }
        this.prefs.put("newline", newline);
        OS.NEWLINE = newline;
        this.prefs.putBoolean("reformatFileOnSaveAndExport", this.reformatFileOnSaveAndExport.isSelected());
        this.prefs.putBoolean("openLastEdited", this.openLast.isSelected());
        this.prefs.putBoolean("resolveStringsAllFields", this.resolveStringsAll.isSelected());
        this.prefs.put("doNotResolveStringsFor", this.doNotResolveStringsFor.getText().trim());
        this.doNotResolveStringsFor.setText(this.prefs.get("doNotResolveStringsFor"));
        if (!this.nonWrappableFields.getText().trim().equals(this.prefs.get("nonWrappableFields"))) {
            this.prefs.put("nonWrappableFields", this.nonWrappableFields.getText());
        }
        this.prefs.putBoolean("localAutoSave", this.localAutoSave.isSelected());
    }

    @Override
    public boolean validateSettings() {
        boolean valid;
        Path path = Paths.get(this.fileDir.getText(), new String[0]);
        boolean bl = valid = Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
        if (!valid) {
            String content = String.format("%s -> %s %n %n %s: %n %s", Localization.lang("File", new String[0]), Localization.lang("Main file directory", new String[0]), Localization.lang("Directory not found", new String[0]), path);
            JOptionPane.showMessageDialog(this.frame, content, Localization.lang("Error", new String[0]), 0);
        }
        return valid;
    }

    @Override
    public String getTabName() {
        return Localization.lang("File", new String[0]);
    }
}

