/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypeEditor;
import net.sf.jabref.gui.preftabs.PreferencesDialog;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.gui.push.PushToApplication;
import net.sf.jabref.gui.push.PushToApplicationButton;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferences;

class ExternalTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences prefs;
    private final JabRefFrame frame;
    private final JTextField emailSubject;
    private final JTextField citeCommand;
    private final JCheckBox openFoldersOfAttachedFiles;
    private final JRadioButton defaultConsole;
    private final JRadioButton executeConsole;
    private final JTextField consoleCommand;
    private final JButton browseButton;

    public ExternalTab(JabRefFrame frame, PreferencesDialog prefsDiag, JabRefPreferences prefs) {
        this.prefs = prefs;
        this.frame = frame;
        this.setLayout(new BorderLayout());
        JButton editFileTypes = new JButton(Localization.lang("Manage external file types", new String[0]));
        this.citeCommand = new JTextField(25);
        editFileTypes.addActionListener(ExternalFileTypeEditor.getAction(prefsDiag));
        this.defaultConsole = new JRadioButton(Localization.lang("Use default terminal emulator", new String[0]));
        this.executeConsole = new JRadioButton(Localization.lang("Execute command", new String[0]) + ":");
        this.consoleCommand = new JTextField();
        this.browseButton = new JButton(Localization.lang("Browse", new String[0]));
        JLabel commandDescription = new JLabel(Localization.lang("Note: Use the placeholder %0 for the location of the opened database file.", "%DIR"));
        ButtonGroup consoleOptions = new ButtonGroup();
        consoleOptions.add(this.defaultConsole);
        consoleOptions.add(this.executeConsole);
        JPanel consoleOptionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        this.defaultConsole.addActionListener(e -> this.updateExecuteConsoleButtonAndFieldEnabledState());
        this.executeConsole.addActionListener(e -> this.updateExecuteConsoleButtonAndFieldEnabledState());
        this.browseButton.addActionListener(e -> this.showConsoleChooser());
        layoutConstraints.fill = 2;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridy = 0;
        layoutConstraints.insets = new Insets(0, 0, 6, 0);
        consoleOptionPanel.add((Component)this.defaultConsole, layoutConstraints);
        layoutConstraints.gridy = 1;
        consoleOptionPanel.add((Component)this.executeConsole, layoutConstraints);
        layoutConstraints.gridx = 1;
        consoleOptionPanel.add((Component)this.consoleCommand, layoutConstraints);
        layoutConstraints.gridx = 2;
        layoutConstraints.insets = new Insets(0, 4, 6, 0);
        consoleOptionPanel.add((Component)this.browseButton, layoutConstraints);
        layoutConstraints.gridx = 1;
        layoutConstraints.gridy = 2;
        consoleOptionPanel.add((Component)commandDescription, layoutConstraints);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Localization.lang("Sending of emails", new String[0]));
        builder.append(new JPanel());
        JLabel lab = new JLabel(Localization.lang("Subject for sending an email with references", new String[0]).concat(":"));
        builder.append(lab);
        this.emailSubject = new JTextField(25);
        builder.append(this.emailSubject);
        builder.nextLine();
        builder.append(new JPanel());
        this.openFoldersOfAttachedFiles = new JCheckBox(Localization.lang("Automatically open folders of attached files", new String[0]));
        builder.append(this.openFoldersOfAttachedFiles);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("External programs", new String[0]));
        builder.nextLine();
        JPanel butpan = new JPanel();
        butpan.setLayout(new GridLayout(3, 3));
        for (PushToApplication pushToApplication : frame.getPushApplications().getApplications()) {
            this.addSettingsButton(pushToApplication, butpan);
        }
        builder.append(new JPanel());
        builder.append((Component)butpan, 3);
        builder.nextLine();
        lab = new JLabel(Localization.lang("Cite command", new String[0]) + ':');
        JPanel pan = new JPanel();
        builder.append(pan);
        builder.append(lab);
        builder.append(this.citeCommand);
        builder.nextLine();
        builder.append(pan);
        builder.append(editFileTypes);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Open console", new String[0]));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(consoleOptionPanel);
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    private void addSettingsButton(PushToApplication pt, JPanel p) {
        JButton button = new JButton(Localization.lang("Settings for %0", pt.getApplicationName()), pt.getIcon());
        button.addActionListener(e -> PushToApplicationButton.showSettingsDialog(this.frame, pt, pt.getSettingsPanel()));
        p.add(button);
    }

    @Override
    public void setValues() {
        this.emailSubject.setText(this.prefs.get("emailSubject"));
        this.openFoldersOfAttachedFiles.setSelected(this.prefs.getBoolean("openFoldersOfAttachedFiles"));
        this.citeCommand.setText(this.prefs.get("citeCommand"));
        this.defaultConsole.setSelected(Globals.prefs.getBoolean("useDefaultConsoleApplication"));
        this.executeConsole.setSelected(!Globals.prefs.getBoolean("useDefaultConsoleApplication"));
        this.consoleCommand.setText(Globals.prefs.get("consoleCommand"));
        this.updateExecuteConsoleButtonAndFieldEnabledState();
    }

    @Override
    public void storeSettings() {
        this.prefs.put("emailSubject", this.emailSubject.getText());
        this.prefs.putBoolean("openFoldersOfAttachedFiles", this.openFoldersOfAttachedFiles.isSelected());
        this.prefs.put("citeCommand", this.citeCommand.getText());
        this.prefs.putBoolean("useDefaultConsoleApplication", this.defaultConsole.isSelected());
        this.prefs.put("consoleCommand", this.consoleCommand.getText());
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("External programs", new String[0]);
    }

    private void updateExecuteConsoleButtonAndFieldEnabledState() {
        this.browseButton.setEnabled(this.executeConsole.isSelected());
        this.consoleCommand.setEnabled(this.executeConsole.isSelected());
    }

    private void showConsoleChooser() {
        JFileChooser consoleChooser = new JFileChooser();
        int answer = consoleChooser.showOpenDialog(this);
        if (answer == 0) {
            this.consoleCommand.setText(consoleChooser.getSelectedFile().getAbsolutePath());
        }
    }
}

