/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.jabref.gui.keyboard.EmacsKeyBindings;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.logic.autocompleter.AutoCompleteFirstNameMode;
import net.sf.jabref.logic.autocompleter.AutoCompletePreferences;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.preferences.JabRefPreferences;

class EntryEditorPrefsTab
extends JPanel
implements PrefsTab {
    private final JCheckBox autoOpenForm;
    private final JCheckBox defSource;
    private final JCheckBox emacsMode;
    private final JCheckBox emacsRebindCtrlA;
    private final JCheckBox emacsRebindCtrlF;
    private final JCheckBox autoComplete;
    private final JRadioButton autoCompBoth;
    private final JRadioButton autoCompFF;
    private final JRadioButton autoCompLF;
    private final JRadioButton firstNameModeFull;
    private final JRadioButton firstNameModeAbbr;
    private final JRadioButton firstNameModeBoth;
    private final JSpinner shortestToComplete;
    private final JTextField autoCompFields;
    private final JabRefPreferences prefs;
    private final AutoCompletePreferences autoCompletePreferences;

    public EntryEditorPrefsTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.autoCompletePreferences = new AutoCompletePreferences(prefs);
        this.setLayout(new BorderLayout());
        this.autoOpenForm = new JCheckBox(Localization.lang("Open editor when a new entry is created", new String[0]));
        this.defSource = new JCheckBox(Localization.lang("Show BibTeX source by default", new String[0]));
        this.emacsMode = new JCheckBox(Localization.lang("Use Emacs key bindings", new String[0]));
        this.emacsRebindCtrlA = new JCheckBox(Localization.lang("Rebind C-a, too", new String[0]));
        this.emacsRebindCtrlF = new JCheckBox(Localization.lang("Rebind C-f, too", new String[0]));
        this.autoComplete = new JCheckBox(Localization.lang("Enable word/name autocompletion", new String[0]));
        this.shortestToComplete = new JSpinner(new SpinnerNumberModel(this.autoCompletePreferences.getShortestLengthToComplete(), 1, 5, 1));
        this.autoCompFF = new JRadioButton(Localization.lang("Autocomplete names in 'Firstname Lastname' format only", new String[0]));
        this.autoCompLF = new JRadioButton(Localization.lang("Autocomplete names in 'Lastname, Firstname' format only", new String[0]));
        this.autoCompBoth = new JRadioButton(Localization.lang("Autocomplete names in both formats", new String[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.autoCompLF);
        buttonGroup.add(this.autoCompFF);
        buttonGroup.add(this.autoCompBoth);
        this.firstNameModeFull = new JRadioButton(Localization.lang("Use full firstname whenever possible", new String[0]));
        this.firstNameModeAbbr = new JRadioButton(Localization.lang("Use abbreviated firstname whenever possible", new String[0]));
        this.firstNameModeBoth = new JRadioButton(Localization.lang("Use abbreviated and full firstname", new String[0]));
        ButtonGroup firstNameModeButtonGroup = new ButtonGroup();
        firstNameModeButtonGroup.add(this.firstNameModeFull);
        firstNameModeButtonGroup.add(this.firstNameModeAbbr);
        firstNameModeButtonGroup.add(this.firstNameModeBoth);
        Insets marg = new Insets(0, 20, 3, 0);
        this.emacsRebindCtrlA.setMargin(marg);
        this.emacsMode.addChangeListener(event -> this.emacsRebindCtrlA.setEnabled(this.emacsMode.isSelected()));
        this.emacsRebindCtrlF.setMargin(marg);
        this.emacsMode.addChangeListener(event -> this.emacsRebindCtrlF.setEnabled(this.emacsMode.isSelected()));
        this.autoCompFields = new JTextField(40);
        this.autoComplete.addChangeListener(event -> this.setAutoCompleteElementsEnabled(this.autoComplete.isSelected()));
        FormLayout layout = new FormLayout("8dlu, left:pref, 8dlu, fill:150dlu, 4dlu, fill:pref", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, pref, pref, pref, 6dlu, pref, pref, pref, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localization.lang("Editor options", new String[0]), cc.xyw(1, 1, 5));
        builder.add((Component)this.autoOpenForm, cc.xy(2, 3));
        builder.add((Component)this.defSource, cc.xy(2, 5));
        builder.add((Component)this.emacsMode, cc.xy(2, 7));
        builder.add((Component)this.emacsRebindCtrlA, cc.xy(2, 9));
        builder.add((Component)this.emacsRebindCtrlF, cc.xy(2, 11));
        builder.addSeparator(Localization.lang("Autocompletion options", new String[0]), cc.xyw(1, 13, 5));
        builder.add((Component)this.autoComplete, cc.xy(2, 15));
        DefaultFormBuilder builder3 = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:150dlu", ""));
        JLabel label = new JLabel(Localization.lang("Use autocompletion for the following fields", new String[0]) + ":");
        builder3.append(label);
        builder3.append(this.autoCompFields);
        JLabel label2 = new JLabel(Localization.lang("Autocomplete after following number of characters", new String[0]) + ":");
        builder3.append(label2);
        builder3.append(this.shortestToComplete);
        builder.add((Component)builder3.getPanel(), cc.xyw(2, 17, 3));
        builder.addSeparator(Localization.lang("Name format used for autocompletion", new String[0]), cc.xyw(2, 19, 4));
        builder.add((Component)this.autoCompFF, cc.xy(2, 20));
        builder.add((Component)this.autoCompLF, cc.xy(2, 21));
        builder.add((Component)this.autoCompBoth, cc.xy(2, 22));
        builder.addSeparator(Localization.lang("Treatment of first names", new String[0]), cc.xyw(2, 24, 4));
        builder.add((Component)this.firstNameModeAbbr, cc.xy(2, 25));
        builder.add((Component)this.firstNameModeFull, cc.xy(2, 26));
        builder.add((Component)this.firstNameModeBoth, cc.xy(2, 27));
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    private void setAutoCompleteElementsEnabled(boolean enabled) {
        this.autoCompFields.setEnabled(enabled);
        this.autoCompLF.setEnabled(enabled);
        this.autoCompFF.setEnabled(enabled);
        this.autoCompBoth.setEnabled(enabled);
        this.firstNameModeAbbr.setEnabled(enabled);
        this.firstNameModeFull.setEnabled(enabled);
        this.firstNameModeBoth.setEnabled(enabled);
        this.shortestToComplete.setEnabled(enabled);
    }

    @Override
    public void setValues() {
        this.autoOpenForm.setSelected(this.prefs.getBoolean("autoOpenForm"));
        this.defSource.setSelected(this.prefs.getBoolean("defaultShowSource"));
        this.emacsMode.setSelected(this.prefs.getBoolean("editorEMACSkeyBindings"));
        this.emacsRebindCtrlA.setSelected(this.prefs.getBoolean("editorEMACSkeyBindingsRebindCA"));
        this.emacsRebindCtrlF.setSelected(this.prefs.getBoolean("editorEMACSkeyBindingsRebindCF"));
        this.autoComplete.setSelected(this.prefs.getBoolean("autoComplete"));
        this.autoCompFields.setText(this.autoCompletePreferences.getCompleteNamesAsString());
        this.shortestToComplete.setValue(this.autoCompletePreferences.getShortestLengthToComplete());
        if (this.autoCompletePreferences.getOnlyCompleteFirstLast()) {
            this.autoCompFF.setSelected(true);
        } else if (this.autoCompletePreferences.getOnlyCompleteLastFirst()) {
            this.autoCompLF.setSelected(true);
        } else {
            this.autoCompBoth.setSelected(true);
        }
        switch (this.autoCompletePreferences.getFirstnameMode()) {
            case ONLY_ABBREVIATED: {
                this.firstNameModeAbbr.setSelected(true);
                break;
            }
            case ONLY_FULL: {
                this.firstNameModeFull.setSelected(true);
                break;
            }
            default: {
                this.firstNameModeBoth.setSelected(true);
            }
        }
        this.emacsRebindCtrlA.setEnabled(this.emacsMode.isSelected());
        this.setAutoCompleteElementsEnabled(this.autoComplete.isSelected());
    }

    @Override
    public void storeSettings() {
        boolean emacsRebindCtrlFChanged;
        this.prefs.putBoolean("autoOpenForm", this.autoOpenForm.isSelected());
        this.prefs.putBoolean("defaultShowSource", this.defSource.isSelected());
        boolean emacsModeChanged = this.prefs.getBoolean("editorEMACSkeyBindings") != this.emacsMode.isSelected();
        boolean emacsRebindCtrlAChanged = this.prefs.getBoolean("editorEMACSkeyBindingsRebindCA") != this.emacsRebindCtrlA.isSelected();
        boolean bl = emacsRebindCtrlFChanged = this.prefs.getBoolean("editorEMACSkeyBindingsRebindCF") != this.emacsRebindCtrlF.isSelected();
        if (emacsModeChanged || emacsRebindCtrlAChanged || emacsRebindCtrlFChanged) {
            this.prefs.putBoolean("editorEMACSkeyBindings", this.emacsMode.isSelected());
            this.prefs.putBoolean("editorEMACSkeyBindingsRebindCA", this.emacsRebindCtrlA.isSelected());
            this.prefs.putBoolean("editorEMACSkeyBindingsRebindCF", this.emacsRebindCtrlF.isSelected());
            if (emacsModeChanged) {
                if (this.emacsMode.isSelected()) {
                    EmacsKeyBindings.load();
                } else {
                    EmacsKeyBindings.unload();
                }
            } else {
                assert (this.emacsMode.isSelected());
                EmacsKeyBindings.unload();
                EmacsKeyBindings.load();
            }
        }
        this.autoCompletePreferences.setShortestLengthToComplete((Integer)this.shortestToComplete.getValue());
        this.prefs.putBoolean("autoComplete", this.autoComplete.isSelected());
        this.autoCompletePreferences.setCompleteNames(this.autoCompFields.getText());
        if (this.autoCompBoth.isSelected()) {
            this.autoCompletePreferences.setOnlyCompleteFirstLast(false);
            this.autoCompletePreferences.setOnlyCompleteLastFirst(false);
        } else if (this.autoCompFF.isSelected()) {
            this.autoCompletePreferences.setOnlyCompleteFirstLast(true);
            this.autoCompletePreferences.setOnlyCompleteLastFirst(false);
        } else {
            this.autoCompletePreferences.setOnlyCompleteFirstLast(false);
            this.autoCompletePreferences.setOnlyCompleteLastFirst(true);
        }
        if (this.firstNameModeAbbr.isSelected()) {
            this.autoCompletePreferences.setFirstnameMode(AutoCompleteFirstNameMode.ONLY_ABBREVIATED);
        } else if (this.firstNameModeFull.isSelected()) {
            this.autoCompletePreferences.setFirstnameMode(AutoCompleteFirstNameMode.ONLY_FULL);
        } else {
            this.autoCompletePreferences.setFirstnameMode(AutoCompleteFirstNameMode.BOTH);
        }
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry editor", new String[0]);
    }
}

