/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import net.sf.jabref.Globals;
import net.sf.jabref.logic.l10n.Localization;

public class ColorSetupPanel
extends JPanel {
    private static final int ICON_WIDTH = 30;
    private static final int ICON_HEIGHT = 20;
    private final List<ColorButton> buttons = new ArrayList<ColorButton>();

    public ColorSetupPanel(JCheckBox colorCodes, JCheckBox resolvedColorCodes, JCheckBox showGrid) {
        FormLayout layout = new FormLayout("30dlu, 4dlu, fill:pref, 4dlu, fill:pref, 8dlu, 30dlu, 4dlu, fill:pref, 4dlu, fill:pref", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref");
        FormBuilder builder = FormBuilder.create().layout(layout);
        this.buttons.add(new ColorButton("tableText", Localization.lang("Table text color", new String[0])));
        this.buttons.add(new ColorButton("markedEntryBackground0", Localization.lang("Marking color %0", "1")));
        this.buttons.add(new ColorButton("tableBackground", Localization.lang("Table background color", new String[0])));
        this.buttons.add(new ColorButton("markedEntryBackground1", Localization.lang("Marking color %0", "2")));
        this.buttons.add(new ColorButton("tableReqFieldBackground", Localization.lang("Background color for required fields", new String[0]), colorCodes));
        this.buttons.add(new ColorButton("markedEntryBackground2", Localization.lang("Marking color %0", "3")));
        this.buttons.add(new ColorButton("tableOptFieldBackground", Localization.lang("Background color for optional fields", new String[0]), colorCodes));
        this.buttons.add(new ColorButton("markedEntryBackground3", Localization.lang("Marking color %0", "4")));
        this.buttons.add(new ColorButton("incompleteEntryBackground", Localization.lang("Color for marking incomplete entries", new String[0])));
        this.buttons.add(new ColorButton("markedEntryBackground4", Localization.lang("Marking color %0", "5")));
        this.buttons.add(new ColorButton("gridColor", Localization.lang("Table grid color", new String[0]), showGrid));
        this.buttons.add(new ColorButton("markedEntryBackground5", Localization.lang("Import marking color", new String[0])));
        this.buttons.add(new ColorButton("fieldEditorTextColor", Localization.lang("Entry editor font color", new String[0])));
        this.buttons.add(new ColorButton("validFieldBackgroundColor", Localization.lang("Entry editor background color", new String[0])));
        this.buttons.add(new ColorButton("activeFieldEditorBackgroundColor", Localization.lang("Entry editor active background color", new String[0])));
        this.buttons.add(new ColorButton("invalidFieldBackgroundColor", Localization.lang("Entry editor invalid field color", new String[0])));
        this.buttons.add(new ColorButton("tableResolvedFieldBackground", Localization.lang("Background color for resolved fields", new String[0]), resolvedColorCodes));
        int rowcnt = 0;
        int col = 0;
        for (ColorButton but : this.buttons) {
            int row = 2 * (rowcnt / 2) + 1;
            builder.add(but).xy(6 * col + 1, row);
            builder.add(but.getDefaultButton()).xy(6 * col + 3, row);
            builder.add(but.getName(), new Object[0]).xy(6 * col + 5, row);
            but.addActionListener(new ColorButtonListener(but));
            col = 1 - col;
            ++rowcnt;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
        this.setValues();
    }

    public void setValues() {
        for (ColorButton but : this.buttons) {
            but.setColor(Globals.prefs.getColor(but.getKey()));
        }
    }

    public void storeSettings() {
        for (ColorButton but : this.buttons) {
            Globals.prefs.putColor(but.getKey(), but.getColor());
        }
    }

    static class ColorButton
    extends JButton
    implements Icon {
        private Color color = Color.white;
        private final String key;
        private final String name;
        private Optional<JCheckBox> checkBox = Optional.empty();

        public ColorButton(String key, String name, JCheckBox checkBox) {
            this(key, name);
            this.checkBox = Optional.of(checkBox);
        }

        public ColorButton(String key, String name) {
            this.setIcon(this);
            this.key = key;
            this.name = name;
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }

        public JButton getDefaultButton() {
            JButton toDefault = new JButton(Localization.lang("Default", new String[0]));
            toDefault.addActionListener(e -> {
                this.setColor(Globals.prefs.getDefaultColor(this.key));
                this.repaint();
            });
            return toDefault;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Rectangle r = g.getClipBounds();
            g.setColor(this.color);
            g.fillRect(r.x, r.y, r.width, r.height);
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        public Optional<JCheckBox> getCheckBox() {
            return this.checkBox;
        }
    }

    static class ColorButtonListener
    implements ActionListener {
        private final ColorButton button;

        public ColorButtonListener(ColorButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color chosen = JColorChooser.showDialog(null, this.button.getName(), this.button.getColor());
            if (chosen != null) {
                this.button.setColor(chosen);
                this.button.getCheckBox().ifPresent(checkBox -> checkBox.setSelected(true));
            }
        }
    }
}

