/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.preftabs.ColorSetupPanel;
import net.sf.jabref.gui.preftabs.FontSelectorDialog;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AppearancePrefsTab
extends JPanel
implements PrefsTab {
    private static final Log LOGGER = LogFactory.getLog(AppearancePrefsTab.class);
    private final JabRefPreferences prefs;
    private final JCheckBox colorCodes;
    private final JCheckBox resolvedColorCodes;
    private final JCheckBox overrideFonts;
    private final JCheckBox showGrid;
    private final ColorSetupPanel colorPanel;
    private Font usedFont = GUIGlobals.currentFont;
    private int oldMenuFontSize;
    private boolean oldOverrideFontSize;
    private final JTextField fontSize;
    private final JTextField rowPadding;
    private final JComboBox<String> classNamesLAF;
    private String currentLAF = "";
    private boolean useDefaultLAF;
    private final JCheckBox customLAF;

    public AppearancePrefsTab(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.setLayout(new BorderLayout());
        this.fontSize = new JTextField(5);
        this.rowPadding = new JTextField(5);
        this.colorCodes = new JCheckBox(Localization.lang("Color codes for required and optional fields", new String[0]));
        this.resolvedColorCodes = new JCheckBox(Localization.lang("Color code for resolved fields", new String[0]));
        this.overrideFonts = new JCheckBox(Localization.lang("Override default font settings", new String[0]));
        this.showGrid = new JCheckBox(Localization.lang("Show gridlines", new String[0]));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        this.customLAF = new JCheckBox(Localization.lang("Use other look and feel", new String[0]));
        List<String> lookAndFeels = LookAndFeel.getAvailableLookAndFeels();
        this.classNamesLAF = new JComboBox<String>(lookAndFeels.toArray(new String[lookAndFeels.size()]));
        this.classNamesLAF.setEditable(true);
        JComboBox<String> clName = this.classNamesLAF;
        this.customLAF.addChangeListener(e -> clName.setEnabled(((JCheckBox)e.getSource()).isSelected()));
        this.colorPanel = new ColorSetupPanel(this.colorCodes, this.resolvedColorCodes, this.showGrid);
        if (!OS.OS_X) {
            JPanel pan = new JPanel();
            builder.appendSeparator(Localization.lang("Look and feel", new String[0]));
            JLabel lab = new JLabel(Localization.lang("Default look and feel", new String[0]) + ": " + UIManager.getSystemLookAndFeelClassName());
            builder.nextLine();
            builder.append(pan);
            builder.append(lab);
            builder.nextLine();
            builder.append(pan);
            builder.append(this.customLAF);
            builder.nextLine();
            builder.append(pan);
            JPanel pan2 = new JPanel();
            lab = new JLabel(Localization.lang("Class name", new String[0]) + ':');
            pan2.add(lab);
            pan2.add(this.classNamesLAF);
            builder.append(pan2);
            builder.nextLine();
            builder.append(pan);
            lab = new JLabel(Localization.lang("Note that you must specify the fully qualified class name for the look and feel,", new String[0]));
            builder.append(lab);
            builder.nextLine();
            builder.append(pan);
            lab = new JLabel(Localization.lang("and the class must be available in your classpath next time you start JabRef.", new String[0]));
            builder.append(lab);
            builder.nextLine();
        }
        builder.leadingColumnOffset(2);
        builder.appendSeparator(Localization.lang("General", new String[0]));
        JPanel p1 = new JPanel();
        JLabel lab = new JLabel(Localization.lang("Menu and label font size", new String[0]) + ":");
        p1.add(lab);
        p1.add(this.fontSize);
        builder.append(p1);
        builder.nextLine();
        builder.append(this.overrideFonts);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Table appearance", new String[0]));
        JPanel p2 = new JPanel();
        p2.add(new JLabel(Localization.lang("Table row height padding", new String[0]) + ":"));
        p2.add(this.rowPadding);
        builder.append(p2);
        builder.nextLine();
        builder.append(this.colorCodes);
        builder.nextLine();
        builder.append(this.resolvedColorCodes);
        builder.nextLine();
        builder.append(this.showGrid);
        builder.nextLine();
        JButton fontButton = new JButton(Localization.lang("Set table font", new String[0]));
        builder.append(fontButton);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Table and entry editor colors", new String[0]));
        builder.append(this.colorPanel);
        JPanel upper = new JPanel();
        JPanel sort = new JPanel();
        JPanel namesp = new JPanel();
        JPanel iconCol = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        upper.setLayout(gbl);
        sort.setLayout(gbl);
        namesp.setLayout(gbl);
        iconCol.setLayout(gbl);
        this.overrideFonts.addActionListener(e -> this.fontSize.setEnabled(this.overrideFonts.isSelected()));
        fontButton.addActionListener(e -> new FontSelectorDialog(null, this.usedFont).getSelectedFont().ifPresent(x -> {
            this.usedFont = x;
        }));
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.useDefaultLAF = this.prefs.getBoolean("useDefaultLookAndFeel");
        this.currentLAF = this.prefs.get("lookAndFeel");
        this.customLAF.setSelected(!this.useDefaultLAF);
        this.classNamesLAF.setSelectedItem(this.currentLAF);
        this.classNamesLAF.setEnabled(!this.useDefaultLAF);
        this.colorCodes.setSelected(this.prefs.getBoolean("tableColorCodesOn"));
        this.resolvedColorCodes.setSelected(this.prefs.getBoolean("tableResolvedColorCodesOn"));
        this.fontSize.setText(String.valueOf(this.prefs.getInt("menuFontSize")));
        this.rowPadding.setText(String.valueOf(this.prefs.getInt("tableRowPadding")));
        this.oldMenuFontSize = this.prefs.getInt("menuFontSize");
        this.overrideFonts.setSelected(this.prefs.getBoolean("overrideDefaultFonts"));
        this.oldOverrideFontSize = this.overrideFonts.isSelected();
        this.fontSize.setEnabled(this.overrideFonts.isSelected());
        this.showGrid.setSelected(this.prefs.getBoolean("tableShowGrid"));
        this.colorPanel.setValues();
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("useDefaultLookAndFeel", !this.customLAF.isSelected());
        this.prefs.put("lookAndFeel", this.classNamesLAF.getSelectedItem().toString());
        if (this.customLAF.isSelected() == this.useDefaultLAF || !this.currentLAF.equals(this.classNamesLAF.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(null, Localization.lang("You have changed the look and feel setting.", new String[0]).concat(" ").concat(Localization.lang("You must restart JabRef for this to come into effect.", new String[0])), Localization.lang("Changed look and feel settings", new String[0]), 2);
        }
        this.prefs.putBoolean("tableColorCodesOn", this.colorCodes.isSelected());
        this.prefs.putBoolean("tableResolvedColorCodesOn", this.resolvedColorCodes.isSelected());
        this.prefs.put("fontFamily", this.usedFont.getFamily());
        this.prefs.putInt("fontStyle", this.usedFont.getStyle());
        this.prefs.putInt("fontSize", this.usedFont.getSize());
        this.prefs.putBoolean("overrideDefaultFonts", this.overrideFonts.isSelected());
        GUIGlobals.currentFont = this.usedFont;
        this.colorPanel.storeSettings();
        this.prefs.putBoolean("tableShowGrid", this.showGrid.isSelected());
        try {
            int size = Integer.parseInt(this.fontSize.getText());
            if (this.overrideFonts.isSelected() != this.oldOverrideFontSize || size != this.oldMenuFontSize) {
                this.prefs.putInt("menuFontSize", size);
                JOptionPane.showMessageDialog(null, Localization.lang("You have changed the menu and label font size.", new String[0]).concat(" ").concat(Localization.lang("You must restart JabRef for this to come into effect.", new String[0])), Localization.lang("Changed font settings", new String[0]), 2);
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.info("Invalid font size", ex);
        }
        try {
            int padding = Integer.parseInt(this.rowPadding.getText());
            this.prefs.putInt("tableRowPadding", padding);
        }
        catch (NumberFormatException ex) {
            LOGGER.info("Invalid row padding", ex);
        }
    }

    private boolean validateIntegerField(String fieldName, String fieldValue, String errorTitle) {
        try {
            Integer.parseInt(fieldValue);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, Localization.lang("You must enter an integer value in the text field for", new String[0]) + " '" + fieldName + "'", errorTitle, 0);
            return false;
        }
        return true;
    }

    @Override
    public boolean validateSettings() {
        if (!this.validateIntegerField(Localization.lang("Menu and label font size", new String[0]), this.fontSize.getText(), Localization.lang("Invalid setting", new String[0]))) {
            return false;
        }
        return this.validateIntegerField(Localization.lang("Table row height padding", new String[0]), this.rowPadding.getText(), Localization.lang("Invalid setting", new String[0]));
    }

    @Override
    public String getTabName() {
        return Localization.lang("Appearance", new String[0]);
    }

    static class LookAndFeel {
        private static final List<String> looks = Arrays.asList(UIManager.getSystemLookAndFeelClassName(), UIManager.getCrossPlatformLookAndFeelClassName(), "com.jgoodies.looks.plastic.Plastic3DLookAndFeel", "com.jgoodies.looks.windows.WindowsLookAndFeel");

        LookAndFeel() {
        }

        public static List<String> getAvailableLookAndFeels() {
            ArrayList<String> lookAndFeels = new ArrayList<String>();
            for (String l : looks) {
                try {
                    Class.forName(l);
                    lookAndFeels.add(l);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return lookAndFeels;
        }
    }
}

