/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.preftabs.PrefsTab;
import net.sf.jabref.gui.remote.JabRefMessageHandler;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.remote.RemotePreferences;
import net.sf.jabref.logic.remote.RemoteUtil;
import net.sf.jabref.preferences.JabRefPreferences;

class AdvancedTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences preferences;
    private final JCheckBox useRemoteServer;
    private final JCheckBox useIEEEAbrv;
    private final JTextField remoteServerPort;
    private final JCheckBox useCaseKeeperOnSearch;
    private final JCheckBox useUnitFormatterOnSearch;
    private final RemotePreferences remotePreferences;

    public AdvancedTab(JabRefPreferences prefs) {
        this.preferences = prefs;
        this.remotePreferences = prefs.getRemotePreferences();
        this.useRemoteServer = new JCheckBox(Localization.lang("Listen for remote operation on port", new String[0]) + ':');
        this.useIEEEAbrv = new JCheckBox(Localization.lang("Use IEEE LaTeX abbreviations", new String[0]));
        this.remoteServerPort = new JTextField();
        this.useCaseKeeperOnSearch = new JCheckBox(Localization.lang("Add {} to specified title words on search to keep the correct case", new String[0]));
        this.useUnitFormatterOnSearch = new JCheckBox(Localization.lang("Format units by adding non-breaking separators and keeping the correct case on search", new String[0]));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:3dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        builder.appendSeparator(Localization.lang("Remote operation", new String[0]));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(new JLabel("<html>" + Localization.lang("This feature lets new files be opened or imported into an already running instance of JabRef<BR>instead of opening a new instance. For instance, this is useful when you open a file in JabRef<br>from your web browser.<BR>Note that this will prevent you from running more than one instance of JabRef at a time.", new String[0]) + "</html>"));
        builder.nextLine();
        builder.append(new JPanel());
        JPanel p = new JPanel();
        p.add(this.useRemoteServer);
        p.add(this.remoteServerPort);
        p.add(new HelpAction(HelpFile.REMOTE).getHelpButton());
        builder.append(p);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Search %0", "IEEEXplore"));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(this.useIEEEAbrv);
        builder.nextLine();
        builder.appendSeparator(Localization.lang("Import conversions", new String[0]));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.useCaseKeeperOnSearch);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.useUnitFormatterOnSearch);
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.useRemoteServer.setSelected(this.remotePreferences.useRemoteServer());
        this.remoteServerPort.setText(String.valueOf(this.remotePreferences.getPort()));
        this.useIEEEAbrv.setSelected(Globals.prefs.getBoolean("useIEEEAbrv"));
        this.useCaseKeeperOnSearch.setSelected(Globals.prefs.getBoolean("useCaseKeeperOnSearch"));
        this.useUnitFormatterOnSearch.setSelected(Globals.prefs.getBoolean("useUnitFormatterOnSearch"));
    }

    @Override
    public void storeSettings() {
        if (this.preferences.getBoolean("useIEEEAbrv") != this.useIEEEAbrv.isSelected()) {
            this.preferences.putBoolean("useIEEEAbrv", this.useIEEEAbrv.isSelected());
            Globals.journalAbbreviationLoader.update(Globals.prefs.getJournalAbbreviationPreferences());
        }
        this.storeRemoteSettings();
        this.preferences.putBoolean("useCaseKeeperOnSearch", this.useCaseKeeperOnSearch.isSelected());
        this.preferences.putBoolean("useUnitFormatterOnSearch", this.useUnitFormatterOnSearch.isSelected());
    }

    private void storeRemoteSettings() {
        this.getPortAsInt().ifPresent(newPort -> {
            if (this.remotePreferences.isDifferentPort((int)newPort)) {
                this.remotePreferences.setPort((int)newPort);
                if (this.remotePreferences.useRemoteServer()) {
                    JOptionPane.showMessageDialog(null, Localization.lang("Remote server port", new String[0]).concat(" ").concat(Localization.lang("You must restart JabRef for this to come into effect.", new String[0])), Localization.lang("Remote server port", new String[0]), 2);
                }
            }
        });
        this.remotePreferences.setUseRemoteServer(this.useRemoteServer.isSelected());
        if (this.remotePreferences.useRemoteServer()) {
            Globals.REMOTE_LISTENER.openAndStart(new JabRefMessageHandler(), this.remotePreferences.getPort());
        } else {
            Globals.REMOTE_LISTENER.stop();
        }
        this.preferences.setRemotePreferences(this.remotePreferences);
    }

    private Optional<Integer> getPortAsInt() {
        try {
            return Optional.of(Integer.parseInt(this.remoteServerPort.getText()));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    @Override
    public boolean validateSettings() {
        try {
            int portNumber = Integer.parseInt(this.remoteServerPort.getText());
            if (RemoteUtil.isUserPort(portNumber)) {
                return true;
            }
            throw new NumberFormatException();
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, Localization.lang("You must enter an integer value in the interval 1025-65535 in the text field for", new String[0]) + " '" + Localization.lang("Remote server port", new String[0]) + '\'', Localization.lang("Remote server port", new String[0]), 0);
            return false;
        }
    }

    @Override
    public String getTabName() {
        return Localization.lang("Advanced", new String[0]);
    }
}

