/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.openoffice;

import com.sun.star.awt.FontSlant;
import com.sun.star.awt.Point;
import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyExistException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyContainer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XReferenceMarksSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.sf.jabref.gui.openoffice.BibEntryNotFoundException;
import net.sf.jabref.gui.openoffice.ConnectionLostException;
import net.sf.jabref.gui.openoffice.CreationException;
import net.sf.jabref.gui.openoffice.NoDocumentException;
import net.sf.jabref.gui.openoffice.UndefinedCharacterFormatException;
import net.sf.jabref.logic.bibtex.comparator.FieldComparator;
import net.sf.jabref.logic.bibtex.comparator.FieldComparatorStack;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.Layout;
import net.sf.jabref.logic.openoffice.OOBibStyle;
import net.sf.jabref.logic.openoffice.OOPreFormatter;
import net.sf.jabref.logic.openoffice.OOUtil;
import net.sf.jabref.logic.openoffice.UndefinedBibtexEntry;
import net.sf.jabref.logic.openoffice.UndefinedParagraphFormatException;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OOBibBase {
    private static final OOPreFormatter POSTFORMATTER = new OOPreFormatter();
    private static final String BIB_SECTION_NAME = "JR_bib";
    private static final String BIB_SECTION_END_NAME = "JR_bib_end";
    private static final String BIB_CITATION = "JR_cite";
    private static final Pattern CITE_PATTERN = Pattern.compile("JR_cite\\d*_(\\d*)_(.*)");
    private static final String CHAR_STYLE_NAME = "CharStyleName";
    private static final int AUTHORYEAR_PAR = 1;
    private static final int AUTHORYEAR_INTEXT = 2;
    private static final int INVISIBLE_CIT = 3;
    private XMultiServiceFactory mxDocFactory;
    private XTextDocument mxDoc;
    private XText text;
    private final XDesktop xDesktop;
    private XTextViewCursorSupplier xViewCursorSupplier;
    private XComponent xCurrentComponent;
    private XPropertySet propertySet;
    private XPropertyContainer userProperties;
    private final boolean atEnd;
    private final Comparator<BibEntry> entryComparator;
    private final Comparator<BibEntry> yearAuthorTitleComparator;
    private final FieldComparator authComp = new FieldComparator("author");
    private final FieldComparator yearComp = new FieldComparator("year");
    private final FieldComparator titleComp = new FieldComparator("title");
    private final List<Comparator<BibEntry>> authorYearTitleList = new ArrayList<Comparator<BibEntry>>(3);
    private final List<Comparator<BibEntry>> yearAuthorTitleList = new ArrayList<Comparator<BibEntry>>(3);
    private final Map<String, String> uniquefiers = new HashMap<String, String>();
    private List<String> sortedReferenceMarks;
    private static final Log LOGGER = LogFactory.getLog(OOBibBase.class);

    public OOBibBase(String pathToOO, boolean atEnd) throws IOException, IllegalAccessException, InvocationTargetException, BootstrapException, CreationException, UnknownPropertyException, WrappedTargetException, IndexOutOfBoundsException, NoSuchElementException, NoDocumentException {
        this.authorYearTitleList.add(this.authComp);
        this.authorYearTitleList.add(this.yearComp);
        this.authorYearTitleList.add(this.titleComp);
        this.yearAuthorTitleList.add(this.yearComp);
        this.yearAuthorTitleList.add(this.authComp);
        this.yearAuthorTitleList.add(this.titleComp);
        this.entryComparator = new FieldComparatorStack<BibEntry>(this.authorYearTitleList);
        this.yearAuthorTitleComparator = new FieldComparatorStack<BibEntry>(this.yearAuthorTitleList);
        this.atEnd = atEnd;
        this.xDesktop = this.simpleBootstrap(pathToOO);
        this.selectDocument();
    }

    public boolean isConnectedToDocument() {
        return this.xCurrentComponent != null;
    }

    public Optional<String> getCurrentDocumentTitle() {
        if (this.mxDoc == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(String.valueOf(OOUtil.getProperty(this.mxDoc.getCurrentController().getFrame(), "Title")));
        }
        catch (UnknownPropertyException | WrappedTargetException e) {
            LOGGER.warn("Could not get document title", e);
            return Optional.empty();
        }
    }

    public void selectDocument() throws UnknownPropertyException, WrappedTargetException, IndexOutOfBoundsException, NoSuchElementException, NoDocumentException {
        List<XTextDocument> textDocumentList = this.getTextDocuments();
        if (textDocumentList.isEmpty()) {
            throw new NoDocumentException("No Writer documents found");
        }
        XTextDocument selected = textDocumentList.size() == 1 ? textDocumentList.get(0) : OOBibBase.selectComponent(textDocumentList);
        if (selected == null) {
            return;
        }
        this.xCurrentComponent = UnoRuntime.queryInterface(XComponent.class, (Object)selected);
        this.mxDoc = selected;
        UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)this.xCurrentComponent);
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xCurrentComponent);
        XController xController = xModel.getCurrentController();
        this.xViewCursorSupplier = UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
        this.text = this.mxDoc.getText();
        this.mxDocFactory = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.mxDoc);
        XDocumentPropertiesSupplier supp = UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.mxDoc);
        this.userProperties = supp.getDocumentProperties().getUserDefinedProperties();
        this.propertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.userProperties);
    }

    private XDesktop simpleBootstrap(String pathToExecutable) throws IllegalAccessException, InvocationTargetException, BootstrapException, CreationException, IOException {
        Object desktop;
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)loader;
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            try {
                Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)cl, new File(pathToExecutable).toURI().toURL());
            }
            catch (NoSuchMethodException | SecurityException | MalformedURLException t) {
                LOGGER.error("Error, could not add URL to system classloader", t);
                cl.close();
                throw new IOException("Error, could not add URL to system classloader", t);
            }
        } else {
            LOGGER.error("Error occured, URLClassLoader expected but " + loader.getClass() + " received. Could not continue.");
        }
        XComponentContext xContext = Bootstrap.bootstrap();
        XMultiComponentFactory xServiceManager = xContext.getServiceManager();
        try {
            desktop = xServiceManager.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
        }
        catch (Exception e) {
            throw new CreationException(e.getMessage());
        }
        XDesktop resultDesktop = UnoRuntime.queryInterface(XDesktop.class, desktop);
        UnoRuntime.queryInterface(XComponentLoader.class, desktop);
        return resultDesktop;
    }

    private List<XTextDocument> getTextDocuments() throws NoSuchElementException, WrappedTargetException {
        ArrayList<XTextDocument> result = new ArrayList<XTextDocument>();
        XEnumerationAccess enumAccess = this.xDesktop.getComponents();
        XEnumeration componentEnumeration = enumAccess.createEnumeration();
        while (componentEnumeration.hasMoreElements()) {
            Object nextElement = componentEnumeration.nextElement();
            XComponent component = UnoRuntime.queryInterface(XComponent.class, nextElement);
            XTextDocument document = UnoRuntime.queryInterface(XTextDocument.class, (Object)component);
            if (document == null) continue;
            result.add(document);
        }
        return result;
    }

    public void setCustomProperty(String property, String value) throws UnknownPropertyException, NotRemoveableException, PropertyExistException, IllegalTypeException, IllegalArgumentException {
        if (this.propertySet.getPropertySetInfo().hasPropertyByName(property)) {
            this.userProperties.removeProperty(property);
        }
        if (value != null) {
            this.userProperties.addProperty(property, (short)128, new Any(Type.STRING, (Object)value));
        }
    }

    public Optional<String> getCustomProperty(String property) throws UnknownPropertyException, WrappedTargetException {
        if (this.propertySet.getPropertySetInfo().hasPropertyByName(property)) {
            return Optional.ofNullable(this.propertySet.getPropertyValue(property).toString());
        }
        return Optional.empty();
    }

    public void updateSortedReferenceMarks() throws WrappedTargetException, NoSuchElementException {
        this.sortedReferenceMarks = this.getSortedReferenceMarks(this.getReferenceMarks());
    }

    public void insertEntry(List<BibEntry> entries, BibDatabase database, List<BibDatabase> allBases, OOBibStyle style, boolean inParenthesis, boolean withText, String pageInfo, boolean sync) throws IllegalArgumentException, UnknownPropertyException, NotRemoveableException, PropertyExistException, IllegalTypeException, UndefinedCharacterFormatException, WrappedTargetException, NoSuchElementException, PropertyVetoException, IOException, CreationException, BibEntryNotFoundException, UndefinedParagraphFormatException {
        try {
            XTextViewCursor xViewCursor = this.xViewCursorSupplier.getViewCursor();
            if (entries.size() > 1) {
                if (style.getBooleanCitProperty("MultiCiteChronological")) {
                    entries.sort(this.yearAuthorTitleComparator);
                } else {
                    entries.sort(this.entryComparator);
                }
            }
            String keyString = String.join((CharSequence)",", entries.stream().map(entry -> entry.getCiteKeyOptional().orElse("")).collect(Collectors.toList()));
            String bName = this.getUniqueReferenceMarkName(keyString, withText ? (inParenthesis ? 1 : 2) : 3);
            if (pageInfo != null) {
                LOGGER.info("Storing page info: " + pageInfo);
                this.setCustomProperty(bName, pageInfo);
            }
            xViewCursor.getText().insertString(xViewCursor, " ", false);
            if (style.isFormatCitations()) {
                XPropertySet xCursorProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)xViewCursor);
                String charStyle = style.getCitationCharacterFormat();
                try {
                    xCursorProps.setPropertyValue(CHAR_STYLE_NAME, charStyle);
                }
                catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException ex) {
                    xViewCursor.goLeft((short)1, true);
                    xViewCursor.setString("");
                    throw new UndefinedCharacterFormatException(charStyle);
                }
            }
            xViewCursor.goLeft((short)1, false);
            HashMap<BibEntry, BibDatabase> databaseMap = new HashMap<BibEntry, BibDatabase>();
            for (BibEntry entry2 : entries) {
                databaseMap.put(entry2, database);
            }
            String citeText = style.isNumberEntries() ? "-" : style.getCitationMarker(entries, databaseMap, inParenthesis, null, null);
            this.insertReferenceMark(bName, citeText, xViewCursor, withText, style);
            xViewCursor.collapseToEnd();
            xViewCursor.goRight((short)1, false);
            XTextRange position = xViewCursor.getEnd();
            if (sync) {
                this.updateSortedReferenceMarks();
                this.refreshCiteMarkers(allBases, style);
                this.rebuildBibTextSection(allBases, style);
            }
            xViewCursor.gotoRange(position, false);
        }
        catch (DisposedException ex) {
            throw new ConnectionLostException(ex.getMessage());
        }
    }

    public List<String> refreshCiteMarkers(List<BibDatabase> databases, OOBibStyle style) throws WrappedTargetException, IllegalArgumentException, NoSuchElementException, UndefinedCharacterFormatException, UnknownPropertyException, PropertyVetoException, IOException, CreationException, BibEntryNotFoundException {
        try {
            return this.refreshCiteMarkersInternal(databases, style);
        }
        catch (DisposedException ex) {
            throw new ConnectionLostException(ex.getMessage());
        }
    }

    public List<String> getJabRefReferenceMarks(XNameAccess nameAccess) {
        String[] names = nameAccess.getElementNames();
        ArrayList<String> result = new ArrayList<String>();
        if (names != null) {
            for (String name : names) {
                if (!CITE_PATTERN.matcher(name).find()) continue;
                result.add(name);
            }
        }
        return result;
    }

    private List<String> refreshCiteMarkersInternal(List<BibDatabase> databases, OOBibStyle style) throws WrappedTargetException, IllegalArgumentException, NoSuchElementException, UndefinedCharacterFormatException, UnknownPropertyException, PropertyVetoException, CreationException, BibEntryNotFoundException {
        List<String> names;
        List<String> cited = this.findCitedKeys();
        HashMap<String, BibDatabase> linkSourceBase = new HashMap<String, BibDatabase>();
        Map<BibEntry, BibDatabase> entries = this.findCitedEntries(databases, cited, linkSourceBase);
        XNameAccess xReferenceMarks = this.getReferenceMarks();
        if (style.isSortByPosition()) {
            names = this.sortedReferenceMarks;
        } else if (style.isNumberEntries()) {
            TreeMap<BibEntry, BibDatabase> newMap = new TreeMap<BibEntry, BibDatabase>(this.entryComparator);
            for (Map.Entry entry : entries.entrySet()) {
                newMap.put((BibEntry)entry.getKey(), (BibDatabase)entry.getValue());
            }
            entries = newMap;
            cited.clear();
            for (BibEntry bibEntry : entries.keySet()) {
                cited.add(bibEntry.getCiteKeyOptional().orElse(null));
            }
            names = Arrays.asList(xReferenceMarks.getElementNames());
        } else {
            names = this.sortedReferenceMarks;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        for (String string : names) {
            if (!CITE_PATTERN.matcher(string).find()) continue;
            tmp.add(string);
        }
        names = tmp;
        HashMap<String, Integer> numbers = new HashMap<String, Integer>();
        boolean bl = false;
        String[] citMarkers = new String[names.size()];
        String[][] normCitMarkers = new String[names.size()][];
        String[][] bibtexKeys = new String[names.size()][];
        int minGroupingCount = style.getIntCitProperty("MinimumGroupingCount");
        int[] types = new int[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String citationMarker;
            int j;
            int type;
            Matcher citeMatcher = CITE_PATTERN.matcher(names.get(i));
            if (!citeMatcher.find()) continue;
            String typeStr = citeMatcher.group(1);
            types[i] = type = Integer.parseInt(typeStr);
            String[] keys = citeMatcher.group(2).split(",");
            bibtexKeys[i] = keys;
            BibEntry[] cEntries = new BibEntry[keys.length];
            for (int j2 = 0; j2 < cEntries.length; ++j2) {
                BibDatabase database = (BibDatabase)linkSourceBase.get(keys[j2]);
                Optional<Object> tmpEntry = Optional.empty();
                if (database != null) {
                    tmpEntry = database.getEntryByKey(keys[j2]);
                }
                if (tmpEntry.isPresent()) {
                    cEntries[j2] = (BibEntry)tmpEntry.get();
                    continue;
                }
                LOGGER.info("BibTeX key not found: '" + keys[j2] + '\'');
                LOGGER.info("Problem with reference mark: '" + names.get(i) + '\'');
                cEntries[j2] = new UndefinedBibtexEntry(keys[j2]);
            }
            String[] normCitMarker = new String[keys.length];
            if (style.isBibtexKeyCiteMarkers()) {
                StringBuilder sb = new StringBuilder();
                normCitMarkers[i] = new String[keys.length];
                for (j = 0; j < keys.length; ++j) {
                    normCitMarkers[i][j] = cEntries[j].getCiteKeyOptional().orElse(null);
                    sb.append(cEntries[j].getCiteKeyOptional().orElse(""));
                    if (j >= keys.length - 1) continue;
                    sb.append(',');
                }
                citationMarker = sb.toString();
            } else if (style.isNumberEntries()) {
                List<Object> num;
                if (style.isSortByPosition()) {
                    num = new ArrayList(keys.length);
                    for (j = 0; j < keys.length; ++j) {
                        int n;
                        if (cEntries[j] instanceof UndefinedBibtexEntry) {
                            num.add(j, -1);
                            continue;
                        }
                        num.add(j, (int)(n + true));
                        if (numbers.containsKey(keys[j])) {
                            num.set(j, (Integer)numbers.get(keys[j]));
                            continue;
                        }
                        numbers.put(keys[j], (Integer)num.get(j));
                        n = (Integer)num.get(j);
                    }
                    citationMarker = style.getNumCitationMarker(num, minGroupingCount, false);
                    for (j = 0; j < keys.length; ++j) {
                        normCitMarker[j] = style.getNumCitationMarker(Collections.singletonList((Integer)num.get(j)), minGroupingCount, false);
                    }
                } else {
                    num = this.findCitedEntryIndex(names.get(i), cited);
                    if (num.isEmpty()) {
                        throw new BibEntryNotFoundException(names.get(i), Localization.lang("Could not resolve BibTeX entry for citation marker '%0'.", names.get(i)));
                    }
                    citationMarker = style.getNumCitationMarker(num, minGroupingCount, false);
                    for (j = 0; j < keys.length; ++j) {
                        ArrayList<Integer> list = new ArrayList<Integer>(1);
                        list.add((Integer)num.get(j));
                        normCitMarker[j] = style.getNumCitationMarker(list, minGroupingCount, false);
                    }
                }
            } else {
                if (cEntries.length > 1) {
                    if (style.getBooleanCitProperty("MultiCiteChronological")) {
                        Arrays.sort(cEntries, this.yearAuthorTitleComparator);
                    } else {
                        Arrays.sort(cEntries, this.entryComparator);
                    }
                    for (int j3 = 0; j3 < cEntries.length; ++j3) {
                        bibtexKeys[i][j3] = cEntries[j3].getCiteKeyOptional().orElse(null);
                    }
                }
                citationMarker = style.getCitationMarker(Arrays.asList(cEntries), entries, type == 1, null, null);
                for (int j4 = 0; j4 < cEntries.length; ++j4) {
                    normCitMarker[j4] = style.getCitationMarker(Collections.singletonList(cEntries[j4]), entries, true, null, new int[]{-1});
                }
            }
            citMarkers[i] = citationMarker;
            normCitMarkers[i] = normCitMarker;
        }
        this.uniquefiers.clear();
        if (!style.isBibtexKeyCiteMarkers() && !style.isNumberEntries()) {
            HashMap refKeys = new HashMap();
            HashMap refNums = new HashMap();
            for (int i = 0; i < citMarkers.length; ++i) {
                String[] markers = normCitMarkers[i];
                for (int j = 0; j < markers.length; ++j) {
                    String marker = markers[j];
                    String currentKey = bibtexKeys[i][j];
                    if (refKeys.containsKey(marker)) {
                        if (((List)refKeys.get(marker)).contains(currentKey)) continue;
                        ((List)refKeys.get(marker)).add(currentKey);
                        ((List)refNums.get(marker)).add(i);
                        continue;
                    }
                    ArrayList<Object> l = new ArrayList<Object>(1);
                    l.add(currentKey);
                    refKeys.put(marker, l);
                    ArrayList<Integer> l2 = new ArrayList<Integer>(1);
                    l2.add(i);
                    refNums.put(marker, l2);
                }
            }
            for (Map.Entry stringListEntry : refKeys.entrySet()) {
                List keys = (List)stringListEntry.getValue();
                if (keys.size() <= 1) continue;
                int uniq = 97;
                for (String key : keys) {
                    this.uniquefiers.put(key, String.valueOf((char)uniq));
                    ++uniq;
                }
            }
            int maxAuthorsFirst = style.getIntCitProperty("MaxAuthorsFirst");
            HashSet<String> seenBefore = new HashSet<String>();
            for (int j = 0; j < bibtexKeys.length; ++j) {
                boolean needsChange = false;
                int[] firstLimAuthors = new int[bibtexKeys[j].length];
                String[] uniquif = new String[bibtexKeys[j].length];
                BibEntry[] cEntries = new BibEntry[bibtexKeys[j].length];
                for (int k = 0; k < bibtexKeys[j].length; ++k) {
                    BibDatabase database;
                    String currentKey = bibtexKeys[j][k];
                    firstLimAuthors[k] = -1;
                    if (maxAuthorsFirst > 0) {
                        if (!seenBefore.contains(currentKey)) {
                            firstLimAuthors[k] = maxAuthorsFirst;
                        }
                        seenBefore.add(currentKey);
                    }
                    String uniq = this.uniquefiers.get(currentKey);
                    Optional<Object> tmpEntry = Optional.empty();
                    if (uniq == null) {
                        if (firstLimAuthors[k] > 0) {
                            needsChange = true;
                            database = (BibDatabase)linkSourceBase.get(currentKey);
                            if (database != null) {
                                tmpEntry = database.getEntryByKey(currentKey);
                            }
                        } else {
                            database = (BibDatabase)linkSourceBase.get(currentKey);
                            if (database != null) {
                                tmpEntry = database.getEntryByKey(currentKey);
                            }
                        }
                        uniquif[k] = "";
                    } else {
                        needsChange = true;
                        database = (BibDatabase)linkSourceBase.get(currentKey);
                        if (database != null) {
                            tmpEntry = database.getEntryByKey(currentKey);
                        }
                        uniquif[k] = uniq;
                    }
                    if (!tmpEntry.isPresent()) continue;
                    cEntries[k] = (BibEntry)tmpEntry.get();
                }
                if (!needsChange) continue;
                citMarkers[j] = style.getCitationMarker(Arrays.asList(cEntries), entries, types[j] == 1, uniquif, firstLimAuthors);
            }
        }
        boolean hadBibSection = this.getBookmarkRange(BIB_SECTION_NAME) != null;
        boolean mustTestCharFormat = style.isFormatCitations();
        for (int i = 0; i < names.size(); ++i) {
            Object referenceMark = xReferenceMarks.getByName(names.get(i));
            XTextContent bookmark = UnoRuntime.queryInterface(XTextContent.class, referenceMark);
            XTextCursor cursor = bookmark.getAnchor().getText().createTextCursorByRange(bookmark.getAnchor());
            if (mustTestCharFormat) {
                mustTestCharFormat = false;
                XPropertySet xCursorProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)cursor);
                String charStyle = style.getCitationCharacterFormat();
                try {
                    xCursorProps.setPropertyValue(CHAR_STYLE_NAME, charStyle);
                }
                catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException ex) {
                    throw new UndefinedCharacterFormatException(charStyle);
                }
            }
            this.text.removeTextContent(bookmark);
            this.insertReferenceMark(names.get(i), citMarkers[i], cursor, types[i] != 3, style);
            if (!hadBibSection || this.getBookmarkRange(BIB_SECTION_NAME) != null) continue;
            cursor.collapseToEnd();
            OOUtil.insertParagraphBreak(this.text, cursor);
            this.insertBookMark(BIB_SECTION_NAME, cursor);
        }
        ArrayList<String> unresolvedKeys = new ArrayList<String>();
        for (BibEntry entry : entries.keySet()) {
            String key;
            if (!(entry instanceof UndefinedBibtexEntry) || unresolvedKeys.contains(key = ((UndefinedBibtexEntry)entry).getKey())) continue;
            unresolvedKeys.add(key);
        }
        return unresolvedKeys;
    }

    private List<String> getSortedReferenceMarks(XNameAccess nameAccess) throws WrappedTargetException, NoSuchElementException {
        XTextViewCursorSupplier cursorSupplier = UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)this.mxDoc.getCurrentController());
        XTextViewCursor viewCursor = cursorSupplier.getViewCursor();
        XTextRange initialPos = viewCursor.getStart();
        List<String> names = Arrays.asList(nameAccess.getElementNames());
        ArrayList<Point> positions = new ArrayList<Point>(names.size());
        for (String name : names) {
            XTextContent textContent = UnoRuntime.queryInterface(XTextContent.class, nameAccess.getByName(name));
            XTextRange range = textContent.getAnchor();
            if (UnoRuntime.queryInterface(XFootnote.class, (Object)range.getText()) != null) {
                XFootnote footer = UnoRuntime.queryInterface(XFootnote.class, (Object)range.getText());
                range = footer.getAnchor();
            }
            positions.add(this.findPosition(viewCursor, range));
        }
        TreeSet<ComparableMark> set = new TreeSet<ComparableMark>();
        for (int i = 0; i < positions.size(); ++i) {
            set.add(new ComparableMark(names.get(i), (Point)positions.get(i)));
        }
        ArrayList<String> result = new ArrayList<String>(set.size());
        for (ComparableMark mark : set) {
            result.add(mark.getName());
        }
        viewCursor.gotoRange(initialPos, false);
        return result;
    }

    public void rebuildBibTextSection(List<BibDatabase> databases, OOBibStyle style) throws NoSuchElementException, WrappedTargetException, IllegalArgumentException, CreationException, PropertyVetoException, UnknownPropertyException, UndefinedParagraphFormatException {
        List<String> cited = this.findCitedKeys();
        HashMap<String, BibDatabase> linkSourceBase = new HashMap<String, BibDatabase>();
        Map<BibEntry, BibDatabase> entries = this.findCitedEntries(databases, cited, linkSourceBase);
        List<String> names = this.sortedReferenceMarks;
        if (style.isSortByPosition()) {
            entries = this.getSortedEntriesFromSortedRefMarks(names, linkSourceBase);
        } else {
            TreeMap<BibEntry, BibDatabase> newMap = new TreeMap<BibEntry, BibDatabase>(this.entryComparator);
            for (Map.Entry<BibEntry, BibDatabase> bibtexEntryBibtexDatabaseEntry : this.findCitedEntries(databases, cited, linkSourceBase).entrySet()) {
                newMap.put(bibtexEntryBibtexDatabaseEntry.getKey(), bibtexEntryBibtexDatabaseEntry.getValue());
            }
            entries = newMap;
        }
        this.clearBibTextSectionContent2();
        this.populateBibTextSection(entries, style);
    }

    public XNameAccess getReferenceMarks() {
        XReferenceMarksSupplier supplier = UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        return supplier.getReferenceMarks();
    }

    private String getUniqueReferenceMarkName(String bibtexKey, int type) {
        XNameAccess xNamedRefMarks = this.getReferenceMarks();
        int i = 0;
        String name = "JR_cite_" + type + '_' + bibtexKey;
        while (xNamedRefMarks.hasByName(name)) {
            name = BIB_CITATION + i + '_' + type + '_' + bibtexKey;
            ++i;
        }
        return name;
    }

    private Map<BibEntry, BibDatabase> findCitedEntries(List<BibDatabase> databases, List<String> keys, Map<String, BibDatabase> linkSourceBase) {
        LinkedHashMap<BibEntry, BibDatabase> entries = new LinkedHashMap<BibEntry, BibDatabase>();
        for (String key : keys) {
            boolean found = false;
            for (BibDatabase database : databases) {
                Optional<BibEntry> entry = database.getEntryByKey(key);
                if (!entry.isPresent()) continue;
                entries.put(entry.get(), database);
                linkSourceBase.put(key, database);
                found = true;
                break;
            }
            if (found) continue;
            entries.put(new UndefinedBibtexEntry(key), null);
        }
        return entries;
    }

    private List<String> findCitedKeys() throws NoSuchElementException, WrappedTargetException {
        XNameAccess xNamedMarks = this.getReferenceMarks();
        String[] names = xNamedMarks.getElementNames();
        ArrayList<String> keys = new ArrayList<String>();
        for (String name1 : names) {
            Object bookmark = xNamedMarks.getByName(name1);
            UnoRuntime.queryInterface(XTextContent.class, bookmark);
            List<String> newKeys = this.parseRefMarkName(name1);
            for (String key : newKeys) {
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    private Map<BibEntry, BibDatabase> getSortedEntriesFromSortedRefMarks(List<String> names, Map<String, BibDatabase> linkSourceBase) {
        LinkedHashMap<BibEntry, BibDatabase> newList = new LinkedHashMap<BibEntry, BibDatabase>();
        for (String name : names) {
            String[] keys;
            Matcher citeMatcher = CITE_PATTERN.matcher(name);
            if (!citeMatcher.find()) continue;
            for (String key : keys = citeMatcher.group(2).split(",")) {
                BibDatabase database = linkSourceBase.get(key);
                Optional<Object> origEntry = Optional.empty();
                if (database != null) {
                    origEntry = database.getEntryByKey(key);
                }
                if (origEntry.isPresent()) {
                    if (newList.containsKey(origEntry.get())) continue;
                    newList.put((BibEntry)origEntry.get(), database);
                    continue;
                }
                LOGGER.info("BibTeX key not found: '" + key + "'");
                LOGGER.info("Problem with reference mark: '" + name + "'");
                newList.put(new UndefinedBibtexEntry(key), null);
            }
        }
        return newList;
    }

    private Point findPosition(XTextViewCursor cursor, XTextRange range) {
        cursor.gotoRange(range, false);
        return cursor.getPosition();
    }

    public List<String> parseRefMarkName(String name) {
        ArrayList<String> keys = new ArrayList<String>();
        Matcher citeMatcher = CITE_PATTERN.matcher(name);
        if (citeMatcher.find()) {
            String[] keystring;
            for (String aKeystring : keystring = citeMatcher.group(2).split(",")) {
                if (keys.contains(aKeystring)) continue;
                keys.add(aKeystring);
            }
        }
        return keys;
    }

    private List<Integer> findCitedEntryIndex(String citRefName, List<String> keys) {
        Matcher citeMatcher = CITE_PATTERN.matcher(citRefName);
        if (citeMatcher.find()) {
            List<String> keyStrings = Arrays.asList(citeMatcher.group(2).split(","));
            ArrayList<Integer> result = new ArrayList<Integer>(keyStrings.size());
            for (String key : keyStrings) {
                int ind = keys.indexOf(key);
                result.add(ind == -1 ? -1 : 1 + ind);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public String getCitationContext(XNameAccess nameAccess, String refMarkName, int charBefore, int charAfter, boolean htmlMarkup) throws NoSuchElementException, WrappedTargetException {
        Object referenceMark = nameAccess.getByName(refMarkName);
        XTextContent bookmark = UnoRuntime.queryInterface(XTextContent.class, referenceMark);
        XTextCursor cursor = bookmark.getAnchor().getText().createTextCursorByRange(bookmark.getAnchor());
        String citPart = cursor.getString();
        int flex = 8;
        for (int i = 0; i < charBefore; ++i) {
            try {
                cursor.goLeft((short)1, true);
                if (i < charBefore - flex || !Character.isWhitespace(cursor.getString().charAt(0))) continue;
                break;
            }
            catch (IndexOutOfBoundsException ex) {
                LOGGER.warn("Problem going left", ex);
            }
        }
        int length = cursor.getString().length();
        int added = length - citPart.length();
        cursor.collapseToStart();
        for (int i = 0; i < charAfter + length; ++i) {
            try {
                String strNow;
                cursor.goRight((short)1, true);
                if (i < charAfter + length - flex || !Character.isWhitespace((strNow = cursor.getString()).charAt(strNow.length() - 1))) continue;
                break;
            }
            catch (IndexOutOfBoundsException ex) {
                LOGGER.warn("Problem going right", ex);
            }
        }
        String result = cursor.getString();
        if (htmlMarkup) {
            result = result.substring(0, added) + "<b>" + citPart + "</b>" + result.substring(length);
        }
        return result.trim();
    }

    private void insertFullReferenceAtCursor(XTextCursor cursor, Map<BibEntry, BibDatabase> entries, OOBibStyle style, String parFormat) throws UndefinedParagraphFormatException, IllegalArgumentException, UnknownPropertyException, PropertyVetoException, WrappedTargetException {
        Map<BibEntry, BibDatabase> correctEntries;
        if (style.isSortByPosition()) {
            correctEntries = entries;
        } else {
            TreeMap<BibEntry, BibDatabase> newMap = new TreeMap<BibEntry, BibDatabase>(this.entryComparator);
            newMap.putAll(entries);
            correctEntries = newMap;
        }
        int number = 1;
        for (Map.Entry<BibEntry, BibDatabase> entry : correctEntries.entrySet()) {
            if (entry.getKey() instanceof UndefinedBibtexEntry) continue;
            OOUtil.insertParagraphBreak(this.text, cursor);
            if (style.isNumberEntries()) {
                int minGroupingCount = style.getIntCitProperty("MinimumGroupingCount");
                OOUtil.insertTextAtCurrentLocation(this.text, cursor, style.getNumCitationMarker(Collections.singletonList(number++), minGroupingCount, true), EnumSet.noneOf(OOUtil.Formatting.class));
            }
            Layout layout = style.getReferenceFormat(entry.getKey().getType());
            layout.setPostFormatter(POSTFORMATTER);
            OOUtil.insertFullReferenceAtCurrentLocation(this.text, cursor, layout, parFormat, entry.getKey(), entry.getValue(), this.uniquefiers.get(entry.getKey().getCiteKeyOptional().orElse(null)));
        }
    }

    private void createBibTextSection2(boolean end) throws IllegalArgumentException, CreationException {
        XNamed xChildNamed;
        XTextCursor mxDocCursor = this.text.createTextCursor();
        if (end) {
            mxDocCursor.gotoEnd(false);
        }
        OOUtil.insertParagraphBreak(this.text, mxDocCursor);
        try {
            xChildNamed = UnoRuntime.queryInterface(XNamed.class, this.mxDocFactory.createInstance("com.sun.star.text.TextSection"));
        }
        catch (Exception e) {
            throw new CreationException(e.getMessage());
        }
        xChildNamed.setName(BIB_SECTION_NAME);
        XTextContent xChildSection = UnoRuntime.queryInterface(XTextContent.class, (Object)xChildNamed);
        this.text.insertTextContent(mxDocCursor, xChildSection, false);
    }

    private void clearBibTextSectionContent2() throws NoSuchElementException, WrappedTargetException, IllegalArgumentException, CreationException {
        XTextSectionsSupplier supplier = UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.mxDoc);
        if (supplier.getTextSections().hasByName(BIB_SECTION_NAME)) {
            XTextSection section = (XTextSection)((Any)supplier.getTextSections().getByName(BIB_SECTION_NAME)).getObject();
            XTextCursor cursor = this.text.createTextCursorByRange(section.getAnchor());
            cursor.gotoRange(section.getAnchor(), false);
            cursor.setString("");
        } else {
            this.createBibTextSection2(this.atEnd);
        }
    }

    private void populateBibTextSection(Map<BibEntry, BibDatabase> entries, OOBibStyle style) throws NoSuchElementException, WrappedTargetException, PropertyVetoException, UnknownPropertyException, UndefinedParagraphFormatException, IllegalArgumentException, CreationException {
        XTextSectionsSupplier supplier = UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.mxDoc);
        XTextSection section = (XTextSection)((Any)supplier.getTextSections().getByName(BIB_SECTION_NAME)).getObject();
        XTextCursor cursor = this.text.createTextCursorByRange(section.getAnchor());
        OOUtil.insertTextAtCurrentLocation(this.text, cursor, (String)style.getProperty("Title"), (String)style.getProperty("ReferenceHeaderParagraphFormat"));
        this.insertFullReferenceAtCursor(cursor, entries, style, (String)style.getProperty("ReferenceParagraphFormat"));
        this.insertBookMark(BIB_SECTION_END_NAME, cursor);
    }

    private XTextContent insertBookMark(String name, XTextCursor position) throws IllegalArgumentException, CreationException {
        Object bookmark;
        try {
            bookmark = this.mxDocFactory.createInstance("com.sun.star.text.Bookmark");
        }
        catch (Exception e) {
            throw new CreationException(e.getMessage());
        }
        XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, bookmark);
        xNamed.setName(name);
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, bookmark);
        this.text.insertTextContent(position, xTextContent, true);
        position.collapseToEnd();
        return xTextContent;
    }

    private void insertReferenceMark(String name, String citationText, XTextCursor position, boolean withText, OOBibStyle style) throws UnknownPropertyException, WrappedTargetException, PropertyVetoException, IllegalArgumentException, UndefinedCharacterFormatException, CreationException {
        String etAlString;
        int index;
        Object bookmark;
        Optional<String> pageInfo = this.getCustomProperty(name);
        String citText = pageInfo.isPresent() && !pageInfo.get().isEmpty() ? style.insertPageInfo(citationText, pageInfo.get()) : citationText;
        try {
            bookmark = this.mxDocFactory.createInstance("com.sun.star.text.ReferenceMark");
        }
        catch (Exception e) {
            throw new CreationException(e.getMessage());
        }
        XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, bookmark);
        xNamed.setName(name);
        if (withText) {
            position.setString(citText);
            XPropertySet xCursorProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)position);
            xCursorProps.setPropertyValue("CharLocale", new Locale("zxx", "", ""));
            if (style.isFormatCitations()) {
                String charStyle = style.getCitationCharacterFormat();
                try {
                    xCursorProps.setPropertyValue(CHAR_STYLE_NAME, charStyle);
                }
                catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException ex) {
                    throw new UndefinedCharacterFormatException(charStyle);
                }
            }
        } else {
            position.setString("");
        }
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, bookmark);
        position.getText().insertTextContent(position, xTextContent, true);
        boolean italicize = style.getBooleanCitProperty("ItalicEtAl");
        if (italicize && (index = citText.indexOf(etAlString = style.getStringCitProperty("EtAlString"))) >= 0) {
            this.italicizeOrBold(position, true, index, index + etAlString.length());
        }
        position.collapseToEnd();
    }

    private void italicizeOrBold(XTextCursor position, boolean italicize, int start, int end) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        XTextRange range = position.getStart();
        XTextCursor cursor = position.getText().createTextCursorByRange(range);
        cursor.goRight((short)start, false);
        cursor.goRight((short)(end - start), true);
        XPropertySet xcp = UnoRuntime.queryInterface(XPropertySet.class, (Object)cursor);
        if (italicize) {
            xcp.setPropertyValue("CharPosture", FontSlant.ITALIC);
        } else {
            xcp.setPropertyValue("CharWeight", Float.valueOf(150.0f));
        }
    }

    private void removeReferenceMark(String name) throws NoSuchElementException, WrappedTargetException {
        XNameAccess xReferenceMarks = this.getReferenceMarks();
        if (xReferenceMarks.hasByName(name)) {
            Object referenceMark = xReferenceMarks.getByName(name);
            XTextContent bookmark = UnoRuntime.queryInterface(XTextContent.class, referenceMark);
            this.text.removeTextContent(bookmark);
        }
    }

    private XTextRange getBookmarkRange(String name) throws NoSuchElementException, WrappedTargetException {
        XNameAccess xNamedBookmarks = this.getBookmarks();
        if (!xNamedBookmarks.hasByName(name)) {
            return null;
        }
        Object foundBookmark = xNamedBookmarks.getByName(name);
        XTextContent xFoundBookmark = UnoRuntime.queryInterface(XTextContent.class, foundBookmark);
        return xFoundBookmark.getAnchor();
    }

    private XNameAccess getBookmarks() {
        XBookmarksSupplier xBookmarksSupplier = UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNamedBookmarks = xBookmarksSupplier.getBookmarks();
        return xNamedBookmarks;
    }

    public void combineCiteMarkers(List<BibDatabase> databases, OOBibStyle style) throws IOException, WrappedTargetException, NoSuchElementException, IllegalArgumentException, UndefinedCharacterFormatException, UnknownPropertyException, PropertyVetoException, CreationException, BibEntryNotFoundException {
        XNameAccess nameAccess = this.getReferenceMarks();
        List<String> names = this.getSortedReferenceMarks(nameAccess);
        XTextRangeCompare compare = UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)this.text);
        int piv = 0;
        boolean madeModifications = false;
        while (piv < names.size() - 1) {
            XTextRange range1 = UnoRuntime.queryInterface(XTextContent.class, nameAccess.getByName(names.get(piv))).getAnchor().getEnd();
            XTextRange range2 = UnoRuntime.queryInterface(XTextContent.class, nameAccess.getByName(names.get(piv + 1))).getAnchor().getStart();
            if (range1.getText() != range2.getText()) {
                ++piv;
                continue;
            }
            XTextCursor mxDocCursor = range1.getText().createTextCursorByRange(range1);
            mxDocCursor.goRight((short)1, true);
            boolean couldExpand = true;
            while (couldExpand && compare.compareRegionEnds(mxDocCursor, range2) > 0) {
                couldExpand = mxDocCursor.goRight((short)1, true);
            }
            String cursorText = mxDocCursor.getString();
            if (cursorText.indexOf(10) == -1 && cursorText.trim().isEmpty()) {
                if (style.isFormatCitations()) {
                    XPropertySet xCursorProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)mxDocCursor);
                    String charStyle = style.getCitationCharacterFormat();
                    try {
                        xCursorProps.setPropertyValue(CHAR_STYLE_NAME, charStyle);
                    }
                    catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException ex) {
                        throw new UndefinedCharacterFormatException(charStyle);
                    }
                }
                List<String> keys = this.parseRefMarkName(names.get(piv));
                keys.addAll(this.parseRefMarkName(names.get(piv + 1)));
                this.removeReferenceMark(names.get(piv));
                this.removeReferenceMark(names.get(piv + 1));
                ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
                block4: for (String key : keys) {
                    for (BibDatabase database : databases) {
                        Optional<BibEntry> entry2 = database.getEntryByKey(key);
                        if (!entry2.isPresent()) continue;
                        entries.add(entry2.get());
                        continue block4;
                    }
                }
                Collections.sort(entries, new FieldComparator("year"));
                String keyString = String.join((CharSequence)",", entries.stream().map(entry -> entry.getCiteKeyOptional().orElse("")).collect(Collectors.toList()));
                String bName = this.getUniqueReferenceMarkName(keyString, 1);
                this.insertReferenceMark(bName, "tmp", mxDocCursor, true, style);
                names.set(piv + 1, bName);
                madeModifications = true;
            }
            ++piv;
        }
        if (madeModifications) {
            this.updateSortedReferenceMarks();
            this.refreshCiteMarkers(databases, style);
        }
    }

    public static XTextDocument selectComponent(List<XTextDocument> list) throws UnknownPropertyException, WrappedTargetException, IndexOutOfBoundsException {
        String[] values = new String[list.size()];
        int ii = 0;
        for (XTextDocument doc : list) {
            values[ii] = String.valueOf(OOUtil.getProperty(doc.getCurrentController().getFrame(), "Title"));
            ++ii;
        }
        JList<String> sel = new JList<String>(values);
        sel.setSelectionMode(0);
        sel.setSelectedIndex(0);
        int ans = JOptionPane.showConfirmDialog(null, new JScrollPane(sel), Localization.lang("Select document", new String[0]), 2);
        if (ans == 0) {
            return list.get(sel.getSelectedIndex());
        }
        return null;
    }

    public BibDatabase generateDatabase(List<BibDatabase> databases) throws NoSuchElementException, WrappedTargetException {
        BibDatabase resultDatabase = new BibDatabase();
        List<String> cited = this.findCitedKeys();
        block0: for (String key : cited) {
            for (BibDatabase loopDatabase : databases) {
                Optional<BibEntry> entry = loopDatabase.getEntryByKey(key);
                if (!entry.isPresent()) continue;
                BibEntry clonedEntry = (BibEntry)entry.get().clone();
                clonedEntry.setId(IdGenerator.next());
                resultDatabase.insertEntry(clonedEntry);
                clonedEntry.getField("crossref").ifPresent(crossref -> {
                    if (!resultDatabase.getEntryByKey((String)crossref).isPresent()) {
                        loopDatabase.getEntryByKey((String)crossref).ifPresent(resultDatabase::insertEntry);
                    }
                });
                continue block0;
            }
        }
        return resultDatabase;
    }

    private static class ComparableMark
    implements Comparable<ComparableMark> {
        private final String name;
        private final Point position;

        public ComparableMark(String name, Point position) {
            this.name = name;
            this.position = position;
        }

        @Override
        public int compareTo(ComparableMark other) {
            if (this.position.Y == other.position.Y) {
                return this.position.X - other.position.X;
            }
            return this.position.Y - other.position.Y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ComparableMark) {
                ComparableMark other = (ComparableMark)o;
                return this.position.X == other.position.X && this.position.Y == other.position.Y && Objects.equals(this.name, other.name);
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.position, this.name);
        }
    }
}

