/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.openoffice;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyExistException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.openoffice.OOBibBase;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.openoffice.CitationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CitationManager {
    private final OOBibBase ooBase;
    private final JDialog diag;
    private final EventList<CitationEntry> list;
    private final JTable table;
    private final DefaultEventTableModel<CitationEntry> tableModel;
    private static final Log LOGGER = LogFactory.getLog(CitationManager.class);

    public CitationManager(JabRefFrame frame, OOBibBase ooBase) throws NoSuchElementException, WrappedTargetException, UnknownPropertyException {
        this.diag = new JDialog(frame, Localization.lang("Manage citations", new String[0]), true);
        this.ooBase = ooBase;
        this.list = new BasicEventList<CitationEntry>();
        XNameAccess nameAccess = ooBase.getReferenceMarks();
        List<String> names = ooBase.getJabRefReferenceMarks(nameAccess);
        for (String name : names) {
            this.list.add(new CitationEntry(name, "<html>..." + ooBase.getCitationContext(nameAccess, name, 30, 30, true) + "...</html>", ooBase.getCustomProperty(name)));
        }
        this.tableModel = new DefaultEventTableModel<CitationEntry>(this.list, new CitationEntryFormat());
        this.table = new JTable(this.tableModel);
        GUIUtil.correctRowHeight(this.table);
        this.diag.add((Component)new JScrollPane(this.table), "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        bb.addButton((JComponent)ok);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.add((Component)bb.getPanel(), "South");
        this.diag.pack();
        this.diag.setSize(700, 400);
        ok.addActionListener(e -> {
            try {
                this.storeSettings();
            }
            catch (IllegalTypeException | NotRemoveableException | PropertyExistException | UnknownPropertyException | IllegalArgumentException ex) {
                LOGGER.warn("Problem modifying citation", ex);
                JOptionPane.showMessageDialog(frame, Localization.lang("Problem modifying citation", new String[0]));
            }
            this.diag.dispose();
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CitationManager.this.diag.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        bb.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        bb.getPanel().getActionMap().put("close", cancelAction);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(580);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(110);
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 500));
        this.table.addMouseListener(new TableClickListener());
    }

    private void storeSettings() throws UnknownPropertyException, NotRemoveableException, PropertyExistException, IllegalTypeException, IllegalArgumentException {
        for (CitationEntry entry : this.list) {
            Optional<String> pageInfo = entry.getPageInfo();
            if (!entry.pageInfoChanged() || !pageInfo.isPresent()) continue;
            this.ooBase.setCustomProperty(entry.getRefMarkName(), pageInfo.get());
        }
    }

    public void showDialog() {
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }

    class SingleCitationDialog {
        private final JDialog singleCiteDialog;
        private final JTextField pageInfo = new JTextField(20);
        private final JButton okButton = new JButton(Localization.lang("OK", new String[0]));
        private final JButton cancelButton = new JButton(Localization.lang("Cancel", new String[0]));
        private final CitationEntry entry;

        public SingleCitationDialog(CitationEntry citEntry) {
            this.entry = citEntry;
            this.pageInfo.setText(this.entry.getPageInfo().orElse(""));
            this.singleCiteDialog = new JDialog(CitationManager.this.diag, Localization.lang("Citation", new String[0]), true);
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:150dlu:grow", "pref, 4dlu, pref"));
            builder.add(this.entry.getContext(), new Object[0]).xyw(1, 1, 3);
            builder.add(Localization.lang("Extra information (e.g. page number)", new String[0]), new Object[0]).xy(1, 3);
            builder.add(this.pageInfo).xy(3, 3);
            builder.padding("10dlu, 10dlu, 10dlu, 10dlu", new Object[0]);
            this.singleCiteDialog.getContentPane().add((Component)builder.getPanel(), "Center");
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addButton((JComponent)this.okButton);
            bb.addButton((JComponent)this.cancelButton);
            bb.addGlue();
            bb.padding("5dlu, 5dlu, 5dlu, 5dlu", new Object[0]);
            this.singleCiteDialog.add((Component)bb.getPanel(), "South");
            this.okButton.addActionListener(e -> {
                if (this.pageInfo.getText().trim().isEmpty()) {
                    this.entry.setPageInfo(null);
                } else {
                    this.entry.setPageInfo(this.pageInfo.getText().trim());
                }
                CitationManager.this.tableModel.fireTableDataChanged();
                this.singleCiteDialog.dispose();
            });
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SingleCitationDialog.this.singleCiteDialog.dispose();
                }
            };
            this.cancelButton.addActionListener(cancelAction);
            builder.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
            builder.getPanel().getActionMap().put("close", cancelAction);
        }

        public void showDialog() {
            this.singleCiteDialog.pack();
            this.singleCiteDialog.setLocationRelativeTo(this.singleCiteDialog.getParent());
            this.singleCiteDialog.setVisible(true);
        }
    }

    private class TableClickListener
    extends MouseAdapter {
        private TableClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (row = CitationManager.this.table.rowAtPoint(e.getPoint())) >= 0) {
                SingleCitationDialog scd = new SingleCitationDialog((CitationEntry)CitationManager.this.list.get(row));
                scd.showDialog();
            }
        }
    }

    private static class CitationEntryFormat
    implements TableFormat<CitationEntry> {
        private CitationEntryFormat() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int i) {
            if (i == 0) {
                return Localization.lang("Citation", new String[0]);
            }
            return Localization.lang("Extra information", new String[0]);
        }

        @Override
        public Object getColumnValue(CitationEntry citEntry, int i) {
            if (i == 0) {
                return citEntry.getContext();
            }
            return citEntry.getPageInfo().orElse("");
        }
    }
}

