/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.openoffice;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.openoffice.OpenOfficeFileSearch;
import net.sf.jabref.logic.openoffice.OpenOfficePreferences;
import net.sf.jabref.logic.util.OS;

public class AutoDetectPaths
extends AbstractWorker {
    private final OpenOfficePreferences preferences;
    private boolean foundPaths;
    private boolean fileSearchCanceled;
    private JDialog prog;
    private final JDialog parent;
    private final OpenOfficeFileSearch fileSearch = new OpenOfficeFileSearch();

    public AutoDetectPaths(JDialog parent, OpenOfficePreferences preferences) {
        this.parent = parent;
        this.preferences = preferences;
    }

    public boolean runAutodetection() {
        this.foundPaths = false;
        if (this.preferences.checkAutoDetectedPaths()) {
            return true;
        }
        this.init();
        this.getWorker().run();
        this.update();
        return this.foundPaths;
    }

    @Override
    public void run() {
        this.foundPaths = this.autoDetectPaths();
    }

    public boolean canceled() {
        return this.fileSearchCanceled;
    }

    @Override
    public void init() {
        this.prog = this.showProgressDialog(this.parent, Localization.lang("Autodetecting paths...", new String[0]), Localization.lang("Please wait...", new String[0]), true);
    }

    @Override
    public void update() {
        this.prog.dispose();
    }

    private boolean autoDetectPaths() {
        this.fileSearch.resetFileSearch();
        if (OS.WINDOWS) {
            Optional<File> actualFile;
            List<File> progFiles = this.fileSearch.findWindowsProgramFilesDir();
            ArrayList<File> sofficeFiles = new ArrayList<File>(this.fileSearch.findFileInDirs(progFiles, "soffice.exe"));
            if (this.fileSearchCanceled) {
                return false;
            }
            if (sofficeFiles.isEmpty()) {
                JOptionPane.showMessageDialog(this.parent, Localization.lang("Unable to autodetect OpenOffice/LibreOffice installation. Please choose the installation directory manually.", new String[0]), Localization.lang("Could not find OpenOffice/LibreOffice installation", new String[0]), 1);
                JFileChooser fileChooser = new JFileChooser(new File(System.getenv("ProgramFiles")));
                fileChooser.setDialogType(0);
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Localization.lang("Directories", new String[0]);
                    }
                });
                fileChooser.setFileSelectionMode(1);
                fileChooser.showOpenDialog(this.parent);
                if (fileChooser.getSelectedFile() != null) {
                    sofficeFiles.add(fileChooser.getSelectedFile());
                }
            }
            if ((actualFile = this.checkAndSelectAmongMultipleInstalls(sofficeFiles)).isPresent()) {
                return this.setupPreferencesForOO(actualFile.get().getParentFile(), actualFile.get(), "soffice.exe");
            }
            return false;
        }
        if (OS.OS_X) {
            List<File> dirList = this.fileSearch.findOSXProgramFilesDir();
            ArrayList<File> sofficeFiles = new ArrayList<File>(this.fileSearch.findFileInDirs(dirList, "soffice.bin"));
            if (this.fileSearchCanceled) {
                return false;
            }
            Optional<File> actualFile = this.checkAndSelectAmongMultipleInstalls(sofficeFiles);
            if (actualFile.isPresent()) {
                for (File rootdir : dirList) {
                    if (!actualFile.get().getPath().startsWith(rootdir.getPath())) continue;
                    return this.setupPreferencesForOO(rootdir, actualFile.get(), "soffice.bin");
                }
            }
            return false;
        }
        String usrRoot = "/usr/lib";
        Optional<File> inUsr = this.fileSearch.findFileInDir(new File(usrRoot), "soffice");
        if (this.fileSearchCanceled) {
            return false;
        }
        if (!inUsr.isPresent() && (inUsr = this.fileSearch.findFileInDir(new File("/usr/lib64"), "soffice")).isPresent()) {
            usrRoot = "/usr/lib64";
        }
        if (this.fileSearchCanceled) {
            return false;
        }
        Optional<File> inOpt = this.fileSearch.findFileInDir(new File("/opt"), "soffice");
        if (this.fileSearchCanceled) {
            return false;
        }
        if (inUsr.isPresent() && !inOpt.isPresent()) {
            return this.setupPreferencesForOO(usrRoot, inUsr.get(), "soffice");
        }
        if (inOpt.isPresent()) {
            if (!inUsr.isPresent()) {
                return this.setupPreferencesForOO("/opt", inOpt.get(), "soffice");
            }
            JRadioButton optRB = new JRadioButton(inOpt.get().getPath(), true);
            JRadioButton usrRB = new JRadioButton(inUsr.get().getPath(), false);
            ButtonGroup bg = new ButtonGroup();
            bg.add(optRB);
            bg.add(usrRB);
            FormBuilder b = FormBuilder.create().layout(new FormLayout("left:pref", "pref, 2dlu, pref, 2dlu, pref "));
            b.add(Localization.lang("Found more than one OpenOffice/LibreOffice executable.", new String[0]) + " " + Localization.lang("Please choose which one to connect to:", new String[0]), new Object[0]).xy(1, 1);
            b.add(optRB).xy(1, 3);
            b.add(usrRB).xy(1, 5);
            int answer = JOptionPane.showConfirmDialog(null, b.getPanel(), Localization.lang("Choose OpenOffice/LibreOffice executable", new String[0]), 2);
            if (answer == 2) {
                return false;
            }
            if (optRB.isSelected()) {
                return this.setupPreferencesForOO("/opt", inOpt.get(), "soffice");
            }
            return this.setupPreferencesForOO(usrRoot, inUsr.get(), "soffice");
        }
        return false;
    }

    private boolean setupPreferencesForOO(String usrRoot, File inUsr, String sofficeName) {
        return this.setupPreferencesForOO(new File(usrRoot), inUsr, sofficeName);
    }

    private boolean setupPreferencesForOO(File rootDir, File inUsr, String sofficeName) {
        this.preferences.setExecutablePath(new File(inUsr, sofficeName).getPath());
        Optional<File> jurt = this.fileSearch.findFileInDir(rootDir, "jurt.jar");
        if (this.fileSearchCanceled) {
            return false;
        }
        if (jurt.isPresent()) {
            this.preferences.setJarsPath(jurt.get().getPath());
            return true;
        }
        return false;
    }

    private Optional<File> checkAndSelectAmongMultipleInstalls(List<File> sofficeFiles) {
        if (sofficeFiles.isEmpty()) {
            return Optional.empty();
        }
        if (sofficeFiles.size() == 1) {
            return Optional.of(sofficeFiles.get(0));
        }
        DefaultListModel<File> mod = new DefaultListModel<File>();
        for (File tmpfile : sofficeFiles) {
            mod.addElement(tmpfile);
        }
        JList fileList = new JList(mod);
        fileList.setSelectionMode(0);
        fileList.setSelectedIndex(0);
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref", "pref, 2dlu, pref, 4dlu, pref"));
        builder.add(Localization.lang("Found more than one OpenOffice/LibreOffice executable.", new String[0]), new Object[0]).xy(1, 1);
        builder.add(Localization.lang("Please choose which one to connect to:", new String[0]), new Object[0]).xy(1, 3);
        builder.add(fileList).xy(1, 5);
        int answer = JOptionPane.showConfirmDialog(null, builder.getPanel(), Localization.lang("Choose OpenOffice/LibreOffice executable", new String[0]), 2);
        if (answer == 2) {
            return Optional.empty();
        }
        return Optional.of((File)fileList.getSelectedValue());
    }

    public JDialog showProgressDialog(JDialog progressParent, String title, String message, boolean includeCancelButton) {
        this.fileSearchCanceled = false;
        JProgressBar bar = new JProgressBar(0);
        JDialog progressDialog = new JDialog(progressParent, title, false);
        bar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        bar.setIndeterminate(true);
        if (includeCancelButton) {
            JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
            cancel.addActionListener(event -> {
                this.fileSearchCanceled = true;
                this.fileSearch.cancelFileSearch();
                ((JButton)event.getSource()).setEnabled(false);
            });
            progressDialog.add((Component)cancel, "South");
        }
        progressDialog.add((Component)new JLabel(message), "North");
        progressDialog.add((Component)bar, "Center");
        progressDialog.pack();
        progressDialog.setLocationRelativeTo(null);
        progressDialog.setVisible(true);
        return progressDialog;
    }
}

