/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.mergeentries;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.mergeentries.MergeEntries;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableChangeType;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.gui.util.WindowLocation;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class MergeFetchedEntryDialog
extends JDialog {
    private final BasePanel panel;
    private final CellConstraints cc = new CellConstraints();
    private final BibEntry originalEntry;
    private final BibEntry fetchedEntry;
    private NamedCompound ce;
    private MergeEntries mergeEntries;
    private final String type;
    private static final String MARGIN = "5px";

    public MergeFetchedEntryDialog(BasePanel panel, BibEntry originalEntry, BibEntry fetchedEntry, String type) {
        super(panel.frame(), Localization.lang("Merge entry with %0 information", type), true);
        this.panel = panel;
        this.originalEntry = originalEntry;
        this.fetchedEntry = fetchedEntry;
        this.type = type;
        this.init();
    }

    private void init() {
        this.mergeEntries = new MergeEntries(this.originalEntry, this.fetchedEntry, Localization.lang("Original entry", new String[0]), Localization.lang("Entry from %0", this.type), this.panel.getBibDatabaseContext().getMode());
        this.ce = new NamedCompound(Localization.lang("Merge entry with %0 information", this.type));
        FormLayout layout = new FormLayout("fill:700px:grow", "fill:400px:grow, 4px, p, 5px, p");
        this.setLayout(layout);
        this.add((Component)this.mergeEntries.getMergeEntryPanel(), this.cc.xy(1, 1));
        this.add((Component)new JSeparator(), this.cc.xy(1, 3));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        JButton cancel = new JButton(new CancelAction());
        JButton replaceEntry = new JButton(new ReplaceAction());
        bb.addButton(replaceEntry, cancel);
        this.add((Component)bb.getPanel(), this.cc.xy(1, 5));
        layout.appendRow(RowSpec.decode(MARGIN));
        layout.appendColumn(ColumnSpec.decode(MARGIN));
        layout.insertRow(1, RowSpec.decode(MARGIN));
        layout.insertColumn(1, ColumnSpec.decode(MARGIN));
        WindowLocation pw = new WindowLocation(this, "mergeEntriesPosX", "mergeEntriesPosY", "mergeEntriesSizeX", "mergeEntriesSizeY");
        pw.displayWindowAtStoredLocation();
    }

    private class ReplaceAction
    extends AbstractAction {
        ReplaceAction() {
            this.putValue("Name", Localization.lang("Replace original entry", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional<String> originalString;
            String newType;
            BibEntry mergedEntry = MergeFetchedEntryDialog.this.mergeEntries.getMergeEntry();
            TreeSet<String> jointFields = new TreeSet<String>(mergedEntry.getFieldNames());
            TreeSet<String> originalFields = new TreeSet<String>(MergeFetchedEntryDialog.this.originalEntry.getFieldNames());
            boolean edited = false;
            String oldType = MergeFetchedEntryDialog.this.originalEntry.getType();
            if (!oldType.equalsIgnoreCase(newType = mergedEntry.getType())) {
                MergeFetchedEntryDialog.this.originalEntry.setType(newType);
                MergeFetchedEntryDialog.this.ce.addEdit(new UndoableChangeType(MergeFetchedEntryDialog.this.originalEntry, oldType, newType));
                edited = true;
            }
            for (String field : jointFields) {
                originalString = MergeFetchedEntryDialog.this.originalEntry.getField(field);
                Optional<String> mergedString = mergedEntry.getField(field);
                if (originalString.isPresent() && originalString.equals(mergedString)) continue;
                MergeFetchedEntryDialog.this.originalEntry.setField(field, mergedString.get());
                MergeFetchedEntryDialog.this.ce.addEdit(new UndoableFieldChange(MergeFetchedEntryDialog.this.originalEntry, field, originalString.orElse(null), mergedString.get()));
                edited = true;
            }
            for (String field : originalFields) {
                if (jointFields.contains(field) || InternalBibtexFields.isInternalField(field)) continue;
                originalString = MergeFetchedEntryDialog.this.originalEntry.getField(field);
                MergeFetchedEntryDialog.this.originalEntry.clearField(field);
                MergeFetchedEntryDialog.this.ce.addEdit(new UndoableFieldChange(MergeFetchedEntryDialog.this.originalEntry, field, originalString.get(), null));
                edited = true;
            }
            if (edited) {
                MergeFetchedEntryDialog.this.ce.end();
                MergeFetchedEntryDialog.this.panel.getUndoManager().addEdit(MergeFetchedEntryDialog.this.ce);
                MergeFetchedEntryDialog.this.panel.output(Localization.lang("Updated entry with info from %0", MergeFetchedEntryDialog.this.type));
                MergeFetchedEntryDialog.this.panel.updateEntryEditorIfShowing();
                MergeFetchedEntryDialog.this.panel.markBaseChanged();
            } else {
                MergeFetchedEntryDialog.this.panel.output(Localization.lang("No information added", new String[0]));
            }
            MergeFetchedEntryDialog.this.dispose();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", Localization.lang("Cancel", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MergeFetchedEntryDialog.this.panel.output(Localization.lang("Canceled merging entries", new String[0]));
            MergeFetchedEntryDialog.this.dispose();
        }
    }
}

