/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.mergeentries;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.mergeentries.MergeEntries;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableInsertEntry;
import net.sf.jabref.gui.undo.UndoableRemoveEntry;
import net.sf.jabref.gui.util.WindowLocation;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class MergeEntriesDialog
extends JDialog {
    private final BasePanel panel;
    private final CellConstraints cc = new CellConstraints();
    private static final String MERGE_ENTRIES = Localization.lang("Merge entries", new String[0]);
    private static final String MARGIN = "5px";

    public MergeEntriesDialog(BasePanel panel) {
        super(panel.frame(), MERGE_ENTRIES, true);
        this.panel = panel;
        this.init(panel.getSelectedEntries());
    }

    private void init(List<BibEntry> selected) {
        if (selected.size() != 2) {
            JOptionPane.showMessageDialog(this.panel.frame(), Localization.lang("You have to choose exactly two entries to merge.", new String[0]), MERGE_ENTRIES, 1);
            this.dispose();
            return;
        }
        BibEntry one = selected.get(0);
        BibEntry two = selected.get(1);
        MergeEntries mergeEntries = new MergeEntries(one, two, this.panel.getBibDatabaseContext().getMode());
        NamedCompound ce = new NamedCompound(MERGE_ENTRIES);
        FormLayout layout = new FormLayout("fill:700px:grow", "fill:400px:grow, 4px, p, 5px, p");
        this.setLayout(layout);
        this.add((Component)mergeEntries.getMergeEntryPanel(), this.cc.xy(1, 1));
        this.add((Component)new JSeparator(), this.cc.xy(1, 3));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.setActionCommand("cancel");
        cancel.addActionListener(e -> {
            this.panel.output(Localization.lang("Canceled merging entries", new String[0]));
            this.dispose();
        });
        JButton replaceentries = new JButton(MERGE_ENTRIES);
        replaceentries.setActionCommand("replace");
        replaceentries.addActionListener(e -> {
            BibEntry mergedEntry = mergeEntries.getMergeEntry();
            this.panel.insertEntry(mergedEntry);
            ce.addEdit(new UndoableInsertEntry(this.panel.getDatabase(), mergedEntry, this.panel));
            ce.addEdit(new UndoableRemoveEntry(this.panel.getDatabase(), one, this.panel));
            this.panel.getDatabase().removeEntry(one);
            ce.addEdit(new UndoableRemoveEntry(this.panel.getDatabase(), two, this.panel));
            this.panel.getDatabase().removeEntry(two);
            ce.end();
            this.panel.getUndoManager().addEdit(ce);
            this.panel.output(Localization.lang("Merged entries", new String[0]));
            this.dispose();
        });
        bb.addButton(replaceentries, cancel);
        this.add((Component)bb.getPanel(), this.cc.xy(1, 5));
        layout.appendRow(RowSpec.decode(MARGIN));
        layout.appendColumn(ColumnSpec.decode(MARGIN));
        layout.insertRow(1, RowSpec.decode(MARGIN));
        layout.insertColumn(1, ColumnSpec.decode(MARGIN));
        WindowLocation pw = new WindowLocation(this, "mergeEntriesPosX", "mergeEntriesPosY", "mergeEntriesSizeX", "mergeEntriesSizeY");
        pw.displayWindowAtStoredLocation();
        this.setVisible(true);
    }
}

