/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.mergeentries;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.mergeentries.FetchAndMergeWorker;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldName;

public class FetchAndMergeEntry {
    public static List<String> SUPPORTED_FIELDS = Arrays.asList("doi", "eprint", "isbn");

    public FetchAndMergeEntry(BibEntry entry, BasePanel panel, String field) {
        this(entry, panel, Arrays.asList(field));
    }

    public FetchAndMergeEntry(BibEntry entry, BasePanel panel, List<String> fields) {
        for (String field : fields) {
            if (entry.hasField(field)) {
                new FetchAndMergeWorker(panel, entry, field).execute();
                continue;
            }
            panel.frame().setStatus(Localization.lang("No %0 found", FieldName.getDisplayName(field)));
        }
    }

    public static String getDisplayNameOfSupportedFields() {
        return FieldName.orFields(SUPPORTED_FIELDS.stream().map(FieldName::getDisplayName).collect(Collectors.toList()));
    }
}

