/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileHistory;
import net.sf.jabref.preferences.JabRefPreferences;

public class FileHistoryMenu
extends JMenu
implements ActionListener {
    private final FileHistory history;
    private final JabRefFrame frame;
    private final JabRefPreferences prefs;

    public FileHistoryMenu(JabRefPreferences prefs, JabRefFrame frame) {
        String name = Localization.menuTitle("Recent databases", new String[0]);
        int i = name.indexOf(38);
        if (i >= 0) {
            this.setText(name.substring(0, i) + name.substring(i + 1));
            char mnemonic = Character.toUpperCase(name.charAt(i + 1));
            this.setMnemonic((int)mnemonic);
        } else {
            this.setText(name);
        }
        this.frame = frame;
        this.prefs = prefs;
        this.history = prefs.getFileHistory();
        if (this.history.isEmpty()) {
            this.setEnabled(false);
        } else {
            this.setItems();
        }
    }

    public void newFile(String filename) {
        this.history.newFile(filename);
        this.setItems();
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
    }

    private void setItems() {
        this.removeAll();
        for (int count = 0; count < this.history.size(); ++count) {
            this.addItem(this.history.getFileName(count), count + 1);
        }
    }

    private void addItem(String filename, int num) {
        String number = Integer.toString(num);
        JMenuItem item = new JMenuItem(number + ". " + filename);
        char mnemonic = Character.toUpperCase(number.charAt(0));
        item.setMnemonic((int)mnemonic);
        item.addActionListener(this);
        this.add(item);
    }

    public void storeHistory() {
        this.prefs.storeFileHistory(this.history);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = ((JMenuItem)e.getSource()).getText();
        int pos = name.indexOf(32);
        File fileToOpen = new File(name = name.substring(pos + 1));
        if (!fileToOpen.exists()) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("File not found", new String[0]) + ": " + fileToOpen.getName(), Localization.lang("Error", new String[0]), 0);
            this.history.removeItem(name);
            this.setItems();
            return;
        }
        JabRefExecutorService.INSTANCE.execute(() -> this.frame.getOpenDatabaseAction().openFile(fileToOpen, true));
    }
}

