/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.menus;

import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.actions.ChangeTypeAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.CustomEntryTypesManager;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.BibtexEntryTypes;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.IEEETranEntryTypes;

public class ChangeEntryTypeMenu {
    public final Map<String, KeyStroke> entryShortCuts = new HashMap<String, KeyStroke>();

    public ChangeEntryTypeMenu() {
        this.entryShortCuts.put(BibtexEntryTypes.ARTICLE.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_ARTICLE));
        this.entryShortCuts.put(BibtexEntryTypes.BOOK.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_BOOK));
        this.entryShortCuts.put(BibtexEntryTypes.PHDTHESIS.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_PHDTHESIS));
        this.entryShortCuts.put(BibtexEntryTypes.INBOOK.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_MASTERSTHESIS));
        this.entryShortCuts.put(BibtexEntryTypes.INBOOK.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_INBOOK));
        this.entryShortCuts.put(BibtexEntryTypes.PROCEEDINGS.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_PROCEEDINGS));
        this.entryShortCuts.put(BibtexEntryTypes.UNPUBLISHED.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_UNPUBLISHED));
        this.entryShortCuts.put(BibtexEntryTypes.TECHREPORT.getName(), Globals.getKeyPrefs().getKey(KeyBinding.NEW_TECHREPORT));
    }

    public JMenu getChangeEntryTypeMenu(BasePanel panel) {
        JMenu menu = new JMenu(Localization.lang("Change entry type", new String[0]));
        this.populateChangeEntryTypeMenu(menu, panel);
        return menu;
    }

    public JPopupMenu getChangeentryTypePopupMenu(BasePanel panel) {
        JMenu menu = this.getChangeEntryTypeMenu(panel);
        return menu.getPopupMenu();
    }

    private void populateChangeEntryTypeMenu(JMenu menu, BasePanel panel) {
        menu.removeAll();
        if (panel.getBibDatabaseContext().isBiblatexMode()) {
            for (EntryType type : EntryTypes.getAllValues(BibDatabaseMode.BIBLATEX)) {
                menu.add(new ChangeTypeAction(type, panel));
            }
        } else {
            this.createEntryTypeSection(panel, menu, "BibTeX Entries", BibtexEntryTypes.ALL);
            menu.addSeparator();
            this.createEntryTypeSection(panel, menu, "IEEETran Entries", IEEETranEntryTypes.ALL);
            menu.addSeparator();
            this.createEntryTypeSection(panel, menu, "Custom Entries", CustomEntryTypesManager.ALL);
        }
    }

    private void createEntryTypeSection(BasePanel panel, JMenu menu, String title, List<EntryType> types) {
        JMenuItem header = new JMenuItem(title);
        Font font = new Font(menu.getFont().getName(), 2, menu.getFont().getSize());
        header.setFont(font);
        header.setEnabled(false);
        if (!types.isEmpty()) {
            menu.add(header);
        }
        for (EntryType type : types) {
            menu.add(new ChangeTypeAction(type, panel));
        }
    }
}

