/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.maintable;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.maintable.MainTableColumn;
import net.sf.jabref.gui.specialfields.SpecialFieldValueViewModel;
import net.sf.jabref.gui.specialfields.SpecialFieldViewModel;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.specialfields.SpecialField;
import net.sf.jabref.model.entry.specialfields.SpecialFieldValue;

class SpecialMainTableColumnsBuilder {
    SpecialMainTableColumnsBuilder() {
    }

    MainTableColumn buildNumberColumn() {
        return new MainTableColumn("#"){

            @Override
            public Object getColumnValue(BibEntry entry) {
                return "#";
            }

            @Override
            public String getDisplayName() {
                return "#";
            }
        };
    }

    MainTableColumn buildRankingColumn() {
        return new MainTableColumn(SpecialField.RANKING.getFieldName(), Collections.singletonList(SpecialField.RANKING.getFieldName()), new JLabel(SpecialField.RANKING.getFieldName())){

            @Override
            public Object getColumnValue(BibEntry entry) {
                return entry.getField(SpecialField.RANKING.getFieldName()).flatMap(SpecialField.RANKING::parse).map(rank -> new SpecialFieldValueViewModel((SpecialFieldValue)((Object)rank)).createSpecialFieldValueLabel()).orElse(null);
            }
        };
    }

    MainTableColumn buildPriorityColumn() {
        return new MainTableColumn(SpecialField.PRIORITY.getFieldName(), Collections.singletonList(SpecialField.PRIORITY.getFieldName()), new JLabel(new SpecialFieldViewModel(SpecialField.PRIORITY).getRepresentingIcon())){

            @Override
            public Object getColumnValue(BibEntry entry) {
                return entry.getField(SpecialField.PRIORITY.getFieldName()).flatMap(SpecialField.PRIORITY::parse).map(prio -> new SpecialFieldValueViewModel((SpecialFieldValue)((Object)prio)).createSpecialFieldValueLabel()).orElse(null);
            }
        };
    }

    MainTableColumn buildReadStatusColumn() {
        return new MainTableColumn(SpecialField.READ_STATUS.getFieldName(), Collections.singletonList(SpecialField.READ_STATUS.getFieldName()), new JLabel(new SpecialFieldViewModel(SpecialField.READ_STATUS).getRepresentingIcon())){

            @Override
            public Object getColumnValue(BibEntry entry) {
                return entry.getField(SpecialField.READ_STATUS.getFieldName()).flatMap(SpecialField.READ_STATUS::parse).map(status -> new SpecialFieldValueViewModel((SpecialFieldValue)((Object)status)).createSpecialFieldValueLabel()).orElse(null);
            }
        };
    }

    MainTableColumn buildRelevanceColumn() {
        return this.createIconColumn(SpecialField.RELEVANCE.getFieldName(), Collections.singletonList(SpecialField.RELEVANCE.getFieldName()), new JLabel(new SpecialFieldViewModel(SpecialField.RELEVANCE).getRepresentingIcon()));
    }

    MainTableColumn buildPrintedColumn() {
        return this.createIconColumn(SpecialField.PRINTED.getFieldName(), Collections.singletonList(SpecialField.PRINTED.getFieldName()), new JLabel(new SpecialFieldViewModel(SpecialField.PRINTED).getRepresentingIcon()));
    }

    MainTableColumn buildQualityColumn() {
        return this.createIconColumn(SpecialField.QUALITY.getFieldName(), Collections.singletonList(SpecialField.QUALITY.getFieldName()), new JLabel(new SpecialFieldViewModel(SpecialField.QUALITY).getRepresentingIcon()));
    }

    MainTableColumn buildFileColumn() {
        return new MainTableColumn("file", Collections.singletonList("file"), new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon())){

            @Override
            public Object getColumnValue(BibEntry entry) {
                FileListTableModel fileList = new FileListTableModel();
                entry.getField("file").ifPresent(fileList::setContent);
                if (fileList.getRowCount() > 1) {
                    return new JLabel(IconTheme.JabRefIcon.FILE_MULTIPLE.getSmallIcon());
                }
                if (fileList.getRowCount() == 1) {
                    Optional<ExternalFileType> type = fileList.getEntry((int)0).type;
                    if (type.isPresent()) {
                        return type.get().getIconLabel();
                    }
                    return new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
                }
                return null;
            }
        };
    }

    MainTableColumn createIconColumn(String columnName, final List<String> fields, JLabel iconLabel) {
        return new MainTableColumn(columnName, fields, iconLabel){

            @Override
            public Object getColumnValue(BibEntry entry) {
                JLabel iconLabel = null;
                boolean iconFound = false;
                for (String field : fields) {
                    if (!entry.hasField(field)) continue;
                    if (iconFound) {
                        return new JLabel(IconTheme.JabRefIcon.FILE_MULTIPLE.getSmallIcon());
                    }
                    iconLabel = GUIGlobals.getTableIcon(field);
                    iconFound = true;
                }
                return iconLabel;
            }
        };
    }

    MainTableColumn createFileIconColumn(final String externalFileTypeName) {
        return new MainTableColumn(externalFileTypeName, Collections.singletonList("file"), new JLabel()){

            @Override
            public boolean isFileFilter() {
                return true;
            }

            @Override
            public String getDisplayName() {
                return externalFileTypeName;
            }

            @Override
            public Object getColumnValue(BibEntry entry) {
                boolean iconFound = false;
                JLabel iconLabel = null;
                FileListTableModel fileList = new FileListTableModel();
                entry.getField("file").ifPresent(fileList::setContent);
                for (int i = 0; i < fileList.getRowCount(); ++i) {
                    if (!fileList.getEntry((int)i).type.isPresent() || !externalFileTypeName.equalsIgnoreCase(fileList.getEntry((int)i).type.get().getName())) continue;
                    if (iconFound) {
                        return new JLabel(IconTheme.JabRefIcon.FILE_MULTIPLE.getSmallIcon());
                    }
                    iconLabel = fileList.getEntry((int)i).type.get().getIconLabel();
                    iconFound = true;
                }
                return iconLabel;
            }
        };
    }
}

