/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.maintable;

import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.sf.jabref.gui.maintable.MainTableColumn;
import net.sf.jabref.gui.maintable.MainTableFormat;

class PreventDraggingJTableHeader
extends JTableHeader {
    private final MainTableFormat tableFormat;

    public PreventDraggingJTableHeader(JTable table, MainTableFormat tableFormat) {
        super(table.getColumnModel());
        this.setTable(table);
        this.tableFormat = tableFormat;
        this.setupTableHeaderIcons();
    }

    private void setupTableHeaderIcons() {
        Enumeration<TableColumn> columns = this.columnModel.getColumns();
        for (TableColumn column : Collections.list(columns)) {
            MainTableColumn mainTableColumn = this.tableFormat.getTableColumn(column.getModelIndex());
            column.setHeaderValue(mainTableColumn.getHeaderLabel());
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int index = this.columnModel.getColumnIndexAtX(event.getX());
        int realIndex = this.columnModel.getColumn(index).getModelIndex();
        MainTableColumn column = this.tableFormat.getTableColumn(realIndex);
        return column.getDisplayName();
    }

    @Override
    public void setDraggedColumn(TableColumn column) {
        if (column != null && column.getModelIndex() == 0) {
            return;
        }
        super.setDraggedColumn(column);
    }

    @Override
    public TableColumn getDraggedColumn() {
        TableColumn column = super.getDraggedColumn();
        if (column != null) {
            PreventDraggingJTableHeader.preventDragBeforeNumberColumn(this.getTable(), column.getModelIndex());
        }
        return column;
    }

    private static void preventDragBeforeNumberColumn(JTable table, int modelIndex) {
        for (int columnIndex = 0; columnIndex < table.getColumnCount(); ++columnIndex) {
            TableColumn col = table.getColumnModel().getColumn(columnIndex);
            if (col.getModelIndex() != modelIndex || columnIndex >= 1) continue;
            table.getColumnModel().moveColumn(columnIndex, 1);
            return;
        }
    }
}

