/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.maintable;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.maintable.MainTable;

public class PersistenceTableColumnListener
implements TableColumnModelListener {
    private static final String SIMPLE_CLASS_NAME = PersistenceTableColumnListener.class.getSimpleName();
    private final MainTable mainTable;
    private static final String RECEIVED_NULL_EVENT = " received null event";

    public PersistenceTableColumnListener(MainTable mainTable) {
        this.mainTable = mainTable;
    }

    private void updateColumnPrefs() {
        int columnCount = this.mainTable.getColumnCount();
        ArrayList<String> storedColumns = new ArrayList<String>(columnCount - 1);
        ArrayList<String> columnsWidths = new ArrayList<String>(columnCount - 1);
        int ncWidth = -1;
        for (int i = 0; i < columnCount; ++i) {
            String name = this.mainTable.getColumnName(i);
            if (name == null || name.isEmpty()) continue;
            if ("#".equals(name)) {
                ncWidth = this.mainTable.getColumnModel().getColumn(i).getWidth();
                continue;
            }
            storedColumns.add(name.toLowerCase());
            columnsWidths.add(String.valueOf(this.mainTable.getColumnModel().getColumn(i).getWidth()));
        }
        Globals.prefs.putStringList("columnNames", storedColumns);
        Globals.prefs.putStringList("columnWidths", columnsWidths);
        Globals.prefs.putInt("numberColWidth", ncWidth);
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        assert (e != null) : SIMPLE_CLASS_NAME + " received null event";
        this.updateColumnPrefs();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        assert (e != null) : SIMPLE_CLASS_NAME + " received null event";
        this.updateColumnPrefs();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        assert (e != null) : SIMPLE_CLASS_NAME + " received null event";
        if (e.getFromIndex() == e.getToIndex()) {
            return;
        }
        this.updateColumnPrefs();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        assert (e != null) : SIMPLE_CLASS_NAME + " received null event";
        this.updateColumnPrefs();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

