/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.maintable;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.BasePanelMode;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.PreviewPanel;
import net.sf.jabref.gui.actions.CopyDoiUrlAction;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.entryeditor.EntryEditor;
import net.sf.jabref.gui.externalfiletype.ExternalFileMenuItem;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.maintable.MainTable;
import net.sf.jabref.gui.maintable.MainTableColumn;
import net.sf.jabref.gui.menus.RightClickMenu;
import net.sf.jabref.gui.specialfields.SpecialFieldMenuAction;
import net.sf.jabref.gui.specialfields.SpecialFieldValueViewModel;
import net.sf.jabref.gui.specialfields.SpecialFieldViewModel;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.specialfields.SpecialField;
import net.sf.jabref.model.entry.specialfields.SpecialFieldValue;
import net.sf.jabref.preferences.PreviewPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainTableSelectionListener
implements ListEventListener<BibEntry>,
MouseListener,
KeyListener,
FocusListener {
    private final MainTable table;
    private final BasePanel panel;
    private final EventList<BibEntry> tableRows;
    private PreviewPanel preview;
    private boolean previewActive = Globals.prefs.getPreviewPreferences().isPreviewPanelEnabled();
    private boolean workingOnPreview;
    private boolean enabled = true;
    private final int[] lastPressed = new int[20];
    private int lastPressedCount;
    private long lastPressedTime;
    private static final Log LOGGER = LogFactory.getLog(MainTableSelectionListener.class);

    public MainTableSelectionListener(BasePanel panel, MainTable table) {
        this.table = table;
        this.panel = panel;
        this.tableRows = table.getTableModel().getTableRows();
        PreviewPanel previewPanel = panel.getPreviewPanel();
        if (previewPanel != null) {
            this.preview = previewPanel;
        } else {
            this.preview = new PreviewPanel(panel.getBibDatabaseContext(), null, panel);
            panel.frame().getGlobalSearchBar().getSearchQueryHighlightObservable().addSearchListener(this.preview);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void listChanged(ListEvent<BibEntry> e) {
        if (!this.enabled) {
            return;
        }
        EventList<BibEntry> selected = e.getSourceList();
        if (selected.isEmpty()) {
            return;
        }
        BibEntry newSelected = (BibEntry)selected.get(0);
        if ((this.panel.getMode() == BasePanelMode.SHOWING_EDITOR || this.panel.getMode() == BasePanelMode.WILL_SHOW_EDITOR) && this.panel.getCurrentEditor() != null && newSelected == this.panel.getCurrentEditor().getEntry()) {
            return;
        }
        if (newSelected != null) {
            BasePanelMode mode = this.panel.getMode();
            if (mode == BasePanelMode.WILL_SHOW_EDITOR || mode == BasePanelMode.SHOWING_EDITOR) {
                EntryEditor newEditor;
                EntryEditor oldEditor = this.panel.getCurrentEditor();
                String visName = null;
                if (oldEditor != null) {
                    visName = oldEditor.getVisiblePanelName();
                }
                if (!Objects.equals(newEditor = this.panel.getEntryEditor(newSelected), oldEditor) || mode != BasePanelMode.SHOWING_EDITOR) {
                    if (visName != null) {
                        newEditor.setVisiblePanel(visName);
                    }
                    this.panel.showEntryEditor(newEditor);
                    SwingUtilities.invokeLater(() -> this.table.ensureVisible(this.table.getSelectedRow()));
                } else {
                    newEditor.setMovingToDifferentEntry();
                }
            } else if (this.previewActive) {
                this.updatePreview(newSelected, false);
            }
        }
    }

    private void updatePreview(BibEntry toShow, boolean changedPreview) {
        this.updatePreview(toShow, changedPreview, 0);
    }

    private void updatePreview(BibEntry toShow, boolean changedPreview, int repeats) {
        if (this.workingOnPreview) {
            if (repeats > 0) {
                return;
            }
            Timer t = new Timer(50, actionEvent -> this.updatePreview(toShow, changedPreview, 1));
            t.setRepeats(false);
            t.start();
            return;
        }
        EventList<BibEntry> list = this.table.getSelected();
        if (list.size() != 1 || list.get(0) != toShow) {
            return;
        }
        BasePanelMode mode = this.panel.getMode();
        this.workingOnPreview = true;
        SwingUtilities.invokeLater(() -> {
            this.preview.setEntry(toShow);
            if (changedPreview || mode == BasePanelMode.SHOWING_NOTHING) {
                this.panel.showPreview(this.preview);
                this.panel.adjustSplitter();
            }
            this.workingOnPreview = false;
        });
    }

    public void editSignalled() {
        if (this.table.getSelected().size() == 1) {
            this.editSignalled((BibEntry)this.table.getSelected().get(0));
        }
    }

    public void editSignalled(BibEntry entry) {
        BasePanelMode mode = this.panel.getMode();
        if (mode != BasePanelMode.SHOWING_EDITOR) {
            this.panel.showEntryEditor(this.panel.getEntryEditor(entry));
        }
        this.panel.getCurrentEditor().requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int col = this.table.columnAtPoint(e.getPoint());
        int row = this.table.rowAtPoint(e.getPoint());
        int modelIndex = this.table.getColumnModel().getColumn(col).getModelIndex();
        MainTableColumn modelColumn = this.table.getMainTableColumn(modelIndex);
        if (e.isPopupTrigger() || e.getButton() == 3) {
            if (modelColumn == null || !modelColumn.isIconColumn()) {
                this.processPopupTrigger(e, row);
            } else {
                this.showIconRightClickMenu(e, row, modelColumn);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (e.getClickCount() == 2) {
            BibEntry toShow = (BibEntry)this.tableRows.get(row);
            this.editSignalled(toShow);
            return;
        }
        int col = this.table.columnAtPoint(e.getPoint());
        int modelIndex = this.table.getColumnModel().getColumn(col).getModelIndex();
        MainTableColumn modelColumn = this.table.getMainTableColumn(modelIndex);
        if (OS.WINDOWS && modelColumn.isIconColumn() && e.getButton() != 1) {
            return;
        }
        if (modelColumn.isIconColumn() && SpecialField.isSpecialField(modelColumn.getColumnName())) {
            this.handleSpecialFieldLeftClick(e, modelColumn.getColumnName());
        } else if (modelColumn.isIconColumn()) {
            Object value = this.table.getValueAt(row, col);
            if (value == null) {
                return;
            }
            BibEntry entry = (BibEntry)this.tableRows.get(row);
            List<String> fieldNames = modelColumn.getBibtexFields();
            JabRefExecutorService.INSTANCE.execute(() -> {
                this.panel.output(Localization.lang("External viewer called", new String[0]) + '.');
                for (String fieldName : fieldNames) {
                    if (!entry.hasField(fieldName)) continue;
                    String link = entry.getField(fieldName).get();
                    if (fieldName.equals("file")) {
                        ExternalFileMenuItem item;
                        boolean success;
                        FileListTableModel fileList = new FileListTableModel();
                        fileList.setContent(link);
                        FileListEntry flEntry = null;
                        if (modelColumn.isFileFilter()) {
                            for (int i = 0; i < fileList.getRowCount(); ++i) {
                                if (!fileList.getEntry((int)i).type.toString().equals(modelColumn.getColumnName())) continue;
                                flEntry = fileList.getEntry(i);
                                break;
                            }
                        } else if (fileList.getRowCount() > 0) {
                            flEntry = fileList.getEntry(0);
                        }
                        if (flEntry == null || (success = (item = new ExternalFileMenuItem(this.panel.frame(), entry, "", flEntry.link, (Icon)flEntry.type.map(ExternalFileType::getIcon).orElse(null), this.panel.getBibDatabaseContext(), flEntry.type)).openLink())) break;
                        this.panel.output(Localization.lang("Unable to open link.", new String[0]));
                        break;
                    }
                    try {
                        JabRefDesktop.openExternalViewer(this.panel.getBibDatabaseContext(), link, fieldName);
                    }
                    catch (IOException ex) {
                        this.panel.output(Localization.lang("Unable to open link.", new String[0]));
                        LOGGER.info("Unable to open link", ex);
                    }
                    break;
                }
            });
        } else if (modelColumn.getBibtexFields().contains("crossref")) {
            ((BibEntry)this.tableRows.get(row)).getField("crossref").ifPresent(crossref -> this.panel.getDatabase().getEntryByKey((String)crossref).ifPresent(entry -> this.panel.highlightEntry((BibEntry)entry)));
        }
        this.panel.frame().updateEnabledState();
    }

    private void handleSpecialFieldLeftClick(MouseEvent e, String columnName) {
        if (e.getClickCount() == 1) {
            SpecialField.getSpecialFieldInstanceFromFieldName(columnName).ifPresent(field -> {
                if (field.isSingleValueField()) {
                    new SpecialFieldViewModel((SpecialField)((Object)field)).getSpecialFieldAction(field.getValues().get(0), this.panel.frame()).action();
                } else {
                    JPopupMenu menu = new JPopupMenu();
                    for (SpecialFieldValue val : field.getValues()) {
                        menu.add(new SpecialFieldMenuAction(new SpecialFieldValueViewModel(val), this.panel.frame()));
                    }
                    menu.show(this.table, e.getX(), e.getY());
                }
            });
        }
    }

    private void processPopupTrigger(MouseEvent e, int row) {
        int selRow = this.table.getSelectedRow();
        if (selRow == -1 || !this.table.isRowSelected(this.table.rowAtPoint(e.getPoint()))) {
            this.table.setRowSelectionInterval(row, row);
        }
        RightClickMenu rightClickMenu = new RightClickMenu(JabRefGUI.getMainFrame(), this.panel);
        rightClickMenu.show(this.table, e.getX(), e.getY());
    }

    private void showIconRightClickMenu(MouseEvent e, int row, MainTableColumn column) {
        BibEntry entry = (BibEntry)this.tableRows.get(row);
        JPopupMenu menu = new JPopupMenu();
        boolean showDefaultPopup = true;
        if (!column.getBibtexFields().isEmpty()) {
            for (String field : column.getBibtexFields()) {
                if ("file".equals(field)) {
                    FileListTableModel fileList = new FileListTableModel();
                    entry.getField(field).ifPresent(fileList::setContent);
                    for (int i = 0; i < fileList.getRowCount(); ++i) {
                        FileListEntry flEntry = fileList.getEntry(i);
                        if (column.isFileFilter() && !flEntry.type.get().getName().equalsIgnoreCase(column.getColumnName())) continue;
                        String description = flEntry.description;
                        if (description == null || description.trim().isEmpty()) {
                            description = flEntry.link;
                        }
                        menu.add(new ExternalFileMenuItem(this.panel.frame(), entry, description, flEntry.link, flEntry.type.get().getIcon(), this.panel.getBibDatabaseContext(), flEntry.type));
                        showDefaultPopup = false;
                    }
                    continue;
                }
                if (SpecialField.isSpecialField(column.getColumnName())) {
                    showDefaultPopup = true;
                    continue;
                }
                Optional<String> content = entry.getField(field);
                if (!content.isPresent()) continue;
                JLabel iconLabel = GUIGlobals.getTableIcon(field);
                Icon icon = iconLabel == null ? IconTheme.JabRefIcon.FILE.getIcon() : iconLabel.getIcon();
                menu.add(new ExternalFileMenuItem(this.panel.frame(), entry, content.get(), content.get(), icon, this.panel.getBibDatabaseContext(), field));
                if (field.equals("doi")) {
                    menu.add(new CopyDoiUrlAction(content.get()));
                }
                showDefaultPopup = false;
            }
            if (showDefaultPopup) {
                this.processPopupTrigger(e, row);
            } else {
                menu.show(this.table, e.getX(), e.getY());
            }
        }
    }

    public void entryEditorClosing(EntryEditor editor) {
        this.preview.setEntry(editor.getEntry());
        if (this.previewActive) {
            this.panel.showPreview(this.preview);
        } else {
            this.panel.hideBottomComponent();
        }
        this.panel.adjustSplitter();
        this.table.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setPreviewActive(boolean enabled) {
        this.previewActive = enabled;
        if (this.previewActive) {
            if (!this.table.getSelected().isEmpty()) {
                this.updatePreview((BibEntry)this.table.getSelected().get(0), false);
            }
        } else {
            this.panel.hideBottomComponent();
        }
    }

    public void nextPreviewStyle() {
        this.cyclePreview(Globals.prefs.getPreviewPreferences().getPreviewCyclePosition() + 1);
    }

    public void previousPreviewStyle() {
        this.cyclePreview(Globals.prefs.getPreviewPreferences().getPreviewCyclePosition() - 1);
    }

    private void cyclePreview(int newPosition) {
        PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences().getBuilder().withPreviewCyclePosition(newPosition).build();
        Globals.prefs.storePreviewPreferences(previewPreferences);
        this.preview.updateLayout();
        this.preview.update();
        this.panel.showPreview(this.preview);
        if (!this.table.getSelected().isEmpty()) {
            this.updatePreview((BibEntry)this.table.getSelected().get(0), true);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!e.isActionKey() && Character.isLetterOrDigit(e.getKeyChar()) && e.getModifiers() == 0) {
            int sortingColumn;
            long time = System.currentTimeMillis();
            long QUICK_JUMP_TIMEOUT = 2000L;
            if (time - this.lastPressedTime > 2000L) {
                this.lastPressedCount = 0;
            }
            this.lastPressedTime = time;
            char c = e.getKeyChar();
            if (this.lastPressedCount < this.lastPressed.length) {
                this.lastPressed[this.lastPressedCount] = c;
                ++this.lastPressedCount;
            }
            if ((sortingColumn = this.table.getSortingColumn(0)) == -1) {
                return;
            }
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                String s;
                Object o = this.table.getValueAt(i, sortingColumn);
                if (o == null || (s = o.toString().toLowerCase()).length() < this.lastPressedCount) continue;
                for (int j = 0; j < this.lastPressedCount && s.charAt(j) == this.lastPressed[j]; ++j) {
                    if (j != this.lastPressedCount - 1) continue;
                    this.table.setRowSelectionInterval(i, i);
                    this.table.ensureVisible(i);
                    return;
                }
            }
        } else if (e.getKeyChar() == '\u001b') {
            this.lastPressedCount = 0;
        }
        this.panel.frame().updateEnabledState();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.lastPressedCount = 0;
    }

    public PreviewPanel getPreview() {
        return this.preview;
    }
}

