/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.maintable;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.swing.JLabel;
import net.sf.jabref.gui.maintable.MainTableNameFormatter;
import net.sf.jabref.logic.layout.LayoutFormatter;
import net.sf.jabref.logic.layout.format.LatexToUnicodeFormatter;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class MainTableColumn {
    private final String columnName;
    private final List<String> bibtexFields;
    private final boolean isIconColumn;
    private final Optional<JLabel> iconLabel;
    private final Optional<BibDatabase> database;
    private final LayoutFormatter toUnicode = new LatexToUnicodeFormatter();

    public MainTableColumn(String columnName) {
        this.columnName = columnName;
        this.bibtexFields = Collections.emptyList();
        this.isIconColumn = false;
        this.iconLabel = Optional.empty();
        this.database = Optional.empty();
    }

    public MainTableColumn(String columnName, List<String> bibtexFields, BibDatabase database) {
        this.columnName = columnName;
        this.bibtexFields = Collections.unmodifiableList(bibtexFields);
        this.isIconColumn = false;
        this.iconLabel = Optional.empty();
        this.database = Optional.of(database);
    }

    public MainTableColumn(String columnName, List<String> bibtexFields, JLabel iconLabel) {
        this.columnName = columnName;
        this.bibtexFields = Collections.unmodifiableList(bibtexFields);
        this.isIconColumn = true;
        this.iconLabel = Optional.of(iconLabel);
        this.database = Optional.empty();
    }

    public String getDisplayName() {
        if (this.bibtexFields.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner("/");
        for (String field : this.bibtexFields) {
            joiner.add(field);
        }
        return joiner.toString();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List<String> getBibtexFields() {
        return this.bibtexFields;
    }

    public boolean isIconColumn() {
        return this.isIconColumn;
    }

    public boolean isFileFilter() {
        return false;
    }

    public Object getColumnValue(BibEntry entry) {
        if (this.bibtexFields.isEmpty()) {
            return null;
        }
        boolean isNameColumn = false;
        Optional<Object> content = Optional.empty();
        for (String field : this.bibtexFields) {
            content = BibDatabase.getResolvedField(field, entry, this.database.orElse(null));
            if (!content.isPresent()) continue;
            isNameColumn = InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.PERSON_NAMES);
            break;
        }
        String result = content.orElse(null);
        if (isNameColumn) {
            result = MainTableNameFormatter.formatName(result);
        }
        if (result != null) {
            result = this.toUnicode.format(result).trim();
        }
        return result;
    }

    public JLabel getHeaderLabel() {
        if (this.isIconColumn) {
            return this.iconLabel.get();
        }
        return new JLabel(this.getDisplayName());
    }

    public boolean isResolved(BibEntry entry) {
        if (this.bibtexFields.isEmpty()) {
            return false;
        }
        Optional<Object> resolvedFieldContent = Optional.empty();
        Optional<Object> plainFieldContent = Optional.empty();
        for (String field : this.bibtexFields) {
            if ("entrytype".equals(field) || "bibtextype".equals(field) || "bibtexkey".equals(field)) {
                return false;
            }
            plainFieldContent = entry.getField(field);
            resolvedFieldContent = BibDatabase.getResolvedField(field, entry, this.database.orElse(null));
            if (!resolvedFieldContent.isPresent()) continue;
            break;
        }
        return !resolvedFieldContent.equals(plainFieldContent);
    }
}

