/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.maintable;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.EntryMarker;
import net.sf.jabref.gui.GUIGlobals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.groups.EntryTableTransferHandler;
import net.sf.jabref.gui.groups.GroupMatcher;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.maintable.MainTableColumn;
import net.sf.jabref.gui.maintable.MainTableDataModel;
import net.sf.jabref.gui.maintable.MainTableFormat;
import net.sf.jabref.gui.maintable.MainTableHeaderRenderer;
import net.sf.jabref.gui.maintable.PersistenceTableColumnListener;
import net.sf.jabref.gui.maintable.PreventDraggingJTableHeader;
import net.sf.jabref.gui.renderer.CompleteRenderer;
import net.sf.jabref.gui.renderer.GeneralRenderer;
import net.sf.jabref.gui.renderer.IncompleteRenderer;
import net.sf.jabref.gui.search.matchers.SearchMatcher;
import net.sf.jabref.gui.util.comparator.FirstColumnComparator;
import net.sf.jabref.gui.util.comparator.IconComparator;
import net.sf.jabref.gui.util.comparator.RankingFieldComparator;
import net.sf.jabref.logic.TypedBibEntry;
import net.sf.jabref.logic.bibtex.comparator.FieldComparator;
import net.sf.jabref.model.EntryTypes;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.specialfields.SpecialField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainTable
extends JTable {
    private static final Log LOGGER = LogFactory.getLog(MainTable.class);
    private final MainTableFormat tableFormat;
    private final BasePanel panel;
    private final boolean tableColorCodes;
    private final boolean tableResolvedColorCodes;
    private final DefaultEventSelectionModel<BibEntry> localSelectionModel;
    private final TableComparatorChooser<BibEntry> comparatorChooser;
    private final JScrollPane pane;
    private final PersistenceTableColumnListener tableColumnListener;
    private final MainTableDataModel model;
    private static GeneralRenderer defRenderer;
    private static GeneralRenderer reqRenderer;
    private static GeneralRenderer optRenderer;
    private static GeneralRenderer resolvedRenderer;
    private static GeneralRenderer grayedOutRenderer;
    private static GeneralRenderer veryGrayedOutRenderer;
    private static List<GeneralRenderer> markedRenderers;
    private static IncompleteRenderer incRenderer;
    private static CompleteRenderer compRenderer;
    private static CompleteRenderer grayedOutNumberRenderer;
    private static CompleteRenderer veryGrayedOutNumberRenderer;
    private static List<CompleteRenderer> markedNumberRenderers;

    public MainTable(MainTableFormat tableFormat, MainTableDataModel model, JabRefFrame frame, final BasePanel panel) {
        this.model = model;
        this.addFocusListener(Globals.getFocusListener());
        this.setAutoResizeMode(Globals.prefs.getInt("autoResizeMode"));
        this.tableFormat = tableFormat;
        this.panel = panel;
        this.setModel(GlazedListsSwing.eventTableModelWithThreadProxyList(model.getTableRows(), tableFormat));
        this.tableColorCodes = Globals.prefs.getBoolean("tableColorCodesOn");
        this.tableResolvedColorCodes = Globals.prefs.getBoolean("tableResolvedColorCodesOn");
        this.localSelectionModel = (DefaultEventSelectionModel)GlazedListsSwing.eventSelectionModelWithThreadProxyList(model.getTableRows());
        this.setSelectionModel(this.localSelectionModel);
        this.pane = new JScrollPane(this);
        this.pane.setBorder(BorderFactory.createEmptyBorder());
        this.pane.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
        this.setGridColor(Globals.prefs.getColor("gridColor"));
        if (Globals.prefs.getBoolean("tableShowGrid")) {
            this.setShowGrid(true);
        } else {
            this.setShowGrid(false);
            this.setIntercellSpacing(new Dimension(0, 0));
        }
        this.setTableHeader(new PreventDraggingJTableHeader(this, tableFormat));
        this.comparatorChooser = this.createTableComparatorChooser(this, model.getSortedForUserDefinedTableColumnSorting(), AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.tableColumnListener = new PersistenceTableColumnListener(this);
        this.getTableHeader().setDefaultRenderer(new MainTableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.getSelected();
        this.setDragEnabled(true);
        EntryTableTransferHandler xfer = new EntryTableTransferHandler(this, frame, panel);
        this.setTransferHandler(xfer);
        this.pane.setTransferHandler(xfer);
        this.setupComparatorChooser();
        model.updateMarkingState(Globals.prefs.getBoolean("floatMarkedEntries"));
        this.setWidths();
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap();
        actionMap.put("selectNextColumnCell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.selectNextEntry();
            }
        });
        actionMap.put("selectPreviousColumnCell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.selectPreviousEntry();
            }
        });
        actionMap.put("selectNextRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.selectNextEntry();
            }
        });
        actionMap.put("selectPreviousRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.selectPreviousEntry();
            }
        });
        String selectFirst = "selectFirst";
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.SELECT_FIRST_ENTRY), selectFirst);
        actionMap.put(selectFirst, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                panel.selectFirstEntry();
            }
        });
        String selectLast = "selectLast";
        inputMap.put(Globals.getKeyPrefs().getKey(KeyBinding.SELECT_LAST_ENTRY), selectLast);
        actionMap.put(selectLast, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                panel.selectLastEntry();
            }
        });
    }

    public void addSelectionListener(ListEventListener<BibEntry> listener) {
        this.getSelected().addListEventListener(listener);
    }

    public JScrollPane getPane() {
        return this.pane;
    }

    public MainTableDataModel getTableModel() {
        return this.model;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String toolTipText = super.getToolTipText(e);
        Point p = e.getPoint();
        int col = this.columnAtPoint(p);
        int row = this.rowAtPoint(p);
        Rectangle bounds = this.getCellRect(row, col, false);
        Dimension d = this.prepareRenderer(this.getCellRenderer(row, col), row, col).getPreferredSize();
        if (d != null && d.width > bounds.width && this.getValueAt(row, col) != null) {
            toolTipText = this.getValueAt(row, col).toString();
        }
        return toolTipText;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int score = -3;
        DefaultTableCellRenderer renderer = defRenderer;
        if (this.model.getSearchState() != MainTableDataModel.DisplayOption.FLOAT || this.matches(row, SearchMatcher.INSTANCE)) {
            ++score;
        }
        if (this.model.getGroupingState() != MainTableDataModel.DisplayOption.FLOAT || this.matches(row, GroupMatcher.INSTANCE)) {
            score += 2;
        }
        if (score < -1) {
            if (column == 0) {
                veryGrayedOutNumberRenderer.setNumber(row);
                renderer = veryGrayedOutNumberRenderer;
            } else {
                renderer = veryGrayedOutRenderer;
            }
        } else if (score == -1) {
            if (column == 0) {
                grayedOutNumberRenderer.setNumber(row);
                renderer = grayedOutNumberRenderer;
            } else {
                renderer = grayedOutRenderer;
            }
        } else if (column == 0) {
            if (this.isComplete(row)) {
                compRenderer.setNumber(row);
                int marking = this.isMarked(row);
                if (marking > 0) {
                    marking = Math.min(marking, 6);
                    renderer = markedNumberRenderers.get(marking - 1);
                    markedNumberRenderers.get(marking - 1).setNumber(row);
                } else {
                    renderer = compRenderer;
                }
            } else {
                incRenderer.setNumber(row);
                renderer = incRenderer;
            }
        } else if (this.tableColorCodes || this.tableResolvedColorCodes) {
            CellRendererMode status = this.getCellStatus(row, column, this.tableResolvedColorCodes);
            if (status == CellRendererMode.REQUIRED) {
                renderer = reqRenderer;
            } else if (status == CellRendererMode.OPTIONAL) {
                renderer = optRenderer;
            } else if (status == CellRendererMode.RESOLVED) {
                renderer = resolvedRenderer;
            }
        }
        int marking = this.isMarked(row);
        if (column != 0 && marking > 0) {
            marking = Math.min(marking, 6);
            renderer = markedRenderers.get(marking - 1);
        }
        return renderer;
    }

    private void setWidths() {
        int ncWidth = Globals.prefs.getInt("numberColWidth");
        List<String> widthsFromPreferences = Globals.prefs.getStringList("columnWidths");
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(0).setPreferredWidth(ncWidth);
        block2: for (int i = 1; i < cm.getColumnCount(); ++i) {
            MainTableColumn mainTableColumn = this.tableFormat.getTableColumn(cm.getColumn(i).getModelIndex());
            if (SpecialField.RANKING.getFieldName().equals(mainTableColumn.getColumnName())) {
                cm.getColumn(i).setPreferredWidth(80);
                cm.getColumn(i).setMinWidth(80);
                cm.getColumn(i).setMaxWidth(80);
                continue;
            }
            if (mainTableColumn.isIconColumn()) {
                cm.getColumn(i).setPreferredWidth(26);
                cm.getColumn(i).setMinWidth(26);
                cm.getColumn(i).setMaxWidth(26);
                continue;
            }
            List<String> allColumns = Globals.prefs.getStringList("columnNames");
            for (int j = 0; j < allColumns.size(); ++j) {
                if (!allColumns.get(j).equalsIgnoreCase(mainTableColumn.getDisplayName())) continue;
                try {
                    cm.getColumn(i).setPreferredWidth(Integer.parseInt(widthsFromPreferences.get(j)));
                }
                catch (NumberFormatException e) {
                    LOGGER.info("Exception while setting column widths. Choosing default.", e);
                    cm.getColumn(i).setPreferredWidth(100);
                }
                continue block2;
            }
        }
    }

    public BibEntry getEntryAt(int row) {
        return (BibEntry)this.model.getTableRows().get(row);
    }

    public List<BibEntry> getSelectedEntries() {
        return new ArrayList<BibEntry>(this.getSelected());
    }

    private List<Boolean> getCurrentSortOrder() {
        ArrayList<Boolean> order = new ArrayList<Boolean>();
        List<Integer> sortCols = this.comparatorChooser.getSortingColumns();
        for (Integer i : sortCols) {
            order.add(this.comparatorChooser.isColumnReverse(i));
        }
        return order;
    }

    private List<String> getCurrentSortFields() {
        List<Integer> sortCols = this.comparatorChooser.getSortingColumns();
        ArrayList<String> fields = new ArrayList<String>();
        for (Integer i : sortCols) {
            String name = this.tableFormat.getColumnName(i);
            if (name == null) continue;
            fields.add(name.toLowerCase());
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupComparatorChooser() {
        List<Comparator> comparators = this.comparatorChooser.getComparatorsForColumn(0);
        comparators.clear();
        comparators.add(new FirstColumnComparator(this.panel.getBibDatabaseContext()));
        for (int i = 1; i < this.tableFormat.getColumnCount(); ++i) {
            MainTableColumn tableColumn = this.tableFormat.getTableColumn(i);
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            if (SpecialField.RANKING.getFieldName().equals(tableColumn.getColumnName())) {
                comparators.add(new RankingFieldComparator());
                continue;
            }
            if (tableColumn.isIconColumn()) {
                comparators.add(new IconComparator(tableColumn.getBibtexFields()));
                continue;
            }
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            comparators.add(new FieldComparator(this.tableFormat.getColumnName(i).toLowerCase()));
        }
        String[] sortFields = new String[]{Globals.prefs.get("priSort"), Globals.prefs.get("secSort"), Globals.prefs.get("terSort")};
        boolean[] sortDirections = new boolean[]{Globals.prefs.getBoolean("priDescending"), Globals.prefs.getBoolean("secDescending"), Globals.prefs.getBoolean("terDescending")};
        this.model.getSortedForUserDefinedTableColumnSorting().getReadWriteLock().writeLock().lock();
        try {
            for (int i = 0; i < sortFields.length; ++i) {
                int index = -1;
                if (sortFields[i].startsWith("iconcol:")) {
                    for (int j = 0; j < this.tableFormat.getColumnCount(); ++j) {
                        if (!sortFields[i].equals(this.tableFormat.getColumnName(j))) continue;
                        index = j;
                        break;
                    }
                } else {
                    index = this.tableFormat.getColumnIndex(sortFields[i]);
                }
                if (index < 0) continue;
                this.comparatorChooser.appendComparator(index, 0, sortDirections[i]);
            }
        }
        finally {
            this.model.getSortedForUserDefinedTableColumnSorting().getReadWriteLock().writeLock().unlock();
        }
        this.comparatorChooser.addSortActionListener(e -> {
            List<String> fields = this.getCurrentSortFields();
            List<Boolean> order = this.getCurrentSortOrder();
            int count = Math.min(fields.size(), order.size());
            if (count >= 1) {
                Globals.prefs.put("priSort", fields.get(0));
                Globals.prefs.putBoolean("priDescending", order.get(0));
            }
            if (count >= 2) {
                Globals.prefs.put("secSort", fields.get(1));
                Globals.prefs.putBoolean("secDescending", order.get(1));
            } else {
                Globals.prefs.put("secSort", "");
                Globals.prefs.putBoolean("secDescending", false);
            }
            if (count >= 3) {
                Globals.prefs.put("terSort", fields.get(2));
                Globals.prefs.putBoolean("terDescending", order.get(2));
            } else {
                Globals.prefs.put("terSort", "");
                Globals.prefs.putBoolean("terDescending", false);
            }
        });
    }

    private CellRendererMode getCellStatus(int row, int col, boolean checkResolved) {
        try {
            BibEntry be = this.getEntryAt(row);
            if (checkResolved && this.tableFormat.getTableColumn(col).isResolved(be)) {
                return CellRendererMode.RESOLVED;
            }
            Optional<EntryType> type = EntryTypes.getType(be.getType(), this.panel.getBibDatabaseContext().getMode());
            if (type.isPresent()) {
                String columnName = this.getColumnName(col).toLowerCase();
                if (columnName.equals("bibtexkey") || type.get().getRequiredFieldsFlat().contains(columnName)) {
                    return CellRendererMode.REQUIRED;
                }
                if (type.get().getOptionalFields().contains(columnName)) {
                    return CellRendererMode.OPTIONAL;
                }
            }
            return CellRendererMode.OTHER;
        }
        catch (NullPointerException ex) {
            return CellRendererMode.OTHER;
        }
    }

    public EventList<BibEntry> getSelected() {
        return this.localSelectionModel.getSelected();
    }

    public void setSelected(int row) {
        this.localSelectionModel.setSelectionInterval(row, row);
    }

    public int findEntry(BibEntry entry) {
        EventList<BibEntry> tableRows = this.model.getTableRows();
        for (int row = 0; row < tableRows.size(); ++row) {
            BibEntry bibEntry = (BibEntry)tableRows.get(row);
            if (entry != bibEntry) continue;
            return row;
        }
        return -1;
    }

    public boolean isFileColumn(int modelIndex) {
        return this.tableFormat.getTableColumn(modelIndex) != null && this.tableFormat.getTableColumn(modelIndex).getBibtexFields().contains("file");
    }

    private boolean matches(int row, Matcher<BibEntry> m) {
        Optional<BibEntry> bibEntry = this.getBibEntry(row);
        if (bibEntry.isPresent()) {
            return m.matches(bibEntry.get());
        }
        return m.matches(null);
    }

    private boolean isComplete(int row) {
        Optional<BibEntry> bibEntry = this.getBibEntry(row);
        if (bibEntry.isPresent()) {
            TypedBibEntry typedEntry = new TypedBibEntry(bibEntry.get(), this.panel.getBibDatabaseContext());
            return typedEntry.hasAllRequiredFields();
        }
        return true;
    }

    private int isMarked(int row) {
        Optional<BibEntry> bibEntry = this.getBibEntry(row);
        if (bibEntry.isPresent()) {
            return EntryMarker.isMarked(bibEntry.get());
        }
        return 0;
    }

    private Optional<BibEntry> getBibEntry(int row) {
        try {
            return Optional.of((BibEntry)this.model.getTableRows().get(row));
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    public void scrollTo(int y) {
        JScrollBar scb = this.pane.getVerticalScrollBar();
        scb.setValue(y * scb.getUnitIncrement(1));
    }

    public void showFloatSearch() {
        this.getTableModel().updateSearchState(MainTableDataModel.DisplayOption.FLOAT);
        this.scrollTo(0);
    }

    public void updateFont() {
        this.setFont(GUIGlobals.currentFont);
        this.setRowHeight(Globals.prefs.getInt("tableRowPadding") + GUIGlobals.currentFont.getSize());
    }

    public void ensureVisible(int row) {
        JScrollBar vert = this.pane.getVerticalScrollBar();
        int y = row * this.getRowHeight();
        if (y < vert.getValue() || y >= vert.getValue() + vert.getVisibleAmount() && this.model.getSearchState() != MainTableDataModel.DisplayOption.FLOAT) {
            this.scrollToCenter(row, 1);
        }
    }

    public void scrollToCenter(int rowIndex, int vColIndex) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(rowIndex, vColIndex, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
        this.revalidate();
        this.repaint();
    }

    public static void updateRenderers() {
        defRenderer = new GeneralRenderer(Globals.prefs.getColor("tableBackground"), Globals.prefs.getColor("tableText"));
        Color sel = defRenderer.getTableCellRendererComponent(new JTable(), "", true, false, 0, 0).getBackground();
        reqRenderer = new GeneralRenderer(Globals.prefs.getColor("tableReqFieldBackground"), Globals.prefs.getColor("tableText"));
        optRenderer = new GeneralRenderer(Globals.prefs.getColor("tableOptFieldBackground"), Globals.prefs.getColor("tableText"));
        resolvedRenderer = new GeneralRenderer(Globals.prefs.getColor("tableResolvedFieldBackground"), Globals.prefs.getColor("tableText"));
        incRenderer = new IncompleteRenderer();
        compRenderer = new CompleteRenderer(Globals.prefs.getColor("tableBackground"));
        grayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("grayedOutBackground"));
        veryGrayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("veryGrayedOutBackground"));
        grayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("grayedOutBackground"), Globals.prefs.getColor("grayedOutText"), MainTable.mixColors(Globals.prefs.getColor("grayedOutBackground"), sel));
        veryGrayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("veryGrayedOutBackground"), Globals.prefs.getColor("veryGrayedOutText"), MainTable.mixColors(Globals.prefs.getColor("veryGrayedOutBackground"), sel));
        markedRenderers = new ArrayList<GeneralRenderer>(6);
        markedNumberRenderers = new ArrayList<CompleteRenderer>(6);
        for (int i = 0; i < 6; ++i) {
            Color c = Globals.prefs.getColor("markedEntryBackground" + i);
            markedRenderers.add(new GeneralRenderer(c, Globals.prefs.getColor("tableText"), MainTable.mixColors(Globals.prefs.getColor("markedEntryBackground" + i), sel)));
            markedNumberRenderers.add(new CompleteRenderer(c));
        }
    }

    private static Color mixColors(Color one, Color two) {
        return new Color((one.getRed() + two.getRed()) / 2, (one.getGreen() + two.getGreen()) / 2, (one.getBlue() + two.getBlue()) / 2);
    }

    private TableComparatorChooser<BibEntry> createTableComparatorChooser(JTable table, SortedList<BibEntry> list, Object sortingStrategy) {
        return TableComparatorChooser.install(table, list, sortingStrategy);
    }

    @Override
    public void setUI(TableUI newUI) {
        super.setUI(newUI);
        TransferHandler handler = this.getTransferHandler();
        this.setTransferHandler(null);
        this.setTransferHandler(handler);
    }

    public int getSortingColumn(int number) {
        List<Integer> l = this.comparatorChooser.getSortingColumns();
        if (l.size() <= number) {
            return -1;
        }
        return l.get(number);
    }

    public PersistenceTableColumnListener getTableColumnListener() {
        return this.tableColumnListener;
    }

    public MainTableColumn getMainTableColumn(int modelIndex) {
        return this.tableFormat.getTableColumn(modelIndex);
    }

    static {
        MainTable.updateRenderers();
    }

    private static enum CellRendererMode {
        REQUIRED,
        RESOLVED,
        OPTIONAL,
        OTHER;

    }
}

