/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.maintable;

import ca.odell.glazedlists.EventList;
import com.google.common.eventbus.Subscribe;
import net.sf.jabref.model.database.event.EntryAddedEvent;
import net.sf.jabref.model.database.event.EntryRemovedEvent;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.event.EntryChangedEvent;

public class ListSynchronizer {
    private final EventList<BibEntry> list;

    public ListSynchronizer(EventList<BibEntry> list) {
        this.list = list;
    }

    @Subscribe
    public void listen(EntryAddedEvent entryAddedEvent) {
        this.lock();
        try {
            this.list.add(entryAddedEvent.getBibEntry());
        }
        finally {
            this.unlock();
        }
    }

    @Subscribe
    public void listen(EntryRemovedEvent entryRemovedEvent) {
        this.lock();
        try {
            this.list.remove(entryRemovedEvent.getBibEntry());
        }
        finally {
            this.unlock();
        }
    }

    @Subscribe
    public void listen(EntryChangedEvent entryChangedEvent) {
        this.lock();
        try {
            for (int i = 0; i < this.list.size(); ++i) {
                if (this.list.get(i) != entryChangedEvent.getBibEntry()) continue;
                this.list.set(i, entryChangedEvent.getBibEntry());
                break;
            }
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        this.list.getReadWriteLock().writeLock().lock();
    }

    private void unlock() {
        this.list.getReadWriteLock().writeLock().unlock();
    }
}

